/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.managers;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrCommunityQuest plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        String prefix = this.messagesConfig.getString("MrCommunityQuest.Prefix", "{#8C8C8C>}&lMrCommunityQuest{#B5B5B5<} &8| ");
        message = message.replace("{Prefix}", prefix);
        return ColorSystem.colorize(message);
    }

    public String getMessage(String path, String defaultMessage) {
        String message = this.messagesConfig.getString(path, defaultMessage);
        String prefix = this.messagesConfig.getString("MrCommunityQuest.Prefix", "{#8C8C8C>}&lMrCommunityQuest{#B5B5B5<} &8| ");
        message = message.replace("{Prefix}", prefix);
        return ColorSystem.colorize(message);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

