/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.DataManager;
import eu.mrneznamy.mrcommunityquest.data.PlayerData;
import eu.mrneznamy.mrcommunityquest.quests.PlaceholderQuestManager;
import eu.mrneznamy.mrcommunityquest.quests.QuestTracker;
import eu.mrneznamy.mrcommunityquest.rewards.RewardsManager;
import eu.mrneznamy.mrcommunityquest.utils.VersionDetector;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommunityQuestManager
implements Listener {
    private final MrCommunityQuest plugin;
    private final DataManager dataManager;
    private final QuestTracker questTracker;
    private final RewardsManager rewardsManager;
    private final PlaceholderQuestManager placeholderQuestManager;

    public CommunityQuestManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.dataManager = new DataManager(plugin);
        this.questTracker = new QuestTracker(plugin);
        this.rewardsManager = new RewardsManager(plugin);
        this.placeholderQuestManager = new PlaceholderQuestManager(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean hasPlayerParticipated(UUID playerId) {
        PlayerData playerData = this.dataManager.getPlayerData(playerId);
        return playerData.hasParticipated();
    }

    public int getPlayerBlockBreakCount(UUID playerId) {
        PlayerData playerData = this.dataManager.getPlayerData(playerId);
        return playerData.getBlocksBroken();
    }

    public PlayerData getPlayerData(UUID playerId) {
        return this.dataManager.getPlayerData(playerId);
    }

    public boolean isDonateQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "Vault");
                if (!"DONATE".equalsIgnoreCase(provider) || !"Vault".equalsIgnoreCase(type) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExpDonateQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "Vault");
                if (!"DONATE".equalsIgnoreCase(provider) || !"EXP".equalsIgnoreCase(type) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLevelDonateQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "Vault");
                if (!"DONATE".equalsIgnoreCase(provider) || !"LEVELS".equalsIgnoreCase(type) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNuVotifierQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                String provider;
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null || !"NUVOTIFIER".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA")) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMrUltimateShopQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                String provider;
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null || !"MRULTIMATESHOP".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA")) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void processDonation(Player player, double amount) {
        this.processDonation(player, amount, null);
    }

    public void processDonation(Player player, double amount, String questId) {
        UUID playerId = player.getUniqueId();
        String targetQuestId = this.findActiveDonateQuest(questId, "Vault");
        if (targetQuestId == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        if (!this.canPlayerParticipateInQuest(player, targetQuestId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.no-permission"));
            return;
        }
        if (!this.takeMoneyFromPlayer(player, amount, targetQuestId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.insufficient-funds"));
            return;
        }
        PlayerData playerData = this.dataManager.getPlayerData(playerId);
        playerData.addDonateAmount(amount);
        this.dataManager.savePlayerData(playerId);
        this.updateDonateQuestProgress(playerId, amount, "Vault", targetQuestId);
    }

    public void processExpDonation(Player player, int amount) {
        this.processExpDonation(player, amount, null);
    }

    public void processExpDonation(Player player, int amount, String questId) {
        UUID playerId = player.getUniqueId();
        String targetQuestId = this.findActiveDonateQuest(questId, "EXP");
        if (targetQuestId == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        if (!this.canPlayerParticipateInQuest(player, targetQuestId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.no-permission"));
            return;
        }
        if (player.getTotalExperience() < amount) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.insufficient-funds"));
            return;
        }
        player.giveExp(-amount);
        PlayerData playerData = this.dataManager.getPlayerData(playerId);
        playerData.addExpDonateAmount(amount);
        this.dataManager.savePlayerData(playerId);
        this.updateDonateQuestProgress(playerId, amount, "EXP", targetQuestId);
    }

    public void processLevelDonation(Player player, int amount) {
        this.processLevelDonation(player, amount, null);
    }

    public void processLevelDonation(Player player, int amount, String questId) {
        UUID playerId = player.getUniqueId();
        String targetQuestId = this.findActiveDonateQuest(questId, "LEVELS");
        if (targetQuestId == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        if (!this.canPlayerParticipateInQuest(player, targetQuestId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.no-permission"));
            return;
        }
        if (player.getLevel() < amount) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.insufficient-funds"));
            return;
        }
        player.setLevel(player.getLevel() - amount);
        PlayerData playerData = this.dataManager.getPlayerData(playerId);
        playerData.addLevelDonateAmount(amount);
        this.dataManager.savePlayerData(playerId);
        this.updateDonateQuestProgress(playerId, amount, "LEVELS", targetQuestId);
    }

    public void updateMrUltimateShopPurchaseQuests(UUID playerId, String itemMaterial, int quantity, double price) {
        this.updateMrUltimateShopQuests(playerId, itemMaterial, quantity, price, "PURCHASE");
    }

    public void updateMrUltimateShopSaleQuests(UUID playerId, String itemMaterial, int quantity, double price) {
        this.updateMrUltimateShopQuests(playerId, itemMaterial, quantity, price, "SALE");
    }

    private void updateMrUltimateShopQuests(UUID playerId, String itemMaterial, int quantity, double price, String action) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        boolean foundMatchingQuests = false;
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"MRULTIMATESHOP".equalsIgnoreCase(provider) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            foundMatchingQuests = true;
            if (!type.equalsIgnoreCase(action) || !itemOrMob.isEmpty() && !itemOrMob.equalsIgnoreCase(itemMaterial)) continue;
            int progressAmount = questSection.getBoolean("TrackByPrice", false) ? (int)price : quantity;
            this.questTracker.updateProgress(questKey, playerId, progressAmount);
            if (!this.questTracker.isQuestCompleted(questKey)) continue;
            this.rewardsManager.distributeRewards(questKey);
            this.questTracker.saveQuestProgress();
            this.questTracker.resetQuestProgress(questKey);
            if (this.plugin.getProgressMessageManager() != null) {
                this.plugin.getProgressMessageManager().resetQuestThresholds(questKey);
            }
            if (this.plugin.getQuestGUI() != null) {
                this.plugin.getQuestGUI().endQuest(questKey);
            }
            String questName = questSection.getString("QuestName", "Quest " + questKey);
            if (this.plugin.getServer() == null || this.plugin.getMessageManager() == null) continue;
            this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
        }
        if (!foundMatchingQuests) {
            // empty if block
        }
    }

    public void updateMrUltimateFishingFishCatchQuests(UUID playerId, String fishId, String rarity) {
        this.updateMrUltimateFishingQuests(playerId, "CATCHED_CUSTOM_FISH", fishId, 1, 0.0, rarity);
    }

    public void updateMrUltimateFishingFishGuttingQuests(UUID playerId, int fishCount, int fishScales) {
        this.updateMrUltimateFishingQuests(playerId, "GUTTED_FISHES", "", fishCount, 0.0, null);
        this.updateMrUltimateFishingQuests(playerId, "EARNED_FISH_SCALES_FROM_GUTTING", "", fishScales, 0.0, null);
    }

    public void updateMrUltimateFishingFishSellingQuests(UUID playerId, int fishCount, double moneyEarned) {
        this.updateMrUltimateFishingQuests(playerId, "SELLED_FISHES", "", fishCount, 0.0, null);
        this.updateMrUltimateFishingQuests(playerId, "EARNED_MONEY_FROM_SELL_FISH", "", 0, moneyEarned, null);
    }

    public void updateMrUltimateFishingTotemActivationQuests(UUID playerId) {
        this.updateMrUltimateFishingQuests(playerId, "TOTEM_ACTIVATED", "", 1, 0.0, null);
    }

    public void updateMrUltimateFishingEnchantCraftingQuests(UUID playerId, String enchantName) {
        this.updateMrUltimateFishingQuests(playerId, "ENCHANT_CRAFTED", enchantName, 1, 0.0, null);
    }

    public void updateMrUltimateFishingEnchantApplicationQuests(UUID playerId, String enchantName) {
        this.updateMrUltimateFishingQuests(playerId, "APPLY_ENCHANT", enchantName, 1, 0.0, null);
    }

    public void updateMrUltimateFishingProcessUpgradeQuests(UUID playerId, String upgradeType) {
        this.updateMrUltimateFishingQuests(playerId, "PROCESS_UPGRADE", upgradeType, 1, 0.0, null);
    }

    public void updateMrUltimateFishingFishScalesEarningQuests(UUID playerId, int amount) {
        this.updateMrUltimateFishingQuests(playerId, "EARNED_FISH_SCALES", "", amount, 0.0, null);
    }

    public void updateMrUltimateFishingFishLevelEarningQuests(UUID playerId, int levels) {
        this.updateMrUltimateFishingQuests(playerId, "EARNED_FISH_LEVELS", "", levels, 0.0, null);
    }

    public void updateMrUltimateFishingSpecificFishCatchQuests(UUID playerId, String fishId) {
        this.updateMrUltimateFishingQuests(playerId, "CATCH_FISH", fishId, 1, 0.0, null);
    }

    private void updateMrUltimateFishingQuests(UUID playerId, String type, String itemOrMob, int quantity, double value, String rarity) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        boolean foundMatchingQuests = false;
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String questType = questSection.getString("Type", "BREAK");
            String questItemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"MRULTIMATEFISHING".equalsIgnoreCase(provider) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            foundMatchingQuests = true;
            if (!questType.equalsIgnoreCase(type) || !questItemOrMob.isEmpty() && !questItemOrMob.equalsIgnoreCase(itemOrMob) && (rarity == null || !questItemOrMob.equalsIgnoreCase(rarity))) continue;
            int progressAmount = questSection.getBoolean("TrackByValue", false) ? (int)value : quantity;
            this.questTracker.updateProgress(questKey, playerId, progressAmount);
            if (!this.questTracker.isQuestCompleted(questKey)) continue;
            this.rewardsManager.distributeRewards(questKey);
            this.questTracker.saveQuestProgress();
            this.questTracker.resetQuestProgress(questKey);
            if (this.plugin.getProgressMessageManager() != null) {
                this.plugin.getProgressMessageManager().resetQuestThresholds(questKey);
            }
            if (this.plugin.getQuestGUI() != null) {
                this.plugin.getQuestGUI().endQuest(questKey);
            }
            String questName = questSection.getString("QuestName", "Quest " + questKey);
            if (this.plugin.getServer() == null || this.plugin.getMessageManager() == null) continue;
            this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
        }
        if (!foundMatchingQuests) {
            // empty if block
        }
    }

    private boolean canPlayerParticipateInQuest(Player player, String questId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return true;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return true;
        }
        String permission = questSection.getString("Permission", "");
        if (!permission.isEmpty()) {
            return player.hasPermission(permission);
        }
        return true;
    }

    private String findActiveDonateQuest(String questId, String donateType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return null;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            ConfigurationSection questSection;
            if (questId != null && (questSection = questsSection.getConfigurationSection(questId + ".Quest")) != null) {
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "Vault");
                if ("DONATE".equalsIgnoreCase(provider) && type.equalsIgnoreCase(donateType) && this.plugin.getQuestGUI().isQuestActive(questId)) {
                    return questId;
                }
            }
            for (String key : questsSection.getKeys(false)) {
                ConfigurationSection questSection2 = questsSection.getConfigurationSection(key + ".Quest");
                if (questSection2 == null) continue;
                String provider = questSection2.getString("Provider", "VANILLA");
                String type = questSection2.getString("Type", "Vault");
                if (!"DONATE".equalsIgnoreCase(provider) || !type.equalsIgnoreCase(donateType) || !this.plugin.getQuestGUI().isQuestActive(key)) continue;
                return key;
            }
        }
        return null;
    }

    private boolean takeMoneyFromPlayer(Player player, double amount, String questId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return true;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection != null) {
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "Vault");
            if ("DONATE".equalsIgnoreCase(provider) && "Vault".equalsIgnoreCase(type)) {
                if (!this.plugin.getEconomyManager().hasEconomy()) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("quests.economy-not-available"));
                    return false;
                }
                if (!this.plugin.getEconomyManager().hasMoney(player.getName(), amount)) {
                    return false;
                }
                return this.plugin.getEconomyManager().withdrawMoney(player.getName(), amount);
            }
        }
        return true;
    }

    private void updateDonateQuestProgress(UUID playerId, double amount, String donateType, String questId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection != null) {
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "Vault");
            if ("DONATE".equalsIgnoreCase(provider) && type.equalsIgnoreCase(donateType)) {
                this.questTracker.updateProgress(questId, playerId, (int)amount);
                if (this.questTracker.isQuestCompleted(questId)) {
                    this.rewardsManager.distributeRewards(questId);
                    this.questTracker.saveQuestProgress();
                    this.questTracker.resetQuestProgress(questId);
                    if (this.plugin.getProgressMessageManager() != null) {
                        this.plugin.getProgressMessageManager().resetQuestThresholds(questId);
                    }
                    if (this.plugin.getQuestGUI() != null) {
                        this.plugin.getQuestGUI().endQuest(questId);
                    }
                    String questName = questSection.getString("QuestName", "Quest " + questId);
                    if (this.plugin.getServer() != null && this.plugin.getMessageManager() != null) {
                        this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
                    }
                }
            }
        }
    }

    public void saveAllPlayerData() {
        this.dataManager.saveAllPlayerData();
        this.questTracker.saveQuestProgress();
    }

    public QuestTracker getQuestTracker() {
        return this.questTracker;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public RewardsManager getRewardsManager() {
        return this.rewardsManager;
    }

    public PlaceholderQuestManager getPlaceholderQuestManager() {
        return this.placeholderQuestManager;
    }

    public void updateBreakQuestProgress(UUID playerId, String blockType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        if (!VersionDetector.isBlockAvailable(blockType)) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"BREAK".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(blockType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updatePlaceQuestProgress(UUID playerId, String blockType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        if (!VersionDetector.isBlockAvailable(blockType)) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"PLACE".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(blockType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateKillEntityQuestProgress(UUID playerId, String entityType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        if (!VersionDetector.isEntityAvailable(entityType)) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"KILL_ENTITY".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(entityType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateCollectItemQuestProgress(UUID playerId, String itemType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"COLLECT_ITEM".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(itemType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateCraftItemQuestProgress(UUID playerId, String itemType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"CRAFT_ITEM".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(itemType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateSmeltItemQuestProgress(UUID playerId, String itemType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"SMELT_ITEM".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(itemType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateBrewItemQuestProgress(UUID playerId, String potionType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"BREW_ITEM".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(potionType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateCatchQuestProgress(UUID playerId, String entityType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"CATCH".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(entityType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateEnchantItemQuestProgress(UUID playerId, String itemType) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            String itemOrMob = questSection.getString("Item-Or-Mob", "");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"ENCHANT_ITEM".equalsIgnoreCase(type) || !itemOrMob.equalsIgnoreCase(itemType) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateKillPlayerQuestProgress(UUID playerId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "BREAK");
            if (!"VANILLA".equalsIgnoreCase(provider) || !"KILL_PLAYER".equalsIgnoreCase(type) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            this.questTracker.updateProgress(questKey, playerId, 1);
        }
    }

    public void updateMrAuctionsBidAuctionCreationQuests(UUID playerId, ItemStack item, double minimumPrice) {
        this.updateMrAuctionsBidQuests(playerId, "CREATE_AUCTION", item, minimumPrice);
    }

    public void updateMrAuctionsBidItemWithdrawalQuests(UUID playerId, ItemStack item) {
        this.updateMrAuctionsBidQuests(playerId, "WITHDRAW_ITEM", item, 0.0);
    }

    public void updateMrAuctionsBidAuctionEarningsQuests(UUID playerId, double amount) {
        this.updateMrAuctionsBidQuests(playerId, "EARN_MONEY", null, amount);
    }

    private void updateMrAuctionsBidQuests(UUID playerId, String type, ItemStack item, double value) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            this.plugin.getLogger().warning("Quests config is null, cannot update MRAUCTIONSBID quests");
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            this.plugin.getLogger().warning("Quests section is null, cannot update MRAUCTIONSBID quests");
            return;
        }
        boolean foundMatchingQuests = false;
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String questType = questSection.getString("Type", "BREAK");
            if (!"MRAUCTIONSBID".equalsIgnoreCase(provider) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
            foundMatchingQuests = true;
            if (!questType.equalsIgnoreCase(type)) continue;
            int progressAmount = questSection.getBoolean("TrackByValue", false) ? (int)value : 1;
            this.questTracker.updateProgress(questKey, playerId, progressAmount);
            if (!this.questTracker.isQuestCompleted(questKey)) continue;
            this.rewardsManager.distributeRewards(questKey);
            this.questTracker.saveQuestProgress();
            this.questTracker.resetQuestProgress(questKey);
            if (this.plugin.getProgressMessageManager() != null) {
                this.plugin.getProgressMessageManager().resetQuestThresholds(questKey);
            }
            if (this.plugin.getQuestGUI() != null) {
                this.plugin.getQuestGUI().endQuest(questKey);
            }
            String questName = questSection.getString("QuestName", "Quest " + questKey);
            if (this.plugin.getServer() == null || this.plugin.getMessageManager() == null) continue;
            this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
        }
        if (!foundMatchingQuests) {
            // empty if block
        }
    }

    public boolean isMrAuctionsBidQuestActive() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                String provider;
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null || !"MRAUCTIONSBID".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA")) || !this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateMrUltimateJobsLevelQuests(UUID playerId, String jobName, int levelsGained) {
        this.updateMrUltimateJobsQuests(playerId, "GET_LEVEL_IN_JOB", jobName, levelsGained, 0.0);
    }

    public void updateMrUltimateJobsLevelAnyJobQuests(UUID playerId, int levelsGained) {
        this.updateMrUltimateJobsQuests(playerId, "GET_LEVEL", "", levelsGained, 0.0);
    }

    public void updateMrUltimateJobsMoneyQuests(UUID playerId, String jobName, double moneyEarned) {
        this.updateMrUltimateJobsQuests(playerId, "EARN_MONEY_IN_JOB", jobName, 0, moneyEarned);
    }

    public void updateMrUltimateJobsMoneyAnyJobQuests(UUID playerId, double moneyEarned) {
        this.updateMrUltimateJobsQuests(playerId, "EARN_MONEY", "", 0, moneyEarned);
    }

    private void updateMrUltimateJobsQuests(UUID playerId, String type, String jobName, int levels, double money) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String questType = questSection.getString("Type", "");
            String questJob = questSection.getString("Job", "");
            if (!"MRULTIMATEJOBS".equalsIgnoreCase(provider) || !this.plugin.getQuestGUI().isQuestActive(questKey) || !questType.equalsIgnoreCase(type) || !questJob.isEmpty() && !questJob.equalsIgnoreCase(jobName)) continue;
            boolean trackByValue = questSection.getBoolean("TrackByValue", false);
            int progressAmount = 0;
            if (type.equalsIgnoreCase("EARN_MONEY_IN_JOB") || type.equalsIgnoreCase("EARN_MONEY")) {
                progressAmount = trackByValue ? (int)Math.floor(money) : 1;
            } else if (type.equalsIgnoreCase("GET_LEVEL_IN_JOB") || type.equalsIgnoreCase("GET_LEVEL")) {
                int n = progressAmount = trackByValue ? levels : 1;
            }
            if (progressAmount <= 0) continue;
            this.questTracker.updateProgress(questKey, playerId, progressAmount);
            if (!this.questTracker.isQuestCompleted(questKey)) continue;
            this.rewardsManager.distributeRewards(questKey);
            this.questTracker.saveQuestProgress();
            this.questTracker.resetQuestProgress(questKey);
            if (this.plugin.getProgressMessageManager() != null) {
                this.plugin.getProgressMessageManager().resetQuestThresholds(questKey);
            }
            if (this.plugin.getQuestGUI() != null) {
                this.plugin.getQuestGUI().endQuest(questKey);
            }
            String questName = questSection.getString("QuestName", "Quest " + questKey);
            if (this.plugin.getServer() == null || this.plugin.getMessageManager() == null) continue;
            this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
        }
    }
}

