/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import org.bukkit.configuration.file.FileConfiguration;

public class Quest {
    private final String id;
    private final FileConfiguration config;

    public Quest(String id, FileConfiguration config) {
        this.id = id;
        this.config = config;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.config.getString("name", this.id);
    }

    public String getDescription() {
        return this.config.getString("description", "");
    }

    public String getType() {
        return this.config.getString("type", "default");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getPermission() {
        return this.config.getString("Permission", "");
    }

    public int getRequiredKills() {
        return this.config.getInt("requirements.kills", 0);
    }

    public String getRequiredMobType() {
        return this.config.getString("requirements.mob-type", "");
    }

    public int getRequiredBlocksMined() {
        return this.config.getInt("requirements.blocks-mined", 0);
    }

    public String getRequiredBlockType() {
        return this.config.getString("requirements.block-type", "");
    }

    public int getRequiredItemsCollected() {
        return this.config.getInt("requirements.items-collected", 0);
    }

    public String getRequiredItemType() {
        return this.config.getString("requirements.item-type", "");
    }

    public double getRewardMoney() {
        return this.config.getDouble("rewards.money", 0.0);
    }

    public int getRewardExperience() {
        return this.config.getInt("rewards.experience", 0);
    }

    public String getRewardCommand() {
        return this.config.getString("rewards.command", "");
    }
}

