/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.commands;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommunityQuestCommand
implements CommandExecutor,
TabCompleter {
    private final MrCommunityQuest plugin;

    public CommunityQuestCommand(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.plugin.getQuestGUI().openQuestMenu((Player)sender);
                return true;
            }
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players.")));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "donate": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players.")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
            case "donateexp": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players.")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateExpCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateExpCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
            case "donatelevel": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players.")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateLevelCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateLevelCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
        return true;
    }

    private void handleDonateCommand(Player player, String amountStr, String questId) {
        double amount;
        if (!this.plugin.getQuestManager().isDonateQuestActive()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processDonation(player, amount, questId);
        player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-success").replace("[amount]", String.valueOf(amount)));
    }

    private void handleDonateExpCommand(Player player, String amountStr, String questId) {
        int amount;
        if (!this.plugin.getQuestManager().isExpDonateQuestActive()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processExpDonation(player, amount, questId);
        player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-exp-success").replace("[amount]", String.valueOf(amount)));
    }

    private void handleDonateLevelCommand(Player player, String amountStr, String questId) {
        int amount;
        if (!this.plugin.getQuestManager().isLevelDonateQuestActive()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processLevelDonation(player, amount, questId);
        player.sendMessage(this.plugin.getMessageManager().getMessage("quests.donate-level-success").replace("[amount]", String.valueOf(amount)));
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.header")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.main")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.help")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.donate")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.donate-exp")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.donate-level")));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> completions = Arrays.asList("help", "donate", "donateexp", "donatelevel");
            return this.filterCompletions(completions, args[0]);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("donate") || args[0].equalsIgnoreCase("donateexp") || args[0].equalsIgnoreCase("donatelevel"))) {
            Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
            if (activeQuests.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> questIds = new ArrayList<String>(activeQuests.keySet());
            return this.filterCompletions(questIds, args[1]);
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> completions, String arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(arg.toLowerCase())) continue;
            result.add(completion);
        }
        return result;
    }
}

