/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.gui;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.gui.QuestGUIHolder;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private final MrCommunityQuest plugin;

    public GUIListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        if (!this.isQuestGUI(inventory)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta != null && meta.hasDisplayName() && meta.getDisplayName().equals(" ")) {
            return;
        }
    }

    private boolean isQuestGUI(Inventory inventory) {
        try {
            return QuestGUIHolder.isQuestGUI(inventory, (Plugin)this.plugin);
        }
        catch (Exception exception) {
            try {
                if (inventory.getHolder() instanceof QuestGUIHolder) {
                    return true;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                String guiTitle = inventory.getViewers().isEmpty() ? "" : ((HumanEntity)inventory.getViewers().get(0)).getOpenInventory().getTitle();
                String expectedTitle = this.plugin.getGUIConfig().getString("MrCommunityQuest.Quests.title", "{#8C8C8C>}&lQUESTS{#B5B5B5<} &8| &fCurrently Active Quests");
                expectedTitle = ColorSystem.colorize(expectedTitle);
                expectedTitle = this.truncateTitleWithColorCodes(expectedTitle, 32);
                String fallbackTitle = ColorSystem.colorize(this.plugin.getMessageManager().getMessage("quests.active-quests"));
                if (fallbackTitle.length() > 32) {
                    fallbackTitle = fallbackTitle.substring(0, 32);
                }
                return guiTitle.equals(expectedTitle) || guiTitle.equals(fallbackTitle);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private String truncateTitleWithColorCodes(String title, int maxLength) {
        if (title.length() <= maxLength) {
            return title;
        }
        StringBuilder result = new StringBuilder();
        int visibleLength = 0;
        for (int i = 0; i < title.length() && visibleLength < maxLength; ++i) {
            char c = title.charAt(i);
            if (c == '\u00a7' && i + 1 < title.length()) {
                result.append(c).append(title.charAt(i + 1));
                ++i;
                continue;
            }
            result.append(c);
            ++visibleLength;
        }
        return result.toString();
    }
}

