/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.gui;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.gui.QuestGUIHolder;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class QuestGUI {
    private final MrCommunityQuest plugin;
    private final Map<String, Long> activeQuests;
    private final Random random;
    private final Map<UUID, String> playerNameCache = new HashMap<UUID, String>();

    public QuestGUI(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.activeQuests = new HashMap<String, Long>();
        this.random = new Random();
        this.loadActiveQuestsFromPersistentData();
    }

    private void loadActiveQuestsFromPersistentData() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            if (!this.plugin.getQuestProgressManager().isQuestActive(questKey)) continue;
            long endTime = this.plugin.getQuestProgressManager().getQuestEndTime(questKey);
            this.activeQuests.put(questKey, endTime);
        }
    }

    public void openQuestMenu(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Map<String, Long> allActiveQuests = this.getActiveQuests();
                ConfigurationSection questsSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests");
                if (questsSection == null || allActiveQuests.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.plugin.getMessageManager().getMessage("quests.no-active-quests")));
                    return;
                }
                HashMap<String, ConfigurationSection> activeQuestSections = new HashMap<String, ConfigurationSection>();
                for (String questKey : allActiveQuests.keySet()) {
                    ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                    if (questSection == null) continue;
                    activeQuestSections.put(questKey, questSection);
                }
                if (activeQuestSections.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.plugin.getMessageManager().getMessage("quests.no-active-quests")));
                    return;
                }
                ConfigurationSection guiSection = this.plugin.getGUIConfig().getConfigurationSection("MrCommunityQuest.Quests");
                if (guiSection == null) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.plugin.getMessageManager().getMessage("quests.gui-config-not-found")));
                    return;
                }
                String title = guiSection.getString("title", "&6Quests");
                title = ColorSystem.colorize(title);
                if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                    title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
                }
                title = this.truncateTitleWithColorCodes(title, 32);
                int size = guiSection.getInt("size", 54);
                ConfigurationSection finalGuiSection = guiSection;
                HashMap<String, ConfigurationSection> finalActiveQuestSections = activeQuestSections;
                String finalTitle = title;
                int finalSize = size;
                Player finalPlayer = player;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        QuestGUIHolder holder = new QuestGUIHolder((Plugin)this.plugin);
                        Inventory gui = Bukkit.createInventory((InventoryHolder)holder, (int)finalSize, (String)finalTitle);
                        holder.setInventory(gui);
                        this.addDecorations(gui, finalGuiSection);
                        this.addQuestItems(gui, finalGuiSection, finalActiveQuestSections, finalPlayer.getUniqueId());
                        finalPlayer.openInventory(gui);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error opening quest menu: " + e.getMessage());
                        finalPlayer.sendMessage(this.plugin.getMessageManager().getMessage("quests.gui-config-not-found"));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error preparing quest menu: " + e.getMessage());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.plugin.getMessageManager().getMessage("quests.gui-config-not-found")));
            }
        });
    }

    private void addDecorations(Inventory gui, ConfigurationSection guiSection) {
        ConfigurationSection decorationsSection = guiSection.getConfigurationSection("decorations");
        if (decorationsSection == null) {
            return;
        }
        for (String decorationKey : decorationsSection.getKeys(false)) {
            ItemStack item;
            ItemMeta meta;
            ConfigurationSection decoration = decorationsSection.getConfigurationSection(decorationKey);
            if (decoration == null) continue;
            String materialName = decoration.getString("material", "BLACK_STAINED_GLASS_PANE");
            Material material = Material.matchMaterial((String)materialName, (boolean)false);
            if (material == null) {
                material = Material.BLACK_STAINED_GLASS_PANE;
            }
            if ((meta = (item = new ItemStack(material, 1)).getItemMeta()) != null) {
                String displayName = decoration.getString("display-name", " ");
                meta.setDisplayName(ColorSystem.colorize(displayName));
                if (decoration.contains("custom-model-data")) {
                    if (decoration.isConfigurationSection("custom-model-data")) {
                        int customModelData;
                        ConfigurationSection customModelDataSection = decoration.getConfigurationSection("custom-model-data");
                        if (customModelDataSection != null && customModelDataSection.getBoolean("enabled", false) && (customModelData = customModelDataSection.getInt("value", 0)) > 0) {
                            meta.setCustomModelData(Integer.valueOf(customModelData));
                        }
                    } else {
                        int customModelData = decoration.getInt("custom-model-data", -1);
                        if (customModelData > 0) {
                            meta.setCustomModelData(Integer.valueOf(customModelData));
                        }
                    }
                }
                item.setItemMeta(meta);
            }
            List<Integer> slots = this.parseSlots(decoration.getString("slots", ""));
            for (int slot : slots) {
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, item.clone());
            }
        }
    }

    private void addQuestItems(Inventory gui, ConfigurationSection guiSection, Map<String, ConfigurationSection> activeQuests, UUID playerId) {
        ConfigurationSection itemsSection = guiSection.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        ConfigurationSection questsConfig = itemsSection.getConfigurationSection("Quests");
        if (questsConfig == null) {
            return;
        }
        String currentMethod = questsConfig.getString("current-method", "OLD");
        HashMap<UUID, String> playerNameCache = new HashMap<UUID, String>();
        if ("NEW".equalsIgnoreCase(currentMethod)) {
            this.addQuestItemsNewMethod(gui, questsConfig, activeQuests, playerId, playerNameCache);
        } else {
            this.addQuestItemsOldMethod(gui, questsConfig, activeQuests, playerId, playerNameCache);
        }
    }

    private void addQuestItemsOldMethod(Inventory gui, ConfigurationSection questsConfig, Map<String, ConfigurationSection> activeQuests, UUID playerId, Map<UUID, String> playerNameCache) {
        List<Integer> availableSlots = this.parseSlots(questsConfig.getString("slots", ""));
        int slotIndex = 0;
        for (Map.Entry<String, ConfigurationSection> entry : activeQuests.entrySet()) {
            String questKey = entry.getKey();
            ConfigurationSection questSection = entry.getValue();
            if (slotIndex >= availableSlots.size()) break;
            ItemStack questItem = this.createQuestItem(questKey, questSection, playerId, playerNameCache);
            if (questItem == null) continue;
            int slot = availableSlots.get(slotIndex);
            if (slot >= 0 && slot < gui.getSize()) {
                gui.setItem(slot, questItem);
            }
            ++slotIndex;
        }
    }

    private void addQuestItemsNewMethod(Inventory gui, ConfigurationSection questsConfig, Map<String, ConfigurationSection> activeQuests, UUID playerId, Map<UUID, String> playerNameCache) {
        ConfigurationSection newSlotsSection = questsConfig.getConfigurationSection("new-slots");
        if (newSlotsSection == null) {
            this.addQuestItemsOldMethod(gui, questsConfig, activeQuests, playerId, playerNameCache);
            return;
        }
        ArrayList<Map.Entry<String, ConfigurationSection>> questsList = new ArrayList<Map.Entry<String, ConfigurationSection>>(activeQuests.entrySet());
        Collections.shuffle(questsList, this.random);
        int questIndex = 1;
        for (Map.Entry entry : questsList) {
            ConfigurationSection questSection;
            String questKey = (String)entry.getKey();
            ItemStack questItem = this.createQuestItem(questKey, questSection = (ConfigurationSection)entry.getValue(), playerId, playerNameCache);
            if (questItem == null) continue;
            List questSlots = newSlotsSection.getIntegerList(String.valueOf(questIndex));
            if (!questSlots.isEmpty()) {
                Iterator iterator = questSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot < 0 || slot >= gui.getSize()) continue;
                    gui.setItem(slot, questItem.clone());
                }
            }
            ++questIndex;
        }
    }

    private ItemStack createQuestItem(String questKey, ConfigurationSection questSection, UUID playerId, Map<UUID, String> playerNameCache) {
        ItemStack questItem;
        ItemMeta meta;
        ConfigurationSection questMenuSection = questSection.getConfigurationSection("QuestMenu");
        if (questMenuSection == null) {
            return null;
        }
        String materialName = questMenuSection.getString("Material", "BOOK");
        Material material = Material.matchMaterial((String)materialName, (boolean)false);
        if (material == null) {
            material = Material.BOOK;
        }
        if ((meta = (questItem = new ItemStack(material, 1)).getItemMeta()) != null) {
            int n;
            Long endTime;
            String displayName = questMenuSection.getString("Name", "&eQuest " + questKey);
            meta.setDisplayName(ColorSystem.colorize(displayName));
            if (questMenuSection.contains("custom-model-data")) {
                if (questMenuSection.isConfigurationSection("custom-model-data")) {
                    int customModelData;
                    ConfigurationSection customModelDataSection = questMenuSection.getConfigurationSection("custom-model-data");
                    if (customModelDataSection != null && customModelDataSection.getBoolean("enabled", false) && (customModelData = customModelDataSection.getInt("value", 0)) > 0) {
                        meta.setCustomModelData(Integer.valueOf(customModelData));
                    }
                } else {
                    int customModelData = questMenuSection.getInt("custom-model-data", -1);
                    if (customModelData > 0) {
                        meta.setCustomModelData(Integer.valueOf(customModelData));
                    }
                }
            }
            int playerProgress = this.plugin.getQuestManager().getQuestTracker().getPlayerProgress(questKey, playerId);
            int totalProgress = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questKey).values().stream().mapToInt(Integer::intValue).sum();
            int requiredAmount = questSection.getInt("Amount", 0);
            long timeRemaining = 0L;
            if (this.activeQuests.containsKey(questKey) && (endTime = this.activeQuests.get(questKey)) != null) {
                timeRemaining = Math.max(0L, (endTime - System.currentTimeMillis()) / 1000L);
            }
            Map<UUID, Integer> progressMap = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questKey);
            ArrayList<Map.Entry<UUID, Integer>> sortedProgress = new ArrayList<Map.Entry<UUID, Integer>>(progressMap.entrySet());
            Collections.sort(sortedProgress, (e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
            for (Map.Entry entry : sortedProgress) {
                if (playerNameCache.containsKey(entry.getKey())) continue;
                String playerName = this.getCachedPlayerName((UUID)entry.getKey());
                playerNameCache.put((UUID)entry.getKey(), playerName);
            }
            int playerPosition = -1;
            int n2 = playerProgress;
            for (int i = 0; i < sortedProgress.size(); ++i) {
                if (!((UUID)((Map.Entry)sortedProgress.get(i)).getKey()).equals(playerId)) continue;
                playerPosition = i + 1;
                n = (Integer)((Map.Entry)sortedProgress.get(i)).getValue();
                break;
            }
            if (playerPosition == -1) {
                playerPosition = sortedProgress.size() + 1;
            }
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : questMenuSection.getStringList("Lore")) {
                line = line.replace("[progress]", String.valueOf(totalProgress)).replace("[amount]", String.valueOf(requiredAmount)).replace("[percentage]", String.format("%.1f", requiredAmount > 0 ? (double)totalProgress * 100.0 / (double)requiredAmount : 0.0)).replace("[time]", String.valueOf(timeRemaining)).replace("[My-Position]", String.valueOf(playerPosition)).replace("[My-Amount]", String.valueOf(n));
                for (int i = 1; i <= 10; ++i) {
                    if (sortedProgress.size() >= i) {
                        Map.Entry playerEntry = (Map.Entry)sortedProgress.get(i - 1);
                        String playerName = playerNameCache.get(playerEntry.getKey());
                        line = line.replace("[PlayerName-" + i + "]", playerName);
                        line = line.replace("[Amount-" + i + "]", String.valueOf(playerEntry.getValue()));
                        continue;
                    }
                    line = line.replace("[PlayerName-" + i + "]", "None");
                    line = line.replace("[Amount-" + i + "]", "0");
                }
                lore.add(ColorSystem.colorize(line));
            }
            meta.setLore(lore);
            questItem.setItemMeta(meta);
        }
        return questItem;
    }

    private List<Integer> parseSlots(String slotsString) {
        String[] parts;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (slotsString.isEmpty()) {
            return slots;
        }
        for (String part : parts = slotsString.split(",")) {
            if ((part = part.trim()).contains("-")) {
                String[] range = part.split("-");
                if (range.length != 2) continue;
                try {
                    int start = Integer.parseInt(range[0].trim());
                    int end = Integer.parseInt(range[1].trim());
                    for (int i = start; i <= end; ++i) {
                        slots.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            try {
                slots.add(Integer.parseInt(part));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    public void startQuest(String questId, long durationSeconds) {
        long endTime = System.currentTimeMillis() + durationSeconds * 1000L;
        this.activeQuests.put(questId, endTime);
        this.plugin.getQuestProgressManager().setQuestEndTime(questId, endTime);
        this.plugin.getQuestProgressManager().saveProgress();
    }

    public void endQuest(String questId) {
        this.activeQuests.remove(questId);
        if (this.plugin.getQuestProgressManager() != null) {
            this.plugin.getQuestProgressManager().removeQuestProgress(questId);
            this.plugin.getQuestProgressManager().saveProgress();
        }
        if (this.plugin.getQuestManager() != null && this.plugin.getQuestManager().getQuestTracker() != null) {
            this.plugin.getQuestManager().getQuestTracker().resetQuestProgress(questId);
        }
    }

    public boolean isQuestActive(String questId) {
        if (this.activeQuests.containsKey(questId) && this.activeQuests.get(questId) > System.currentTimeMillis()) {
            return true;
        }
        return this.plugin.getQuestProgressManager().isQuestActive(questId);
    }

    public Map<String, Long> getActiveQuests() {
        ConfigurationSection questsSection;
        FileConfiguration questsConfig;
        this.activeQuests.entrySet().removeIf(entry -> (Long)entry.getValue() <= System.currentTimeMillis());
        HashMap<String, Long> allActiveQuests = new HashMap<String, Long>(this.activeQuests);
        if (allActiveQuests.isEmpty() && (questsConfig = this.plugin.getQuestsConfig()) != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            for (String questKey : questsSection.getKeys(false)) {
                if (!this.plugin.getQuestProgressManager().isQuestActive(questKey)) continue;
                long endTime = this.plugin.getQuestProgressManager().getQuestEndTime(questKey);
                allActiveQuests.put(questKey, endTime);
                this.activeQuests.put(questKey, endTime);
            }
        }
        return allActiveQuests;
    }

    private String safeSubstring(String str, int maxLength) {
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    private String truncateTitlePreservingColorCodes(String title, int maxLength) {
        if (title.length() <= maxLength) {
            return title;
        }
        StringBuilder result = new StringBuilder();
        int visibleCharCount = 0;
        for (int i = 0; i < title.length() && (visibleCharCount < maxLength || result.length() < maxLength); ++i) {
            char c = title.charAt(i);
            if (c == '\u00a7' && i + 1 < title.length()) {
                if (result.length() + 2 > maxLength) break;
                result.append(c).append(title.charAt(i + 1));
                ++i;
                continue;
            }
            if (visibleCharCount >= maxLength) break;
            result.append(c);
            ++visibleCharCount;
        }
        return result.toString();
    }

    private String truncateTitleWithColorCodes(String title, int maxLength) {
        if (title.length() <= maxLength) {
            return title;
        }
        StringBuilder result = new StringBuilder();
        int visibleLength = 0;
        for (int i = 0; i < title.length() && visibleLength < maxLength; ++i) {
            char c = title.charAt(i);
            if (c == '\u00a7' && i + 1 < title.length()) {
                result.append(c).append(title.charAt(i + 1));
                ++i;
                continue;
            }
            result.append(c);
            ++visibleLength;
        }
        return result.toString();
    }

    private String getCachedPlayerName(UUID playerId) {
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer != null) {
            String name = onlinePlayer.getName();
            this.playerNameCache.put(playerId, name);
            return name;
        }
        if (this.playerNameCache.containsKey(playerId)) {
            return this.playerNameCache.get(playerId);
        }
        String fallbackName = "Player-" + playerId.toString().substring(0, 8);
        this.playerNameCache.put(playerId, fallbackName);
        return fallbackName;
    }
}

