/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.hooks;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    private final MrCommunityQuest plugin;

    public PlaceholderAPIExpansion(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "mrcommunityquests";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String onPlaceholderRequest(Player player, String identifier) {
        if (this.plugin.getQuestsConfig() == null) {
            return "";
        }
        if (identifier.startsWith("active_quest_")) {
            try {
                String[] parts = identifier.split("_");
                if (parts.length < 3) return null;
                if (parts.length == 3 && "quest".equals(parts[1])) {
                    int questNumber = Integer.parseInt(parts[2]);
                    return this.getQuestName(questNumber);
                }
                if (parts.length < 4) return null;
                String type = parts[2];
                if ("position".equals(type) && parts.length >= 5) {
                    int position = Integer.parseInt(parts[3]);
                    int questNumber = Integer.parseInt(parts[4]);
                    return this.getQuestPlayerAtPosition(questNumber, position);
                }
                int questNumber = Integer.parseInt(parts[parts.length - 1]);
                switch (type) {
                    case "completed": {
                        return this.getQuestCompleted(questNumber);
                    }
                    case "required": {
                        return this.getQuestRequired(questNumber);
                    }
                    case "percentage": {
                        return this.getQuestPercentage(questNumber);
                    }
                    case "myposition": {
                        return this.getQuestMyPosition(player, questNumber);
                    }
                    case "myvalue": {
                        return this.getQuestMyValue(player, questNumber);
                    }
                    case "timetoend": {
                        return this.getQuestTimeToEnd(questNumber);
                    }
                    case "progressbar": {
                        return this.getQuestProgressBar(questNumber);
                    }
                }
                return null;
            }
            catch (NumberFormatException e) {
                return "Invalid";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Invalid";
            }
        } else {
            if ("active_quests".equals(identifier)) {
                return String.valueOf(this.getActiveQuestsCount());
            }
            if (!"quests".equals(identifier)) return null;
            return String.valueOf(this.getTotalQuestsCount());
        }
    }

    private String getQuestName(int questNumber) {
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "None";
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return "None";
        }
        String questName = questSection.getString("QuestName", "Quest " + questId);
        return questName;
    }

    private String getQuestCompleted(int questNumber) {
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "0";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null) {
            return "0";
        }
        int totalProgress = contributions.values().stream().mapToInt(Integer::intValue).sum();
        return String.valueOf(totalProgress);
    }

    private String getQuestRequired(int questNumber) {
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return "0";
        }
        int targetAmount = questSection.getInt("Amount", 0);
        return String.valueOf(targetAmount);
    }

    private String getQuestPercentage(int questNumber) {
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "0";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null) {
            return "0";
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return "0";
        }
        int totalProgress = contributions.values().stream().mapToInt(Integer::intValue).sum();
        int targetAmount = questSection.getInt("Amount", 0);
        if (targetAmount <= 0) {
            return "0";
        }
        int percentage = (int)((double)totalProgress * 100.0 / (double)targetAmount);
        return String.valueOf(Math.min(100, percentage));
    }

    private String getQuestMyPosition(Player player, int questNumber) {
        if (player == null) {
            return "0";
        }
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "0";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null || contributions.isEmpty()) {
            return "0";
        }
        TreeMap<Integer, UUID> sortedContributions = new TreeMap<Integer, UUID>((a, b) -> b.compareTo((Integer)a));
        for (Map.Entry<UUID, Integer> entry : contributions.entrySet()) {
            sortedContributions.put(entry.getValue(), entry.getKey());
        }
        int position = 1;
        for (Map.Entry entry : sortedContributions.entrySet()) {
            if (((UUID)entry.getValue()).equals(player.getUniqueId())) {
                return String.valueOf(position);
            }
            ++position;
        }
        return "0";
    }

    private String getQuestMyValue(Player player, int questNumber) {
        if (player == null) {
            return "0";
        }
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "0";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null) {
            return "0";
        }
        Integer playerProgress = contributions.get(player.getUniqueId());
        return playerProgress != null ? String.valueOf(playerProgress) : "0";
    }

    private String getQuestPlayerAtPosition(int questNumber, int position) {
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "None";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "Unknown";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null || contributions.isEmpty()) {
            return "None";
        }
        TreeMap<Integer, UUID> sortedContributions = new TreeMap<Integer, UUID>((a, b) -> b.compareTo((Integer)a));
        for (Map.Entry<UUID, Integer> entry : contributions.entrySet()) {
            sortedContributions.put(entry.getValue(), entry.getKey());
        }
        int currentPosition = 1;
        for (Map.Entry entry : sortedContributions.entrySet()) {
            if (currentPosition == position) {
                String playerName = this.plugin.getServer().getOfflinePlayer((UUID)entry.getValue()).getName();
                return playerName != null ? playerName : "Unknown";
            }
            ++currentPosition;
        }
        return "None";
    }

    private String getQuestTimeToEnd(int questNumber) {
        long timeRemainingMillis;
        Long endTime;
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "0";
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        if (activeQuests != null && (endTime = activeQuests.get(questId)) != null && endTime > 0L && (timeRemainingMillis = endTime - System.currentTimeMillis()) > 0L) {
            long timeRemainingMinutes = timeRemainingMillis / 60000L;
            return String.valueOf(Math.max(0L, timeRemainingMinutes));
        }
        return "0";
    }

    private String getQuestProgressBar(int questNumber) {
        int i;
        String questId = this.getActiveQuestIdByPosition(questNumber);
        if (questId == null) {
            return "";
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return "";
        }
        Map<UUID, Integer> contributions = questManager.getQuestTracker().getQuestProgress(questId);
        if (contributions == null) {
            return "";
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return "";
        }
        int totalProgress = contributions.values().stream().mapToInt(Integer::intValue).sum();
        int targetAmount = questSection.getInt("Amount", 0);
        if (targetAmount <= 0) {
            return "";
        }
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        String filledChar = "\u2588";
        String emptyChar = "\u2591";
        int length = 20;
        if (messagesConfig != null) {
            filledChar = messagesConfig.getString("MrCommunityQuest.Placeholders.ProgressBar.Filled", "\u2588");
            emptyChar = messagesConfig.getString("MrCommunityQuest.Placeholders.ProgressBar.Empty", "\u2591");
            length = messagesConfig.getInt("MrCommunityQuest.Placeholders.ProgressBar.Length", 20);
        }
        double percentage = (double)totalProgress / (double)targetAmount;
        int filledLength = (int)Math.round(percentage * (double)length);
        filledLength = Math.max(0, Math.min(length, filledLength));
        StringBuilder progressBar = new StringBuilder();
        for (i = 0; i < filledLength; ++i) {
            progressBar.append(filledChar);
        }
        for (i = filledLength; i < length; ++i) {
            progressBar.append(emptyChar);
        }
        return progressBar.toString();
    }

    private int getActiveQuestsCount() {
        ConfigurationSection questsSection;
        int activeQuests = 0;
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            for (String questKey : questsSection.getKeys(false)) {
                if (!this.plugin.getQuestGUI().isQuestActive(questKey)) continue;
                ++activeQuests;
            }
        }
        return activeQuests;
    }

    private int getTotalQuestsCount() {
        ConfigurationSection questsSection;
        int totalQuests = 0;
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            totalQuests = questsSection.getKeys(false).size();
        }
        return totalQuests;
    }

    private String getActiveQuestIdByPosition(int position) {
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        if (activeQuests == null || activeQuests.isEmpty()) {
            return null;
        }
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return null;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return null;
        }
        ArrayList<String> activeQuestIds = new ArrayList<String>();
        for (String questKey : questsSection.getKeys(false)) {
            if (!activeQuests.containsKey(questKey)) continue;
            activeQuestIds.add(questKey);
        }
        Collections.sort(activeQuestIds);
        if (position > 0 && position <= activeQuestIds.size()) {
            String result = (String)activeQuestIds.get(position - 1);
            return result;
        }
        return null;
    }
}

