/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.listener;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class PlayerPickupItemListener
implements Listener {
    private final MrCommunityQuest plugin;
    private final CommunityQuestManager questManager;

    public PlayerPickupItemListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.questManager = plugin.getQuestManager();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.isWorldDisabled(event.getPlayer().getWorld().getName())) {
            return;
        }
        String itemType = event.getItem().getItemStack().getType().name();
        this.questManager.updateCollectItemQuestProgress(playerId, itemType);
    }

    private boolean isWorldDisabled(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        if (config == null) {
            return false;
        }
        List disabledWorlds = config.getStringList("MrCommunityQuest.Settings.Disabled-Worlds");
        return disabledWorlds.contains(worldName);
    }
}

