/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.managers;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final MrCommunityQuest plugin;
    private FileConfiguration config;
    private FileConfiguration questsConfig;
    private FileConfiguration guiConfig;

    public ConfigManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public FileConfiguration loadQuestsConfig() {
        File questsFile = new File(this.plugin.getDataFolder(), "quests.yml");
        if (!questsFile.exists()) {
            this.plugin.saveResource("quests.yml", false);
        }
        this.questsConfig = YamlConfiguration.loadConfiguration((File)questsFile);
        InputStream defaultQuestsStream = this.plugin.getResource("quests.yml");
        if (defaultQuestsStream != null) {
            YamlConfiguration defaultQuestsConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultQuestsStream));
            this.questsConfig.setDefaults((Configuration)defaultQuestsConfig);
        }
        return this.questsConfig;
    }

    public FileConfiguration loadGUIConfig() {
        File guiFile = new File(this.plugin.getDataFolder(), "gui.yml");
        if (!guiFile.exists()) {
            this.plugin.saveResource("gui.yml", false);
        }
        this.guiConfig = YamlConfiguration.loadConfiguration((File)guiFile);
        InputStream defaultGuiStream = this.plugin.getResource("gui.yml");
        if (defaultGuiStream != null) {
            YamlConfiguration defaultGuiConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultGuiStream));
            this.guiConfig.setDefaults((Configuration)defaultGuiConfig);
        }
        return this.guiConfig;
    }

    public String getPrefix() {
        return this.config.getString("MrCommunityQuest.Prefix", "{#8C8C8C>}&lMrCommunityQuest{#B5B5B5<} &8| ");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getQuestsConfig() {
        return this.questsConfig;
    }

    public FileConfiguration getGUIConfig() {
        return this.guiConfig;
    }
}

