/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class PlayerQuestData {
    private final UUID playerId;
    private final Set<String> completedQuests;
    private final Set<String> activeQuests;

    public PlayerQuestData(UUID playerId) {
        this.playerId = playerId;
        this.completedQuests = new HashSet<String>();
        this.activeQuests = new HashSet<String>();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public Set<String> getCompletedQuests() {
        return new HashSet<String>(this.completedQuests);
    }

    public Set<String> getActiveQuests() {
        return new HashSet<String>(this.activeQuests);
    }

    public boolean hasCompletedQuest(String questId) {
        return this.completedQuests.contains(questId);
    }

    public boolean hasActiveQuest(String questId) {
        return this.activeQuests.contains(questId);
    }

    public void addCompletedQuest(String questId) {
        this.completedQuests.add(questId);
        this.activeQuests.remove(questId);
    }

    public void addActiveQuest(String questId) {
        this.activeQuests.add(questId);
    }

    public void removeActiveQuest(String questId) {
        this.activeQuests.remove(questId);
    }

    public void removeCompletedQuest(String questId) {
        this.completedQuests.remove(questId);
    }
}

