/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.scheduler;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AutoScheduler {
    private final MrCommunityQuest plugin;
    private BukkitTask schedulerTask;
    private BukkitTask placeholderUpdateTask;
    private final Set<String> usedQuests;

    public AutoScheduler(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.usedQuests = new HashSet<String>();
    }

    public void startScheduler() {
        if (!this.plugin.getConfig().getBoolean("MrCommunityQuest.AutoSchedule.Enabled", true)) {
            return;
        }
        if (this.schedulerTask != null) {
            this.schedulerTask.cancel();
        }
        this.schedulerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAndScheduleQuests, 20L, 600L);
        this.startPlaceholderUpdateTask();
    }

    public void stopScheduler() {
        if (this.schedulerTask != null) {
            this.schedulerTask.cancel();
            this.schedulerTask = null;
        }
        if (this.placeholderUpdateTask != null) {
            this.placeholderUpdateTask.cancel();
            this.placeholderUpdateTask = null;
        }
    }

    private void startPlaceholderUpdateTask() {
        if (this.placeholderUpdateTask != null) {
            this.placeholderUpdateTask.cancel();
        }
        this.placeholderUpdateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::updatePlaceholderQuests, 100L, 100L);
    }

    private void updatePlaceholderQuests() {
        if (this.plugin.getQuestManager() != null && this.plugin.getQuestManager().getPlaceholderQuestManager() != null) {
            this.plugin.getQuestManager().getPlaceholderQuestManager().startPlaceholderUpdateTask();
        }
    }

    private void checkAndScheduleQuests() {
        if (this.plugin.getConfig() == null || !this.plugin.getConfig().getBoolean("MrCommunityQuest.AutoSchedule.Enabled", true)) {
            return;
        }
        int maxActiveQuests = this.plugin.getConfig().getInt("MrCommunityQuest.AutoSchedule.MaxActiveQuests", 2);
        if (this.plugin.getQuestGUI() == null) {
            return;
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        this.checkCompletedOrExpiredQuests(activeQuests);
        int questsNeeded = maxActiveQuests - activeQuests.size();
        if (questsNeeded > 0) {
            this.startRandomQuests(questsNeeded);
        }
    }

    private void checkCompletedOrExpiredQuests(Map<String, Long> activeQuests) {
        if (activeQuests == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<String> completedOrExpiredQuests = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : activeQuests.entrySet()) {
            String questId = entry.getKey();
            Long endTime = entry.getValue();
            if (endTime <= currentTime) {
                completedOrExpiredQuests.add(questId);
                continue;
            }
            if (!this.isQuestCompleted(questId)) continue;
            completedOrExpiredQuests.add(questId);
        }
        for (String questId : completedOrExpiredQuests) {
            this.endQuest(questId);
        }
    }

    private boolean isQuestCompleted(String questId) {
        if (this.plugin.getQuestsConfig() == null) {
            return false;
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return false;
        }
        if (this.plugin.getQuestManager() == null || this.plugin.getQuestManager().getQuestTracker() == null) {
            return false;
        }
        int requiredAmount = questSection.getInt("Amount", 0);
        Map<UUID, Integer> questProgress = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId);
        if (questProgress == null) {
            return false;
        }
        int totalProgress = questProgress.values().stream().mapToInt(Integer::intValue).sum();
        return totalProgress >= requiredAmount;
    }

    private void endQuest(String questId) {
        ConfigurationSection questSection;
        if (this.plugin.getRewardsManager() == null || this.plugin.getQuestGUI() == null) {
            return;
        }
        if (this.plugin.getQuestManager() != null && this.plugin.getQuestManager().getPlaceholderQuestManager() != null) {
            this.plugin.getQuestManager().getPlaceholderQuestManager().cleanupQuest(questId);
        }
        this.plugin.getRewardsManager().distributeRewards(questId);
        if (this.plugin.getQuestManager() != null && this.plugin.getQuestManager().getQuestTracker() != null) {
            this.plugin.getQuestManager().getQuestTracker().saveQuestProgress();
        }
        this.plugin.getQuestGUI().endQuest(questId);
        this.usedQuests.remove(questId);
        if (this.plugin.getQuestsConfig() != null && (questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest")) != null) {
            String questName = questSection.getString("QuestName", "Quest " + questId);
            boolean completed = this.isQuestCompleted(questId);
            if (this.plugin.getServer() != null && this.plugin.getMessageManager() != null) {
                if (completed) {
                    this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
                } else {
                    this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-expired-broadcast").replace("[quest]", questName));
                }
            }
        }
        if (this.plugin.getProgressMessageManager() != null) {
            this.plugin.getProgressMessageManager().resetQuestThresholds(questId);
        }
    }

    private void startRandomQuests(int count) {
        if (this.plugin.getQuestsConfig() == null || this.plugin.getQuestGUI() == null) {
            return;
        }
        ConfigurationSection questsSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        HashSet<String> availableQuests = new HashSet<String>(questsSection.getKeys(false));
        availableQuests.removeAll(this.plugin.getQuestGUI().getActiveQuests().keySet());
        availableQuests.removeAll(this.usedQuests);
        if (availableQuests.isEmpty()) {
            this.usedQuests.clear();
            availableQuests.addAll(questsSection.getKeys(false));
            availableQuests.removeAll(this.plugin.getQuestGUI().getActiveQuests().keySet());
        }
        this.filterDonateQuests(availableQuests, questsSection);
        ArrayList<String> questList = new ArrayList<String>(availableQuests);
        Collections.shuffle(questList);
        int started = 0;
        for (String questId : questList) {
            if (started >= count) break;
            ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
            if (questSection == null) continue;
            int durationMinutes = questSection.getInt("TimeToEndQuest", 600);
            long durationSeconds = (long)durationMinutes * 60L;
            String provider = questSection.getString("Provider", "VANILLA");
            if ("PLACEHOLDERAPI".equalsIgnoreCase(provider) && this.plugin.getQuestManager() != null && this.plugin.getQuestManager().getPlaceholderQuestManager() != null) {
                this.plugin.getQuestManager().getPlaceholderQuestManager().initializeQuest(questId);
            }
            this.plugin.getQuestGUI().startQuest(questId, durationSeconds);
            this.usedQuests.add(questId);
            if (this.plugin.getServer() != null && this.plugin.getMessageManager() != null) {
                String questName = questSection.getString("QuestName", "Quest " + questId);
                this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-started-broadcast").replace("[quest]", questName).replace("[duration]", String.valueOf(durationMinutes)));
            }
            ++started;
        }
    }

    private void filterDonateQuests(Set<String> availableQuests, ConfigurationSection questsSection) {
        boolean vaultQuestActive = this.isDonateQuestTypeActive("Vault");
        boolean expQuestActive = this.isDonateQuestTypeActive("EXP");
        boolean levelsQuestActive = this.isDonateQuestTypeActive("LEVELS");
        boolean nuvotifierQuestActive = this.isNuVotifierQuestActive();
        boolean mrUltimateShopQuestActive = this.isMrUltimateShopQuestActive();
        Iterator<String> iterator = availableQuests.iterator();
        while (iterator.hasNext()) {
            String questId = iterator.next();
            ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
            if (questSection == null) continue;
            String provider = questSection.getString("Provider", "VANILLA");
            String type = questSection.getString("Type", "Vault");
            if ("DONATE".equalsIgnoreCase(provider)) {
                if (!("Vault".equalsIgnoreCase(type) && vaultQuestActive || "EXP".equalsIgnoreCase(type) && expQuestActive) && (!"LEVELS".equalsIgnoreCase(type) || !levelsQuestActive)) continue;
                iterator.remove();
                continue;
            }
            if ("NUVOTIFIER".equalsIgnoreCase(provider) && nuvotifierQuestActive) {
                iterator.remove();
                continue;
            }
            if (!"MRULTIMATESHOP".equalsIgnoreCase(provider) || !mrUltimateShopQuestActive) continue;
            iterator.remove();
        }
    }

    private boolean isMrUltimateShopQuestActive() {
        ConfigurationSection questsSection;
        if (this.plugin.getQuestManager() != null) {
            return this.plugin.getQuestManager().isMrUltimateShopQuestActive();
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            for (String questId : activeQuests.keySet()) {
                String provider;
                ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
                if (questSection == null || !"MRULTIMATESHOP".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNuVotifierQuestActive() {
        ConfigurationSection questsSection;
        if (this.plugin.getQuestManager() != null) {
            return this.plugin.getQuestManager().isNuVotifierQuestActive();
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            for (String questId : activeQuests.keySet()) {
                String provider;
                ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
                if (questSection == null || !"NUVOTIFIER".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDonateQuestTypeActive(String donateType) {
        ConfigurationSection questsSection;
        if (this.plugin.getQuestManager() != null) {
            switch (donateType.toUpperCase()) {
                case "VAULT": {
                    return this.plugin.getQuestManager().isDonateQuestActive();
                }
                case "EXP": {
                    return this.plugin.getQuestManager().isExpDonateQuestActive();
                }
                case "LEVELS": {
                    return this.plugin.getQuestManager().isLevelDonateQuestActive();
                }
            }
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig != null && (questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests")) != null) {
            for (String questId : activeQuests.keySet()) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "Vault");
                if (!"DONATE".equalsIgnoreCase(provider) || !donateType.equalsIgnoreCase(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void reload() {
        this.stopScheduler();
        this.startScheduler();
    }
}

