/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.datagen.client;

import com.shynieke.coupons.registry.CouponRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class CouponLanguageProvider
extends LanguageProvider {
    public CouponLanguageProvider(PackOutput packOutput) {
        super(packOutput, "coupons", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.coupons", "Coupons Tab");
        this.addItem((Supplier)CouponRegistry.CRAFTING_COUPON, "Crafting Coupon");
        this.addItem((Supplier)CouponRegistry.FURNACE_COUPON, "Furnace Coupon");
        this.addItem((Supplier)CouponRegistry.TRADING_COUPON, "Trading Coupon");
        this.addItem((Supplier)CouponRegistry.BREWING_COUPON, "Brewing Coupon");
        this.addItem((Supplier)CouponRegistry.LOOT_COUPON, "Loot Coupon");
        this.addItem((Supplier)CouponRegistry.EXPERIENCE_COUPON, "Experience Coupon");
        this.add("coupons:crafting_coupon_text", "Craft an item get an ingredient back");
        this.add("coupons:furnace_coupon_text", "Smelt one item for FREE");
        this.add("coupons:trading_coupon_text", "Get a nice deal while trading");
        this.add("coupons:brewing_coupon_text", "Use one less water bottle while brewing");
        this.add("coupons:loot_coupon_text", "Double the loot of the mob you apply this coupon on");
        this.add("coupons:experience_coupon_text", "Get one free level of experience");
        this.addConfig("General", "General", "General Settings");
        this.addConfig("doubleBossLoot", "Double Boss Loot", "When enabled the loot coupon can double boss loot");
        this.addConfig("entityBlacklist", "Entity Blacklist", "A list of entities that can't have loot doubled [Syntax: 'minecraft:bat']");
        this.addConfig("Trades", "Trades", "Trade Settings");
        this.addConfig("enableBrewingCoupon", "Enable Brewing Coupon", "Defines whether or not the Brewing Coupon is obtainable from the Wandering Trader");
        this.addConfig("enableCraftingCoupon", "Enable Crafting Coupon", "Defines whether or not the Crafting Coupon is obtainable from the Wandering Trader");
        this.addConfig("enableExperienceCoupon", "Enable Experience Coupon", "Defines whether or not the Experience Coupon is obtainable from the Wandering Trader");
        this.addConfig("enableFurnaceCoupon", "Enable Furnace Coupon", "Defines whether or not the Furnace Coupon is obtainable from the Wandering Trader");
        this.addConfig("enableLootCoupon", "Enable Loot Coupon", "Defines whether or not the Loot Coupon is obtainable from the Wandering Trader");
        this.addConfig("enableTradingCoupon", "Enable Trading Coupon", "Defines whether or not the Trading Coupon is obtainable from the Wandering Trader");
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("coupons.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("coupons.configuration." + path + ".tooltip", description);
        }
    }
}

