/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.items;

import com.shynieke.coupons.items.CouponItem;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class ExperienceCouponItem
extends CouponItem {
    public ExperienceCouponItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!level.isClientSide()) {
            boolean creative = playerIn.getAbilities().instabuild;
            if (playerIn.isCrouching()) {
                playerIn.giveExperienceLevels(stack.getCount());
                if (!creative) {
                    stack.shrink(stack.getCount());
                }
            } else {
                playerIn.giveExperienceLevels(1);
                if (!creative) {
                    stack.shrink(1);
                }
            }
        }
        return super.use(level, playerIn, handIn);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return super.interactLivingEntity(stack, player, target, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        consumer.accept((Component)Component.translatable((String)"coupons:experience_coupon_text").withStyle(ChatFormatting.GOLD));
    }
}

