/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaucerLightBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final Map<Direction, VoxelShape> AABBS;
    public static final MapCodec<SaucerLightBlock> CODEC;

    @NotNull
    protected MapCodec<SaucerLightBlock> codec() {
        return CODEC;
    }

    public SaucerLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos, true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (oldState.getBlock() != state.getBlock() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos);
        }
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos, boolean force) {
        boolean signal;
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        boolean bl = signal = level.getSignal(pos.relative(direction), direction) > 0;
        if (!force && signal == powered) {
            return;
        }
        BlockState blockState = state;
        if (force || !powered) {
            blockState = (BlockState)state.cycle((Property)LIT);
            level.playSound(null, pos, (Boolean)blockState.getValue((Property)LIT) != false ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS);
        }
        level.setBlock(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos) {
        this.checkAndFlip(state, level, pos, false);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level levelAccessor = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, POWERED, LIT});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    static {
        CODEC = SaucerLightBlock.simpleCodec(SaucerLightBlock::new);
        double margin = 4.0;
        double height = 2.0;
        AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.UP, (Object)Block.box((double)margin, (double)0.0, (double)margin, (double)(16.0 - margin), (double)height, (double)(16.0 - margin)), (Object)Direction.DOWN, (Object)Block.box((double)margin, (double)(16.0 - height), (double)margin, (double)(16.0 - margin), (double)16.0, (double)(16.0 - margin)), (Object)Direction.NORTH, (Object)Block.box((double)margin, (double)margin, (double)(16.0 - height), (double)(16.0 - margin), (double)(16.0 - margin), (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)margin, (double)margin, (double)0.0, (double)(16.0 - margin), (double)(16.0 - margin), (double)height), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)margin, (double)margin, (double)height, (double)(16.0 - margin), (double)(16.0 - margin)), (Object)Direction.WEST, (Object)Block.box((double)(16.0 - height), (double)margin, (double)margin, (double)16.0, (double)(16.0 - margin), (double)(16.0 - margin))));
    }
}

