/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.client.renderer;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.config.ClientConfig;
import dev.chililisoup.condiments.item.CrateItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CondimentsHud {
    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().screen != null) {
            return;
        }
        if (!ClientConfig.SHOW_CRATE_HUD.get().booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = player.getOffhandItem();
        }
        if (stack.isEmpty() || !(stack.getItem() instanceof CrateItem)) {
            return;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        CrateContents.ItemRecord itemRecord = crateContents.itemRecord();
        if (itemRecord == null) {
            return;
        }
        ItemStack contentsStack = itemRecord.asItemStack();
        Font font = Minecraft.getInstance().font;
        String count = String.format("x%d", crateContents.count());
        double xAlign = ClientConfig.CRATE_HUD_X_ALIGNMENT.get();
        double yAlign = ClientConfig.CRATE_HUD_Y_ALIGNMENT.get();
        int width = font.width(count) + 17;
        int x = ClientConfig.CRATE_HUD_X_OFFSET.get() + 4 - (int)(xAlign * (double)(width + 8)) + (int)((double)guiGraphics.guiWidth() * xAlign);
        int y = ClientConfig.CRATE_HUD_Y_OFFSET.get() + 4 - (int)(yAlign * 24.0) + (int)((double)guiGraphics.guiHeight() * yAlign);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)width, (int)16, (int)0);
        guiGraphics.renderItem(contentsStack, x, y);
        guiGraphics.renderItemDecorations(font, contentsStack, x, y);
        guiGraphics.drawString(font, count, x + 17, y + 7, 0xFFFFFF, true);
    }
}

