/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item.crafting;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.reg.ModBlocks;
import dev.chililisoup.condiments.reg.ModItemTags;
import dev.chililisoup.condiments.reg.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ModRecipeDisplays {
    public static List<RecipeHolder<CraftingRecipe>> getAll() {
        ArrayList<RecipeHolder<CraftingRecipe>> combined = new ArrayList<RecipeHolder<CraftingRecipe>>();
        combined.addAll(ModRecipeDisplays.crateColoringRecipe());
        combined.addAll(ModRecipeDisplays.crateLockingRecipe());
        combined.addAll(ModRecipeDisplays.crateUnlockingRecipe());
        combined.addAll(ModRecipeDisplays.crateAutoPickupUpgradeRecipe());
        return combined;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateColoringRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_coloring";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.byColor((DyeColor)color);
            ItemStack output = CrateBlock.getColoredItemStack(color);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation loc = Condiments.loc("/crate_coloring_" + color.getName());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateLockingRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (ItemStack input : ingredients.getItems()) {
            ItemStack output = input.copy();
            new CrateContents(null, 0, true, false).updateCrateItem(output);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of(ModItemTags.CRATE_LOCKING_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_locking_" + input.getDescriptionId());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateUnlockingRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (ItemStack output : ingredients.getItems()) {
            ItemStack input = output.copy();
            new CrateContents(null, 0, true, false).updateCrateItem(input);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of(ModItemTags.CRATE_UNLOCKING_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_unlocking_" + input.getDescriptionId());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateAutoPickupUpgradeRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_upgrades";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (ItemStack input : ingredients.getItems()) {
            ItemStack output = input.copy();
            new CrateContents(null, 0, false, true).updateCrateItem(output);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of(ModItemTags.CRATE_AUTO_PICKUP_UPGRADE_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_auto_pickup_upgrade_" + input.getDescriptionId());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static Map<List<ItemLike>, List<String>> ingredientInfos() {
        return Map.of(List.of((ItemLike)ModBlocks.BLACKENED_IRON_BLOCK.get(), (ItemLike)ModItems.BLACKENED_IRON_INGOT.get()), List.of("condiments.ingredient_info.blackened_iron_block"));
    }
}

