/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.chililisoup.condiments.config.CommonConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CrateContents(@Nullable ItemRecord itemRecord, int count, Boolean locked, Boolean autoPickup) {
    public static final CrateContents EMPTY = new CrateContents();
    public static final Codec<CrateContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRecord.ITEM_CODEC.optionalFieldOf("item").forGetter(CrateContents::itemRecordOptional), (App)Codec.INT.fieldOf("Count").forGetter(CrateContents::count), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(CrateContents::lockedOptional), (App)Codec.BOOL.optionalFieldOf("autoPickup").forGetter(CrateContents::autoPickupOptional)).apply((Applicative)instance, CrateContents::new));

    public CrateContents(@Nullable ItemRecord itemRecord, int count) {
        this(itemRecord, count, false, false);
    }

    public CrateContents() {
        this(null, 0);
    }

    private CrateContents(Optional<ItemRecord> itemRecord, int count, Optional<Boolean> locked, Optional<Boolean> autoPickup) {
        this(itemRecord.orElse(null), count, locked.orElse(false), autoPickup.orElse(false));
    }

    private Optional<ItemRecord> itemRecordOptional() {
        return Optional.ofNullable(this.itemRecord);
    }

    private Optional<Boolean> lockedOptional() {
        return this.locked != false ? Optional.of(true) : Optional.empty();
    }

    private Optional<Boolean> autoPickupOptional() {
        return this.autoPickup != false ? Optional.of(true) : Optional.empty();
    }

    public static CrateContents fromCrateItem(ItemStack crateItem) {
        CompoundTag compoundTag = crateItem.m_41737_("BlockEntityTag");
        if (compoundTag == null) {
            return EMPTY;
        }
        boolean locked = compoundTag.m_128471_("CrateLocked");
        boolean autoPickup = compoundTag.m_128471_("CrateAutoPickup");
        short count = 0;
        ItemRecord record = null;
        CompoundTag storageTag = compoundTag.m_128469_("CrateItems").m_6426_();
        if (!storageTag.m_128456_()) {
            count = storageTag.m_128448_("Count");
            storageTag.m_128376_("Count", (short)1);
            ItemStack item = ItemStack.m_41712_((CompoundTag)storageTag);
            if (!item.m_41619_()) {
                record = ItemRecord.of(item);
            }
        }
        return new CrateContents(record, (int)count, locked, autoPickup);
    }

    public void updateCrateItem(ItemStack crateItem) {
        CompoundTag compoundTag = crateItem.m_41698_("BlockEntityTag");
        if (this.autoPickup.booleanValue()) {
            compoundTag.m_128379_("CrateAutoPickup", true);
        } else {
            compoundTag.m_128473_("CrateAutoPickup");
        }
        Optional<ItemStack> itemType = this.item();
        if (itemType.isEmpty() && !this.isLocked()) {
            compoundTag.m_128473_("CrateItems");
            compoundTag.m_128473_("CrateLocked");
            if (compoundTag.m_128456_()) {
                crateItem.m_41749_("BlockEntityTag");
            }
            return;
        }
        compoundTag.m_128379_("CrateLocked", this.isLocked());
        if (itemType.isPresent()) {
            CompoundTag storageTag = itemType.get().m_41739_(new CompoundTag());
            storageTag.m_128376_("Count", (short)this.count);
            compoundTag.m_128365_("CrateItems", (Tag)storageTag);
        }
    }

    public Optional<ItemStack> item() {
        return this.itemRecordOptional().flatMap(itemRecord -> Optional.of(itemRecord.asItemStack()));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static int maxStacks() {
        return CommonConfig.CRATE_MAX_CONTAINED_STACKS.get();
    }

    public int capacity() {
        int stackCount = CrateContents.maxStacks();
        return this.item().map(stack -> stack.m_41741_() * stackCount).orElse(0);
    }

    public float fillPercent() {
        if (this.count <= 0 && !this.isLocked()) {
            return -1.0f;
        }
        if (this.item().isEmpty()) {
            return -1.0f;
        }
        return (float)this.count / (float)this.capacity();
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public SlottedMutable toSlottedMutable() {
        return new SlottedMutable(this);
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("%s x %d, %s", this.item(), this.count, this.isLocked() ? "LOCKED" : "UNLOCKED");
    }

    public static boolean isItemUnsafe(ItemStack stack) {
        ListTag containerContents;
        if (stack.m_41619_()) {
            return true;
        }
        CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
        if (compoundTag == null) {
            return false;
        }
        if (compoundTag.m_128425_("Items", 9) && !(containerContents = compoundTag.m_128437_("Items", 10)).isEmpty()) {
            return true;
        }
        if (compoundTag.m_128441_("CrateItems")) {
            if (!CommonConfig.CRATES_CONTAIN_EMPTY_CRATES.get().booleanValue()) {
                return true;
            }
            return compoundTag.m_128469_("CrateItems").m_128448_("Count") > 0;
        }
        return false;
    }

    public record ItemRecord(Holder<Item> item, Optional<CompoundTag> components) {
        public static final Codec<ItemRecord> ITEM_CODEC = ItemStack.f_41582_.xmap(ItemRecord::of, ItemRecord::asItemStack);

        public ItemStack asItemStack() {
            ItemStack stack = new ItemStack(this.item, 1);
            this.components.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
            return stack;
        }

        public static ItemRecord of(ItemStack item) {
            return new ItemRecord((Holder<Item>)item.m_220173_(), Optional.ofNullable(item.m_41783_()));
        }
    }

    public static class Mutable {
        private ItemStack item = ItemStack.f_41583_;
        private int count;
        private boolean locked;
        private boolean autoPickup;

        private Mutable() {
        }

        public Mutable(CrateContents contents) {
            this.setValues(contents);
        }

        public Mutable setValues(CrateContents contents) {
            this.setLocked(contents.locked);
            this.setItemType(contents.item().orElse(null));
            this.setCount(contents.count);
            this.setAutoPickup(contents.autoPickup);
            return this;
        }

        public ItemStack getItemType(int count) {
            return this.item.m_255036_(count);
        }

        public ItemStack getItemType() {
            return this.getItemType(1);
        }

        public void setItemType(@Nullable ItemStack stack) {
            this.item = stack != null ? stack.m_255036_(1) : ItemStack.f_41583_;
        }

        public boolean isEmptyNoLock() {
            return this.getCount() <= 0 && !this.isLocked();
        }

        protected void updateItemType() {
            if (this.isEmptyNoLock()) {
                this.setItemType(null);
            }
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
            this.updateItemType();
        }

        public void grow(int increment) {
            this.setCount(this.getCount() + increment);
        }

        public void shrink(int decrement) {
            this.setCount(this.getCount() - decrement);
        }

        public void clear() {
            this.setCount(0);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
            this.updateItemType();
        }

        public boolean isAutoPickup() {
            return this.autoPickup;
        }

        public void setAutoPickup(boolean autoPickup) {
            this.autoPickup = autoPickup;
        }

        public int getMaxStackSize() {
            return this.getItemType().m_41741_();
        }

        protected int getMaxAmountToAdd(ItemStack stack) {
            int stackCount = CrateContents.maxStacks();
            ItemStack itemType = this.getItemType();
            return itemType.m_41619_() ? stack.m_41741_() * stackCount : Math.max(itemType.m_41741_() * stackCount - this.getCount(), 0);
        }

        protected int getMaxAmountToAdd() {
            return this.getMaxAmountToAdd(this.getItemType());
        }

        public boolean canAdd(ItemStack stack) {
            if (CrateContents.isItemUnsafe(stack)) {
                return false;
            }
            ItemStack itemType = this.getItemType();
            return itemType.m_41619_() || ItemStack.m_150942_((ItemStack)itemType, (ItemStack)stack);
        }

        public int getToAdd(ItemStack stack) {
            if (!this.canAdd(stack)) {
                return 0;
            }
            return Math.min(this.getMaxAmountToAdd(stack), stack.m_41613_());
        }

        public void addFromStack(ItemStack stack, int maxToAdd, boolean simulate) {
            if (!this.canAdd(stack)) {
                return;
            }
            this.setItemType(stack);
            int amt = Math.min(maxToAdd, stack.m_41613_());
            stack.m_41774_(amt);
            if (!simulate) {
                this.grow(amt);
            }
        }

        public void addFromStack(ItemStack stack, int maxToAdd) {
            this.addFromStack(stack, maxToAdd, false);
        }

        public void addFromStack(ItemStack stack, boolean simulate) {
            this.addFromStack(stack, stack.m_41613_(), simulate);
        }

        public void addFromStack(ItemStack stack) {
            this.addFromStack(stack, stack.m_41613_());
        }

        public ItemStack tryAddStack(ItemStack stack, boolean simulate) {
            ItemStack refStack = stack.m_41777_();
            if (!this.canAdd(refStack)) {
                return refStack;
            }
            if (refStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.addFromStack(refStack, simulate);
            return refStack;
        }

        public boolean addAllInventory(Player player) {
            if (this.isEmptyNoLock()) {
                return false;
            }
            int addCount = player.m_150109_().m_36022_(this::canAdd, this.getMaxAmountToAdd(), (Container)player.m_150109_());
            if (addCount <= 0) {
                return false;
            }
            this.grow(addCount);
            return true;
        }

        public ItemStack request(int amount) {
            ItemStack itemType = this.getItemType();
            if (itemType.m_41619_() || this.getCount() <= 0) {
                return ItemStack.f_41583_;
            }
            int amt = Math.min(amount, this.getCount());
            this.shrink(amt);
            this.updateItemType();
            return itemType.m_255036_(amt);
        }

        public ItemStack requestOne() {
            return this.request(1);
        }

        public ItemStack requestOneStack() {
            ItemStack itemType = this.getItemType();
            return itemType.m_41619_() ? ItemStack.f_41583_ : this.request(itemType.m_41741_());
        }

        public CrateContents toImmutable() {
            this.updateItemType();
            ItemStack itemType = this.getItemType();
            return new CrateContents(itemType.m_41619_() ? null : ItemRecord.of(itemType), this.getCount(), this.isLocked(), this.isAutoPickup());
        }

        public String toString() {
            return this.toImmutable().toString();
        }
    }

    public static class SlottedMutable
    extends Mutable {
        private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)CrateContents.maxStacks(), (Object)ItemStack.f_41583_);

        public SlottedMutable(CrateContents contents) {
            this.setValues(contents);
        }

        @Override
        public Mutable setValues(CrateContents contents) {
            this.itemStacks.clear();
            return super.setValues(contents);
        }

        @Override
        public int getCount() {
            AtomicInteger count = new AtomicInteger();
            this.itemStacks.forEach(stack -> count.addAndGet(stack.m_41613_()));
            return count.get();
        }

        @Override
        public void setCount(int count) {
            ItemStack itemType = this.getItemType();
            if (count == 0 || itemType.m_41619_()) {
                this.itemStacks.clear();
            } else {
                int maxStackSize = itemType.m_41741_();
                int remaining = count - this.getCount();
                if (remaining > 0) {
                    for (int i = 0; i < this.itemStacks.size() && remaining > 0; ++i) {
                        ItemStack stack = (ItemStack)this.itemStacks.get(i);
                        if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemType)) {
                            int free = maxStackSize - stack.m_41613_();
                            if (free <= 0) continue;
                            int toAdd = Math.min(remaining, free);
                            remaining -= toAdd;
                            stack.m_41769_(toAdd);
                            continue;
                        }
                        int toAdd = Math.min(remaining, maxStackSize);
                        this.itemStacks.set(i, (Object)itemType.m_255036_(toAdd));
                        remaining -= toAdd;
                    }
                } else if (remaining < 0) {
                    remaining = Math.abs(remaining);
                    for (int i = this.itemStacks.size() - 1; i >= 0 && remaining > 0; --i) {
                        ItemStack stack = (ItemStack)this.itemStacks.get(i);
                        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemType)) continue;
                        int toRemove = Math.min(stack.m_41613_(), remaining);
                        remaining -= toRemove;
                        stack.m_41774_(toRemove);
                    }
                }
            }
            super.setCount(count);
        }

        public ItemStack getSlot(int slot) {
            return (ItemStack)this.itemStacks.get(slot);
        }

        public ItemStack[] getSlottedStacks() {
            return (ItemStack[])this.itemStacks.stream().map(ItemStack::m_41777_).toArray(ItemStack[]::new);
        }

        public boolean setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!stack.m_41619_() && !this.canAdd(stack)) {
                return false;
            }
            this.itemStacks.set(slot, (Object)stack);
            if (!stack.m_41619_()) {
                this.setItemType(stack);
            }
            this.updateItemType();
            return true;
        }

        public ItemStack insertIntoSlot(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemStack refStack = stack.m_41777_();
            if (!this.canAdd(stack)) {
                return refStack;
            }
            ItemStack currentItemType = this.getItemType();
            ItemStack itemType = currentItemType.m_41619_() ? refStack.m_255036_(1) : currentItemType;
            ItemStack slotStack = this.getSlot(slot);
            int freeSpace = itemType.m_41741_() - slotStack.m_41613_();
            int toAdd = Math.min(refStack.m_41613_(), freeSpace);
            if (toAdd <= 0) {
                return refStack;
            }
            if (!simulate) {
                this.setItemType(itemType);
                this.grow(toAdd);
            }
            refStack.m_41774_(toAdd);
            return refStack;
        }

        @NotNull
        public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
            ItemStack slotStack = this.getSlot(slot);
            if (slotStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int finalAmt = Math.min(slotStack.m_41613_(), amount);
            ItemStack returnStack = slotStack.m_255036_(finalAmt);
            if (!simulate) {
                if (finalAmt == slotStack.m_41613_()) {
                    this.itemStacks.set(slot, (Object)ItemStack.f_41583_);
                } else {
                    slotStack.m_41774_(finalAmt);
                }
                this.updateItemType();
            }
            return returnStack;
        }

        @NotNull
        public ItemStack removeFromSlot(int slot) {
            ItemStack slotStack = this.getSlot(slot);
            if (slotStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.setStackInSlot(slot, ItemStack.f_41583_);
            this.updateItemType();
            return slotStack;
        }
    }
}

