/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AccentBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] TOP_SHAPES;
    protected static final VoxelShape[] BOTTOM_SHAPES;
    private static final int[] SHAPE_BY_STATE;

    public AccentBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (state.m_61143_(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)AccentBlock.getStairsShape(blockState, (BlockGetter)context.m_43725_(), blockPos));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)AccentBlock.getStairsShape(state, (BlockGetter)level, pos)) : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        if (AccentBlock.isAccent(blockState) && state.m_61143_(HALF) == blockState.m_61143_(HALF) && (direction2 = (Direction)blockState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && AccentBlock.canTakeShape(state, level, pos, direction2.m_122424_())) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockState2 = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (AccentBlock.isAccent(blockState2) && state.m_61143_(HALF) == blockState2.m_61143_(HALF) && (direction3 = (Direction)blockState2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && AccentBlock.canTakeShape(state, level, pos, direction3)) {
            if (direction3 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        return !AccentBlock.isAccent(blockState) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockState.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isAccent(BlockState state) {
        return state.m_60734_() instanceof AccentBlock;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsShape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() == Direction.Axis.Z) {
                    return switch (stairsShape) {
                        case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                        case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                        case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                        case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                        default -> state.m_60717_(Rotation.CLOCKWISE_180);
                    };
                }
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (stairsShape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    static {
        VoxelShape SIDE_BN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape SIDE_BS = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_BW = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_BE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_TN = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        VoxelShape SIDE_TS = Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape SIDE_TW = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        VoxelShape SIDE_TE = Block.m_49796_((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape COR_BNW = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
        VoxelShape COR_BNE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape COR_BSW = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape COR_BSE = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape COR_TNW = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
        VoxelShape COR_TNE = Block.m_49796_((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        VoxelShape COR_TSW = Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
        VoxelShape COR_TSE = Block.m_49796_((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        TOP_SHAPES = new VoxelShape[]{SIDE_TS, SIDE_TW, SIDE_TN, SIDE_TE, Shapes.m_83110_((VoxelShape)SIDE_TS, (VoxelShape)SIDE_TE), Shapes.m_83110_((VoxelShape)SIDE_TW, (VoxelShape)SIDE_TS), Shapes.m_83110_((VoxelShape)SIDE_TN, (VoxelShape)SIDE_TW), Shapes.m_83110_((VoxelShape)SIDE_TE, (VoxelShape)SIDE_TN), COR_TSE, COR_TSW, COR_TNW, COR_TNE};
        BOTTOM_SHAPES = new VoxelShape[]{SIDE_BS, SIDE_BW, SIDE_BN, SIDE_BE, Shapes.m_83110_((VoxelShape)SIDE_BS, (VoxelShape)SIDE_BE), Shapes.m_83110_((VoxelShape)SIDE_BW, (VoxelShape)SIDE_BS), Shapes.m_83110_((VoxelShape)SIDE_BN, (VoxelShape)SIDE_BW), Shapes.m_83110_((VoxelShape)SIDE_BE, (VoxelShape)SIDE_BN), COR_BSE, COR_BSW, COR_BNW, COR_BNE};
        SHAPE_BY_STATE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 5, 6, 7, 4, 8, 9, 10, 11, 9, 10, 11, 8};
    }
}

