/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import dev.chililisoup.condiments.block.IDestroyPreventable;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.reg.ModBlocks;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CrateBlock
extends BaseEntityBlock
implements IDestroyPreventable {
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.f_61375_;
    @Nullable
    private final DyeColor color;

    public CrateBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
    }

    public static BlockHitResult getHitResult(Level level, BlockPos pos, Entity player) {
        Vec3 eyePos = player.m_20299_(1.0f);
        return level.m_45547_(new ClipContext(eyePos, eyePos.m_82549_(player.m_20252_(1.0f).m_82490_(eyePos.m_82554_(Vec3.m_82512_((Vec3i)pos)) + 1.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, player));
    }

    public static Optional<Vec2> getHitPosition(BlockHitResult hitResult, Direction face) {
        Direction direction = hitResult.m_82434_();
        if (face != direction) {
            return Optional.empty();
        }
        BlockPos blockPos = hitResult.m_82425_().m_121945_(direction);
        Vec3 vec3 = hitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        double x = vec3.m_7096_();
        double y = vec3.m_7098_();
        double z = vec3.m_7094_();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.SOUTH -> Optional.of(new Vec2((float)x, (float)y));
            case Direction.WEST, Direction.EAST -> Optional.of(new Vec2((float)z, (float)y));
            case Direction.UP, Direction.DOWN -> Optional.of(new Vec2((float)x, (float)z));
        };
    }

    public static boolean isNotInBounds(Vec2 pos) {
        return (double)pos.f_82470_ < 0.125 || (double)pos.f_82470_ > 0.875 || (double)pos.f_82471_ < 0.125 || (double)pos.f_82471_ > 0.875;
    }

    private static Optional<CrateBlockEntity> checkUseAndGet(BlockState state, Level level, BlockPos pos, BlockHitResult hitResult) {
        CrateBlockEntity crateBlockEntity;
        block5: {
            block4: {
                boolean hitFace = hitResult.m_82434_() == ((FrontAndTop)state.m_61143_(ORIENTATION)).m_122625_();
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof CrateBlockEntity)) break block4;
                crateBlockEntity = (CrateBlockEntity)blockEntity;
                if (hitFace) break block5;
            }
            return Optional.empty();
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult, ((FrontAndTop)state.m_61143_(ORIENTATION)).m_122625_());
        if (hitPos.isEmpty() || CrateBlock.isNotInBounds(hitPos.get())) {
            return Optional.empty();
        }
        return Optional.of(crateBlockEntity);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<CrateBlockEntity> crateBlockEntity = CrateBlock.checkUseAndGet(state, level, pos, hitResult);
        if (crateBlockEntity.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            if (crateBlockEntity.get().canAddItem(stack)) {
                player.m_21008_(hand, crateBlockEntity.get().tryAddStack(player.m_21120_(hand), player));
            } else if (player.f_20913_ > 0) {
                crateBlockEntity.get().tryAddStack(ItemStack.f_41583_, player);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        ItemEntity itemEntity;
        if (level.f_46443_) {
            return;
        }
        Optional<CrateBlockEntity> crateBlockEntity = CrateBlock.checkUseAndGet(state, level, pos, CrateBlock.getHitResult(level, pos, (Entity)player));
        if (crateBlockEntity.isEmpty()) {
            return;
        }
        ItemStack itemStack = player.m_6144_() ? crateBlockEntity.get().requestOneStack() : crateBlockEntity.get().requestOne();
        player.m_36356_(itemStack);
        if (itemStack.m_41613_() > 0 && (itemEntity = player.m_36176_(itemStack, false)) != null) {
            itemEntity.m_32061_();
            itemEntity.m_266426_(player.m_20148_());
        }
    }

    private boolean playerDidHit(Direction front, BlockHitResult hitResult) {
        return CrateBlock.getHitPosition(hitResult, front).filter(hitPos -> !CrateBlock.isNotInBounds(hitPos)).isPresent();
    }

    @Nullable
    private CrateBlockEntity playerHit(BlockState state, BlockPos pos, Player player, Direction face, Supplier<BlockHitResult> hitResultSupplier) {
        Direction front = ((FrontAndTop)state.m_61143_(ORIENTATION)).m_122625_();
        if (face != front) {
            return null;
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (!(blockEntity instanceof CrateBlockEntity)) {
            return null;
        }
        CrateBlockEntity crateBlockEntity = (CrateBlockEntity)blockEntity;
        return this.playerDidHit(front, hitResultSupplier.get()) ? crateBlockEntity : null;
    }

    @Nullable
    private CrateBlockEntity playerHit(BlockState state, Level level, BlockPos pos, Player player, Direction face) {
        return this.playerHit(state, pos, player, face, () -> CrateBlock.getHitResult(level, pos, (Entity)player));
    }

    private boolean shouldPreventDamage(BlockState state, Player player, BlockPos pos) {
        BlockHitResult hitResult = CrateBlock.getHitResult(player.m_9236_(), pos, (Entity)player);
        Direction front = ((FrontAndTop)state.m_61143_(ORIENTATION)).m_122625_();
        if (hitResult.m_82434_() != front) {
            return false;
        }
        if (!(player.m_9236_().m_7702_(pos) instanceof CrateBlockEntity)) {
            return false;
        }
        return this.playerDidHit(front, hitResult);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return this.shouldPreventDamage(state, player, pos) ? 0.0f : super.m_5880_(state, player, level, pos);
    }

    @Override
    public boolean shouldCancelDestroy(BlockState state, Level level, BlockPos pos, Player player, Direction face) {
        ItemEntity itemEntity;
        if (!player.m_7500_()) {
            return false;
        }
        CrateBlockEntity crateBlockEntity = this.playerHit(state, level, pos, player, face);
        if (crateBlockEntity == null) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        ItemStack itemStack = player.m_6144_() ? crateBlockEntity.requestOneStack() : crateBlockEntity.requestOne();
        player.m_36356_(itemStack);
        if (itemStack.m_41613_() > 0 && (itemEntity = player.m_36176_(itemStack, false)) != null) {
            itemEntity.m_32061_();
            itemEntity.m_266426_(player.m_20148_());
        }
        return true;
    }

    @Override
    public boolean shouldPreventAttackRetrigger(BlockState state, Level level, BlockPos pos, Player player, Direction face, BlockHitResult hitResult) {
        return this.playerHit(state, pos, player, face, () -> hitResult) != null;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_ && player.m_7500_() && !((CrateBlockEntity)Objects.requireNonNull(level.m_7702_(pos))).m_7983_()) {
            Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos)).forEach(drop -> {
                ItemEntity ent = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop);
                ent.m_32060_();
                ent.m_20334_(0.0, 0.0, 0.0);
                level.m_7967_((Entity)ent);
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CrateBlockEntity) {
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!stack.m_41788_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity2 = (CrateBlockEntity)blockEntity;
            blockEntity2.setCustomName(stack.m_41786_());
        }
    }

    @Nullable
    public static DyeColor getColorFromItem(Item item) {
        return CrateBlock.getColorFromBlock(Block.m_49814_((Item)item));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block block) {
        return block instanceof CrateBlock ? ((CrateBlock)block).getColor() : null;
    }

    public static Block getBlockByColor(@Nullable DyeColor color) {
        if (color == null) {
            return ModBlocks.CRATE.get();
        }
        return switch (color) {
            case DyeColor.WHITE -> ModBlocks.WHITE_CRATE.get();
            case DyeColor.LIGHT_GRAY -> ModBlocks.LIGHT_GRAY_CRATE.get();
            case DyeColor.GRAY -> ModBlocks.GRAY_CRATE.get();
            case DyeColor.BLACK -> ModBlocks.BLACK_CRATE.get();
            case DyeColor.BROWN -> ModBlocks.BROWN_CRATE.get();
            case DyeColor.RED -> ModBlocks.RED_CRATE.get();
            case DyeColor.ORANGE -> ModBlocks.ORANGE_CRATE.get();
            case DyeColor.YELLOW -> ModBlocks.YELLOW_CRATE.get();
            case DyeColor.LIME -> ModBlocks.LIME_CRATE.get();
            case DyeColor.GREEN -> ModBlocks.GREEN_CRATE.get();
            case DyeColor.CYAN -> ModBlocks.CYAN_CRATE.get();
            case DyeColor.LIGHT_BLUE -> ModBlocks.LIGHT_BLUE_CRATE.get();
            case DyeColor.BLUE -> ModBlocks.BLUE_CRATE.get();
            case DyeColor.PURPLE -> ModBlocks.PURPLE_CRATE.get();
            case DyeColor.MAGENTA -> ModBlocks.MAGENTA_CRATE.get();
            default -> ModBlocks.PINK_CRATE.get();
        };
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor color) {
        return new ItemStack((ItemLike)CrateBlock.getBlockByColor(color));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrateBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction front = context.m_7820_().m_122424_();
        Direction top = switch (front) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> context.m_8125_().m_122424_();
            case Direction.UP -> context.m_8125_();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        return (BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)FrontAndTop.m_122622_((Direction)front, (Direction)top));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)rotation.m_55948_().m_56530_((FrontAndTop)state.m_61143_(ORIENTATION)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)mirror.m_54842_().m_56530_((FrontAndTop)state.m_61143_(ORIENTATION)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ORIENTATION});
    }
}

