/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaucerLightBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final Map<Direction, VoxelShape> AABBS;

    public SaucerLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos, true);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (oldState.m_60734_() != state.m_60734_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkAndFlip(state, serverLevel, pos);
        }
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos, boolean force) {
        boolean signal;
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        Direction direction = ((Direction)state.m_61143_((Property)f_52588_)).m_122424_();
        boolean bl = signal = level.m_277185_(pos.m_121945_(direction), direction) > 0;
        if (!force && signal == powered) {
            return;
        }
        BlockState blockState = state;
        if (force || !powered) {
            blockState = (BlockState)state.m_61122_((Property)LIT);
            level.m_247517_(null, pos, (Boolean)blockState.m_61143_((Property)LIT) != false ? SoundEvents.f_12632_ : SoundEvents.f_12631_, SoundSource.BLOCKS);
        }
        level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos) {
        this.checkAndFlip(state, level, pos, false);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.m_61143_((Property)f_52588_));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelAccessor = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, WATERLOGGED, POWERED, LIT});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    static {
        double margin = 4.0;
        double height = 2.0;
        AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.UP, (Object)Block.m_49796_((double)margin, (double)0.0, (double)margin, (double)(16.0 - margin), (double)height, (double)(16.0 - margin)), (Object)Direction.DOWN, (Object)Block.m_49796_((double)margin, (double)(16.0 - height), (double)margin, (double)(16.0 - margin), (double)16.0, (double)(16.0 - margin)), (Object)Direction.NORTH, (Object)Block.m_49796_((double)margin, (double)margin, (double)(16.0 - height), (double)(16.0 - margin), (double)(16.0 - margin), (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)margin, (double)margin, (double)0.0, (double)(16.0 - margin), (double)(16.0 - margin), (double)height), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)margin, (double)margin, (double)height, (double)(16.0 - margin), (double)(16.0 - margin)), (Object)Direction.WEST, (Object)Block.m_49796_((double)(16.0 - height), (double)margin, (double)margin, (double)16.0, (double)(16.0 - margin), (double)(16.0 - margin))));
    }
}

