/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.client.renderer;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.config.ClientConfig;
import dev.chililisoup.condiments.item.CrateItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CondimentsHud {
    public static void render(GuiGraphics guiGraphics, float delta) {
        if (Minecraft.m_91087_().f_91066_.f_92062_ || Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (!ClientConfig.SHOW_CRATE_HUD.get().booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CrateItem)) {
            return;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        CrateContents.ItemRecord itemRecord = crateContents.itemRecord();
        if (itemRecord == null) {
            return;
        }
        ItemStack contentsStack = itemRecord.asItemStack();
        Font font = Minecraft.m_91087_().f_91062_;
        String count = String.format("x%d", crateContents.count());
        double xAlign = ClientConfig.CRATE_HUD_X_ALIGNMENT.get();
        double yAlign = ClientConfig.CRATE_HUD_Y_ALIGNMENT.get();
        int width = font.m_92895_(count) + 17;
        int x = ClientConfig.CRATE_HUD_X_OFFSET.get() + 4 - (int)(xAlign * (double)(width + 8)) + (int)((double)guiGraphics.m_280182_() * xAlign);
        int y = ClientConfig.CRATE_HUD_Y_OFFSET.get() + 4 - (int)(yAlign * 24.0) + (int)((double)guiGraphics.m_280206_() * yAlign);
        TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)width, (int)16, (int)0);
        guiGraphics.m_280480_(contentsStack, x, y);
        guiGraphics.m_280370_(font, contentsStack, x, y);
        guiGraphics.m_280056_(font, count, x + 17, y + 7, 0xFFFFFF, true);
    }
}

