/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item.crafting;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.reg.ModBlocks;
import dev.chililisoup.condiments.reg.ModItemTags;
import dev.chililisoup.condiments.reg.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ModRecipeDisplays {
    public static List<CraftingRecipe> getAll() {
        ArrayList<CraftingRecipe> combined = new ArrayList<CraftingRecipe>();
        combined.addAll(ModRecipeDisplays.crateColoringRecipe());
        combined.addAll(ModRecipeDisplays.crateLockingRecipe());
        combined.addAll(ModRecipeDisplays.crateUnlockingRecipe());
        combined.addAll(ModRecipeDisplays.crateAutoPickupUpgradeRecipe());
        return combined;
    }

    public static List<CraftingRecipe> crateColoringRecipe() {
        ArrayList<CraftingRecipe> recipeList = new ArrayList<CraftingRecipe>();
        String group = "crate_coloring";
        Ingredient ingredients = Ingredient.m_204132_(ModItemTags.CRATES);
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.m_41082_((DyeColor)color);
            ItemStack output = CrateBlock.getColoredItemStack(color);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{ingredients, Ingredient.m_43929_((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation loc = Condiments.loc("/crate_coloring_" + color.m_41065_());
            recipeList.add((CraftingRecipe)new ShapelessRecipe(loc, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipeList;
    }

    public static List<CraftingRecipe> crateLockingRecipe() {
        ArrayList<CraftingRecipe> recipeList = new ArrayList<CraftingRecipe>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.m_204132_(ModItemTags.CRATES);
        for (ItemStack input : ingredients.m_43908_()) {
            ItemStack output = input.m_41777_();
            new CrateContents(null, 0, true, false).updateCrateItem(output);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), Ingredient.m_204132_(ModItemTags.CRATE_LOCKING_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_locking_" + input.m_41778_());
            recipeList.add((CraftingRecipe)new ShapelessRecipe(loc, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipeList;
    }

    public static List<CraftingRecipe> crateUnlockingRecipe() {
        ArrayList<CraftingRecipe> recipeList = new ArrayList<CraftingRecipe>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.m_204132_(ModItemTags.CRATES);
        for (ItemStack output : ingredients.m_43908_()) {
            ItemStack input = output.m_41777_();
            new CrateContents(null, 0, true, false).updateCrateItem(input);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), Ingredient.m_204132_(ModItemTags.CRATE_UNLOCKING_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_unlocking_" + input.m_41778_());
            recipeList.add((CraftingRecipe)new ShapelessRecipe(loc, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipeList;
    }

    public static List<CraftingRecipe> crateAutoPickupUpgradeRecipe() {
        ArrayList<CraftingRecipe> recipeList = new ArrayList<CraftingRecipe>();
        String group = "crate_upgrades";
        Ingredient ingredients = Ingredient.m_204132_(ModItemTags.CRATES);
        for (ItemStack input : ingredients.m_43908_()) {
            ItemStack output = input.m_41777_();
            new CrateContents(null, 0, false, true).updateCrateItem(output);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), Ingredient.m_204132_(ModItemTags.CRATE_AUTO_PICKUP_UPGRADE_ITEMS)});
            ResourceLocation loc = Condiments.loc("/crate_auto_pickup_upgrade_" + input.m_41778_());
            recipeList.add((CraftingRecipe)new ShapelessRecipe(loc, group, CraftingBookCategory.MISC, output, inputs));
        }
        return recipeList;
    }

    public static Map<List<ItemLike>, List<String>> ingredientInfos() {
        return Map.of(List.of((ItemLike)ModBlocks.WAXED_IRON_BLOCK.get(), (ItemLike)ModBlocks.BLACKENED_IRON_BLOCK.get(), (ItemLike)ModItems.BLACKENED_IRON_INGOT.get()), List.of("condiments.ingredient_info.blackened_iron_block"));
    }
}

