/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.reg;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.AccentBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModBlockSetVariants {
    public static final ArrayList<WoodVariant> WOOD_VARIANTS = new ArrayList();
    public static final WoodVariant WOOD_WALLS = new WoodVariant("wall", "fence", properties -> new WallBlock(properties.m_280606_()), "log").setRequiresSolid("stripped_log");
    public static final WoodVariant WOOD_ACCENTS = new WoodVariant("accent", "fence", AccentBlock::new).setRequiresSolid("stripped_log");
    public static final WoodVariant POLISHED_WOOD = new WoodVariant("polished_wood", "stripped_wood", RotatedPillarBlock::new, "stripped_log", "wood").setIdGetter(wood -> {
        Block block = wood.getBlockOfThis("stripped_wood");
        return block == null ? wood.getVariantId("polished_%s_wood") : (String)(wood.isVanilla() ? "" : wood.getNamespace() + "/") + Utils.getID((Block)block).m_135815_().replace("stripped", "polished");
    }).setRequiresSolid();
    public static final WoodVariant POLISHED_LOGS = new WoodVariant("polished_log", "stripped_log", RotatedPillarBlock::new, "stripped_wood").setIdGetter(wood -> {
        Block block = wood.getBlockOfThis("stripped_log");
        return block == null ? wood.getVariantId("polished_%s_log") : (String)(wood.isVanilla() ? "" : wood.getNamespace() + "/") + Utils.getID((Block)block).m_135815_().replace("stripped", "polished");
    }).setRequiresSolid();

    private static void markFlammable(Block block) {
        RegHelper.registerBlockFlammability((Block)block, (int)5, (int)5);
    }

    public static void init() {
        BlockSetAPI.addDynamicBlockRegistration(ModBlockSetVariants::registerWoodBlocks, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(ModBlockSetVariants::registerWoodItems, WoodType.class);
    }

    private static void registerWoodBlocks(Registrator<Block> event, Collection<WoodType> woodTypes) {
        for (WoodVariant woodVariant : WOOD_VARIANTS) {
            for (WoodType wood : woodTypes) {
                Block parent;
                if (Arrays.stream(woodVariant.typeRequirements).anyMatch(req -> wood.getBlockOfThis(req) == null) || (parent = wood.getBlockOfThis(woodVariant.parent)) == null || woodVariant.requiresSolid.stream().anyMatch(variant -> {
                    Block solid = wood.getBlockOfThis(variant);
                    if (solid == null) {
                        return true;
                    }
                    try {
                        if (!Block.m_49916_((VoxelShape)solid.m_49966_().m_60808_(null, null))) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        return true;
                    }
                    return false;
                })) continue;
                Block block = woodVariant.blockFactory.apply(BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent));
                String name = woodVariant.idGetter.get(wood);
                wood.addChild("condiments:" + woodVariant.name, (Object)block);
                event.register(Condiments.loc(name), (Object)block);
                if (!wood.canBurn()) continue;
                ModBlockSetVariants.markFlammable(block);
            }
        }
    }

    private static void registerWoodItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodVariant woodVariant : WOOD_VARIANTS) {
            for (WoodType wood : woodTypes) {
                Object object = wood.getChild("condiments:" + woodVariant.name);
                if (!(object instanceof Block)) continue;
                Block block = (Block)object;
                String name = woodVariant.idGetter.get(wood);
                WoodBasedBlockItem item = new WoodBasedBlockItem(block, new Item.Properties(), wood);
                event.register(Condiments.loc(name), (Object)item);
                woodVariant.items.put(wood, item);
            }
        }
    }

    public static class WoodVariant {
        public final HashMap<WoodType, WoodBasedBlockItem> items = new HashMap();
        public final String name;
        public final String parent;
        public final Function<BlockBehaviour.Properties, ? extends Block> blockFactory;
        public final String[] typeRequirements;
        public IdGetter idGetter;
        public final Set<String> requiresSolid = new HashSet<String>();

        WoodVariant(String name, String parent, Function<BlockBehaviour.Properties, ? extends Block> blockFactory, String ... typeRequirements) {
            this.name = name;
            this.parent = parent;
            this.blockFactory = blockFactory;
            this.typeRequirements = typeRequirements;
            this.idGetter = wood -> wood.getVariantId("%s_" + this.name);
            WOOD_VARIANTS.add(this);
        }

        WoodVariant(String name, String parent, Function<BlockBehaviour.Properties, ? extends Block> blockFactory) {
            this(name, parent, blockFactory, new String[0]);
        }

        public WoodVariant setIdGetter(IdGetter idGetter) {
            this.idGetter = idGetter;
            return this;
        }

        public WoodVariant setRequiresSolid(String ... variants) {
            this.requiresSolid.addAll(List.of(variants));
            return this;
        }

        public WoodVariant setRequiresSolid() {
            return this.setRequiresSolid(this.parent);
        }

        public static interface IdGetter {
            public String get(WoodType var1);
        }
    }
}

