/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.reg;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.AnalogRailBlock;
import dev.chililisoup.condiments.block.BrazierBlock;
import dev.chililisoup.condiments.block.CopperFireBlock;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.RailIntersectionBlock;
import dev.chililisoup.condiments.block.RedstoneLedBlock;
import dev.chililisoup.condiments.block.SaucerLightBlock;
import dev.chililisoup.condiments.block.WaterloggedTransparentBlock;
import dev.chililisoup.condiments.block.WaxedIronBlock;
import dev.chililisoup.condiments.item.CrateItem;
import dev.chililisoup.condiments.reg.ModItems;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final HashMap<Supplier<Block>, String> ALT_RENDERED_BLOCKS = new HashMap();
    public static final Supplier<Block> RAIL_INTERSECTION = ModBlocks.addBlock(new Params("rail_intersection", () -> new RailIntersectionBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50156_))).cutout());
    public static final Supplier<Block> ANALOG_RAIL = ModBlocks.addBlock(new Params("analog_rail", () -> new AnalogRailBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50030_))).cutout());
    public static final Supplier<Block> CRATE = ModBlocks.addCrate("crate", null);
    public static final Supplier<Block> WHITE_CRATE = ModBlocks.addCrate("white_crate", DyeColor.WHITE);
    public static final Supplier<Block> LIGHT_GRAY_CRATE = ModBlocks.addCrate("light_gray_crate", DyeColor.LIGHT_GRAY);
    public static final Supplier<Block> GRAY_CRATE = ModBlocks.addCrate("gray_crate", DyeColor.GRAY);
    public static final Supplier<Block> BLACK_CRATE = ModBlocks.addCrate("black_crate", DyeColor.BLACK);
    public static final Supplier<Block> BROWN_CRATE = ModBlocks.addCrate("brown_crate", DyeColor.BROWN);
    public static final Supplier<Block> RED_CRATE = ModBlocks.addCrate("red_crate", DyeColor.RED);
    public static final Supplier<Block> ORANGE_CRATE = ModBlocks.addCrate("orange_crate", DyeColor.ORANGE);
    public static final Supplier<Block> YELLOW_CRATE = ModBlocks.addCrate("yellow_crate", DyeColor.YELLOW);
    public static final Supplier<Block> LIME_CRATE = ModBlocks.addCrate("lime_crate", DyeColor.LIME);
    public static final Supplier<Block> GREEN_CRATE = ModBlocks.addCrate("green_crate", DyeColor.GREEN);
    public static final Supplier<Block> CYAN_CRATE = ModBlocks.addCrate("cyan_crate", DyeColor.CYAN);
    public static final Supplier<Block> LIGHT_BLUE_CRATE = ModBlocks.addCrate("light_blue_crate", DyeColor.LIGHT_BLUE);
    public static final Supplier<Block> BLUE_CRATE = ModBlocks.addCrate("blue_crate", DyeColor.BLUE);
    public static final Supplier<Block> PURPLE_CRATE = ModBlocks.addCrate("purple_crate", DyeColor.PURPLE);
    public static final Supplier<Block> MAGENTA_CRATE = ModBlocks.addCrate("magenta_crate", DyeColor.MAGENTA);
    public static final Supplier<Block> PINK_CRATE = ModBlocks.addCrate("pink_crate", DyeColor.PINK);
    public static final Supplier<Block> WAXED_IRON_BLOCK = ModBlocks.addBlock(new Params("waxed_iron_block", () -> new WaxedIronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))));
    public static final Supplier<Block> BLACKENED_IRON_BLOCK = ModBlocks.addBlock(new Params("blackened_iron_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))));
    public static final Supplier<Block> BLACKENED_IRON_GRATE = ModBlocks.addBlock(new Params("blackened_iron_grate", () -> new WaterloggedTransparentBlock(BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_284180_(MapColor.f_283906_).m_60955_().m_60999_().m_60922_(ModBlocks::never).m_60924_(ModBlocks::never).m_60960_(ModBlocks::never).m_60971_(ModBlocks::never))).cutout());
    public static final Supplier<Block> BLACKENED_IRON_BARS = ModBlocks.addBlock(new Params("blackened_iron_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_))).cutout());
    public static final Supplier<Block> BLACKENED_IRON_DOOR = ModBlocks.addBlock(new Params("blackened_iron_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50166_), BlockSetType.f_271132_)).cutout());
    public static final Supplier<Block> BLACKENED_IRON_TRAPDOOR = ModBlocks.addBlock(new Params("blackened_iron_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50376_), BlockSetType.f_271132_)).cutout());
    public static final Supplier<Block> REDSTONE_LED = ModBlocks.addBlock(new Params("redstone_led", () -> new RedstoneLedBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60953_(state -> 1).m_60991_(ModBlocks::always))).cutout());
    public static final Supplier<Block> SAUCER_LIGHT = ModBlocks.addBlock(new Params("saucer_light", () -> new SaucerLightBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0).m_278166_(PushReaction.NORMAL))));
    public static final Supplier<Block> BRAZIER = ModBlocks.addBlock(new Params("brazier", () -> new BrazierBlock(1, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56762_).m_60953_(ModBlocks.litBlockEmission(15)).m_60955_().m_278183_())).cutout());
    public static final Supplier<Block> COPPER_FIRE = ModBlocks.addBlock(new Params("copper_fire", () -> new CopperFireBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50084_).m_284180_(MapColor.f_283916_))).noItem().cutout());

    private static Supplier<Block> addBlock(Params params) {
        RegSupplier regSupplier = RegHelper.registerBlock((ResourceLocation)Condiments.loc(params.id), params.blockFactory);
        Supplier<Block> blockSupplier = () -> ((RegSupplier)regSupplier).get();
        if (params.createItem) {
            ModItems.addItem(params.getItemParams(blockSupplier));
        }
        if (params.renderType != null && PlatHelper.getPhysicalSide().isClient()) {
            ALT_RENDERED_BLOCKS.put(blockSupplier, params.renderType);
        }
        return blockSupplier;
    }

    public static void init() {
    }

    private static Supplier<Block> addCrate(String id, DyeColor color) {
        return ModBlocks.addBlock(new CrateParams(id, () -> new CrateBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_278166_(PushReaction.DESTROY))));
    }

    public static Block[] getCrates() {
        return new Block[]{CRATE.get(), WHITE_CRATE.get(), LIGHT_GRAY_CRATE.get(), GRAY_CRATE.get(), BLACK_CRATE.get(), BROWN_CRATE.get(), RED_CRATE.get(), ORANGE_CRATE.get(), YELLOW_CRATE.get(), LIME_CRATE.get(), GREEN_CRATE.get(), CYAN_CRATE.get(), LIGHT_BLUE_CRATE.get(), BLUE_CRATE.get(), PURPLE_CRATE.get(), MAGENTA_CRATE.get(), PINK_CRATE.get()};
    }

    public static boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    public static class Params {
        public final String id;
        public final Supplier<? extends Block> blockFactory;
        public boolean createItem = true;
        public String renderType = null;

        public Params(String id, Supplier<? extends Block> blockFactory) {
            this.id = id;
            this.blockFactory = blockFactory;
        }

        public ModItems.Params getItemParams(Supplier<? extends Block> block) {
            return new ModItems.Params(this.id, () -> this.getItem(block));
        }

        public BlockItem getItem(Supplier<? extends Block> block) {
            return new BlockItem(block.get(), new Item.Properties());
        }

        public Params noItem() {
            this.createItem = false;
            return this;
        }

        public Params cutout() {
            this.renderType = "CUTOUT";
            return this;
        }
    }

    public static class CrateParams
    extends Params {
        CrateParams(String id, Supplier<? extends Block> blockFactory) {
            super(id, blockFactory);
        }

        @Override
        public BlockItem getItem(Supplier<? extends Block> block) {
            return new CrateItem(block.get(), new Item.Properties());
        }
    }
}

