/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import dev.chililisoup.condiments.block.CondimentsRail;
import dev.chililisoup.condiments.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AnalogRailBlock
extends BaseRailBlock
implements CondimentsRail {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public AnalogRailBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false)));
    }

    protected int findAnalogRailSignal(Level level, BlockPos pos, BlockState state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8) {
            return 0;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        boolean ascending = true;
        RailShape railShape = (RailShape)state.m_61143_(SHAPE);
        switch (railShape) {
            case NORTH_SOUTH: {
                z = searchForward ? ++z : --z;
                ascending = false;
                break;
            }
            case EAST_WEST: {
                x = searchForward ? --x : ++x;
                ascending = false;
                break;
            }
            case ASCENDING_EAST: {
                if (searchForward) {
                    --x;
                } else {
                    ++x;
                    ++y;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (searchForward) {
                    --x;
                    ++y;
                } else {
                    ++x;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (searchForward) {
                    ++z;
                } else {
                    --z;
                    ++y;
                }
                railShape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (searchForward) {
                    ++z;
                    ++y;
                } else {
                    --z;
                }
                railShape = RailShape.NORTH_SOUTH;
            }
        }
        int flatSignal = this.getConnectedPower(level, new BlockPos(x, y, z), searchForward, recursionCount, railShape);
        if (flatSignal > 0) {
            return flatSignal;
        }
        if (ascending) {
            return 0;
        }
        return this.getConnectedPower(level, new BlockPos(x, y - 1, z), searchForward, recursionCount, railShape);
    }

    protected int getConnectedPower(Level level, BlockPos pos, boolean searchForward, int recursionCount, RailShape shape) {
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_60713_((Block)this)) {
            return 0;
        }
        RailShape railShape = (RailShape)blockState.m_61143_(SHAPE);
        if (shape == RailShape.EAST_WEST && (railShape == RailShape.NORTH_SOUTH || railShape == RailShape.ASCENDING_NORTH || railShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (railShape == RailShape.EAST_WEST || railShape == RailShape.ASCENDING_EAST || railShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        int power = (Integer)blockState.m_61143_((Property)POWER);
        if (power > 0) {
            int signal = level.m_277086_(pos);
            if (signal > 14) {
                return signal;
            }
            return Math.max(this.findAnalogRailSignal(level, pos, blockState, searchForward, recursionCount + 1), signal);
        }
        return 0;
    }

    protected void m_6360_(BlockState state, Level level, BlockPos pos, Block neighborBlock) {
        int power = (Integer)state.m_61143_((Property)POWER);
        int signal = level.m_277086_(pos);
        if (signal < 15) {
            int backward;
            int forward = this.findAnalogRailSignal(level, pos, state, true, 0);
            if (forward > signal) {
                signal = forward;
            }
            if (signal < 15 && (backward = this.findAnalogRailSignal(level, pos, state, false, 0)) > signal) {
                signal = backward;
            }
        }
        if (signal == power) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(signal)), 3);
        level.m_46672_(pos.m_7495_(), (Block)this);
        if (((RailShape)state.m_61143_(SHAPE)).m_61745_()) {
            level.m_46672_(pos.m_7494_(), (Block)this);
        }
    }

    @NotNull
    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    public Property<Integer> getPowerProperty() {
        return POWER;
    }

    @Override
    public double getMaxSpeed(AbstractMinecart cart) {
        return (cart.m_20069_() ? 0.5 : 1.0) * CommonConfig.ANALOG_RAIL_MAX_SPEED.get();
    }

    @Override
    public void moveAlongTrack(BlockPos pos, BlockState state, RailShape railShape, AbstractMinecart cart) {
        Vec3 movement = cart.m_20184_();
        double x = movement.f_82479_;
        double z = movement.f_82481_;
        double horizontalDistance = movement.m_165924_();
        int power = (Integer)state.m_61143_(((AnalogRailBlock)state.m_60734_()).getPowerProperty());
        if (power == 0) {
            if (horizontalDistance < 0.03) {
                cart.m_20256_(Vec3.f_82478_);
            } else {
                cart.m_20256_(movement.m_82542_(0.5, 0.0, 0.5));
            }
            return;
        }
        if (horizontalDistance > 0.01) {
            double speed = (double)power * this.getMaxSpeed(cart) / 15.0;
            if (x > 0.01) {
                x = speed;
            } else if (x < -0.01) {
                x = -speed;
            }
            if (z > 0.01) {
                z = speed;
            } else if (z < -0.01) {
                z = -speed;
            }
            cart.m_20334_(x, 0.0, z);
            return;
        }
        if (railShape == RailShape.EAST_WEST) {
            if (this.isRedstoneConductor(pos.m_122024_(), cart)) {
                x = 0.02;
            } else if (this.isRedstoneConductor(pos.m_122029_(), cart)) {
                x = -0.02;
            }
        } else {
            if (railShape != RailShape.NORTH_SOUTH) {
                return;
            }
            if (this.isRedstoneConductor(pos.m_122012_(), cart)) {
                z = 0.02;
            } else if (this.isRedstoneConductor(pos.m_122019_(), cart)) {
                z = -0.02;
            }
        }
        cart.m_20334_(x, movement.f_82480_, z);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, POWER, f_152149_});
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return (float)this.getMaxSpeed(cart);
    }
}

