/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.reg.ModComponents;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CrateContents(@Nullable ItemRecord itemRecord, int count, Boolean locked, Boolean autoPickup) {
    public static final CrateContents EMPTY = new CrateContents();
    public static final Codec<CrateContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRecord.ITEM_CODEC.optionalFieldOf("item").forGetter(CrateContents::itemRecordOptional), (App)Codec.INT.fieldOf("count").forGetter(CrateContents::count), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(CrateContents::lockedOptional), (App)Codec.BOOL.optionalFieldOf("autoPickup").forGetter(CrateContents::autoPickupOptional)).apply((Applicative)instance, CrateContents::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrateContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemRecord.ITEM_STREAM_CODEC.apply(ByteBufCodecs::optional), CrateContents::itemRecordOptional, (StreamCodec)ByteBufCodecs.INT, CrateContents::count, (StreamCodec)ByteBufCodecs.BOOL.apply(ByteBufCodecs::optional), CrateContents::lockedOptional, (StreamCodec)ByteBufCodecs.BOOL.apply(ByteBufCodecs::optional), CrateContents::autoPickupOptional, CrateContents::new);

    public CrateContents(@Nullable ItemRecord itemRecord, int count) {
        this(itemRecord, count, false, false);
    }

    public CrateContents() {
        this(null, 0);
    }

    private CrateContents(Optional<ItemRecord> itemRecord, int count, Optional<Boolean> locked, Optional<Boolean> autoPickup) {
        this(itemRecord.orElse(null), count, locked.orElse(false), autoPickup.orElse(false));
    }

    private Optional<ItemRecord> itemRecordOptional() {
        return Optional.ofNullable(this.itemRecord);
    }

    private Optional<Boolean> lockedOptional() {
        return this.locked != false ? Optional.of(true) : Optional.empty();
    }

    private Optional<Boolean> autoPickupOptional() {
        return this.autoPickup != false ? Optional.of(true) : Optional.empty();
    }

    public static CrateContents fromCrateItem(ItemStack crateItem) {
        return (CrateContents)crateItem.getOrDefault(ModComponents.CRATE_CONTENTS.get(), (Object)EMPTY);
    }

    public void updateCrateItem(ItemStack crateItem) {
        crateItem.set(ModComponents.CRATE_CONTENTS.get(), (Object)this);
        crateItem.set(DataComponents.MAX_STACK_SIZE, (Object)(this.count > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
    }

    public Optional<ItemStack> item() {
        return this.itemRecordOptional().flatMap(itemRecord -> Optional.of(itemRecord.asItemStack()));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static int maxStacks() {
        return CommonConfig.CRATE_MAX_CONTAINED_STACKS.get();
    }

    public int capacity() {
        int stackCount = CrateContents.maxStacks();
        return this.item().map(stack -> stack.getMaxStackSize() * stackCount).orElse(0);
    }

    public float fillPercent() {
        if (this.count <= 0 && !this.isLocked()) {
            return -1.0f;
        }
        if (this.item().isEmpty()) {
            return -1.0f;
        }
        return (float)this.count / (float)this.capacity();
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public SlottedMutable toSlottedMutable() {
        return new SlottedMutable(this);
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("%s x %d, %s", this.item(), this.count, this.isLocked() ? "LOCKED" : "UNLOCKED");
    }

    public static boolean isItemUnsafe(ItemStack stack) {
        ItemContainerContents containerContents;
        if (stack.isEmpty()) {
            return true;
        }
        if (stack.has(DataComponents.CONTAINER) && (containerContents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyStream().findAny().isPresent()) {
            return true;
        }
        if (stack.has(ModComponents.CRATE_CONTENTS.get())) {
            if (!CommonConfig.CRATES_CONTAIN_EMPTY_CRATES.get().booleanValue()) {
                return true;
            }
            CrateContents crateContents = (CrateContents)stack.getOrDefault(ModComponents.CRATE_CONTENTS.get(), (Object)EMPTY);
            return crateContents.count > 0;
        }
        return false;
    }

    public record ItemRecord(Holder<Item> item, DataComponentPatch components) {
        public static final Codec<ItemRecord> ITEM_CODEC = ItemStack.CODEC.xmap(ItemRecord::of, ItemRecord::asItemStack);
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemRecord> ITEM_STREAM_CODEC = ItemStack.STREAM_CODEC.map(ItemRecord::of, ItemRecord::asItemStack);

        public ItemStack asItemStack() {
            return new ItemStack(this.item, 1, this.components);
        }

        public static ItemRecord of(ItemStack item) {
            return new ItemRecord((Holder<Item>)item.getItemHolder(), ((PatchedDataComponentMap)item.getComponents()).asPatch());
        }
    }

    public static class Mutable {
        private ItemStack item = ItemStack.EMPTY;
        private int count;
        private boolean locked;
        private boolean autoPickup;

        private Mutable() {
        }

        public Mutable(CrateContents contents) {
            this.setValues(contents);
        }

        public Mutable setValues(CrateContents contents) {
            this.setLocked(contents.locked);
            this.setItemType(contents.item().orElse(null));
            this.setCount(contents.count);
            this.setAutoPickup(contents.autoPickup);
            return this;
        }

        public ItemStack getItemType(int count) {
            return this.item.copyWithCount(count);
        }

        public ItemStack getItemType() {
            return this.getItemType(1);
        }

        public void setItemType(@Nullable ItemStack stack) {
            this.item = stack != null ? stack.copyWithCount(1) : ItemStack.EMPTY;
        }

        public boolean isEmptyNoLock() {
            return this.getCount() <= 0 && !this.isLocked();
        }

        protected void updateItemType() {
            if (this.isEmptyNoLock()) {
                this.setItemType(null);
            }
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
            this.updateItemType();
        }

        public void grow(int increment) {
            this.setCount(this.getCount() + increment);
        }

        public void shrink(int decrement) {
            this.setCount(this.getCount() - decrement);
        }

        public void clear() {
            this.setCount(0);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
            this.updateItemType();
        }

        public boolean isAutoPickup() {
            return this.autoPickup;
        }

        public void setAutoPickup(boolean autoPickup) {
            this.autoPickup = autoPickup;
        }

        public int getMaxStackSize() {
            return this.getItemType().getMaxStackSize();
        }

        public int getCountRemaining() {
            ItemStack itemType = this.getItemType();
            return itemType.isEmpty() ? -1 : Math.max(itemType.getMaxStackSize() * CrateContents.maxStacks() - this.getCount(), 0);
        }

        protected int getMaxAmountToAdd(ItemStack stack) {
            int countRemaining = this.getCountRemaining();
            return countRemaining == -1 ? stack.getMaxStackSize() * CrateContents.maxStacks() : countRemaining;
        }

        protected int getMaxAmountToAdd() {
            return this.getMaxAmountToAdd(this.getItemType());
        }

        public boolean canAdd(ItemStack stack) {
            if (CrateContents.isItemUnsafe(stack)) {
                return false;
            }
            ItemStack itemType = this.getItemType();
            return itemType.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemType, (ItemStack)stack);
        }

        public int getToAdd(ItemStack stack) {
            if (!this.canAdd(stack)) {
                return 0;
            }
            return Math.min(this.getMaxAmountToAdd(stack), stack.getCount());
        }

        public int addFromStack(ItemStack stack, boolean simulate) {
            if (!this.canAdd(stack)) {
                return 0;
            }
            this.setItemType(stack);
            int amt = this.getToAdd(stack);
            if (amt == 0) {
                return 0;
            }
            stack.shrink(amt);
            if (!simulate) {
                this.grow(amt);
            }
            return amt;
        }

        public int addFromStack(ItemStack stack) {
            return this.addFromStack(stack, false);
        }

        public int addFromSlot(Slot slot, Player player) {
            ItemStack stack = slot.getItem();
            int amt = this.getToAdd(stack);
            if (amt == 0) {
                return 0;
            }
            return this.addFromStack(slot.safeTake(stack.getCount(), amt, player));
        }

        public ItemStack tryAddStack(ItemStack stack, boolean simulate) {
            ItemStack refStack = stack.copy();
            if (!this.canAdd(refStack)) {
                return refStack;
            }
            if (refStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.addFromStack(refStack, simulate);
            return refStack;
        }

        public boolean addAllInventory(Player player) {
            if (this.isEmptyNoLock()) {
                return false;
            }
            int addCount = player.getInventory().clearOrCountMatchingItems(this::canAdd, this.getMaxAmountToAdd(), (Container)player.getInventory());
            if (addCount <= 0) {
                return false;
            }
            this.grow(addCount);
            return true;
        }

        public ItemStack request(int amount) {
            ItemStack itemType = this.getItemType();
            if (itemType.isEmpty() || this.getCount() <= 0) {
                return ItemStack.EMPTY;
            }
            int amt = Math.min(amount, this.getCount());
            this.shrink(amt);
            this.updateItemType();
            return itemType.copyWithCount(amt);
        }

        public ItemStack requestOne() {
            return this.request(1);
        }

        public ItemStack requestOneStack() {
            ItemStack itemType = this.getItemType();
            return itemType.isEmpty() ? ItemStack.EMPTY : this.request(itemType.getMaxStackSize());
        }

        public CrateContents toImmutable() {
            this.updateItemType();
            ItemStack itemType = this.getItemType();
            return new CrateContents(itemType.isEmpty() ? null : ItemRecord.of(itemType), this.getCount(), this.isLocked(), this.isAutoPickup());
        }

        public String toString() {
            return this.toImmutable().toString();
        }
    }

    public static class SlottedMutable
    extends Mutable {
        private final NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)CrateContents.maxStacks(), (Object)ItemStack.EMPTY);

        public SlottedMutable(CrateContents contents) {
            this.setValues(contents);
        }

        @Override
        public Mutable setValues(CrateContents contents) {
            this.itemStacks.clear();
            return super.setValues(contents);
        }

        @Override
        public int getCount() {
            AtomicInteger count = new AtomicInteger();
            this.itemStacks.forEach(stack -> count.addAndGet(stack.getCount()));
            return count.get();
        }

        @Override
        public void setCount(int count) {
            ItemStack itemType = this.getItemType();
            if (count == 0 || itemType.isEmpty()) {
                this.itemStacks.clear();
            } else {
                int maxStackSize = itemType.getMaxStackSize();
                int remaining = count - this.getCount();
                if (remaining > 0) {
                    for (int i = 0; i < this.itemStacks.size() && remaining > 0; ++i) {
                        ItemStack stack = (ItemStack)this.itemStacks.get(i);
                        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemType)) {
                            int free = maxStackSize - stack.getCount();
                            if (free <= 0) continue;
                            int toAdd = Math.min(remaining, free);
                            remaining -= toAdd;
                            stack.grow(toAdd);
                            continue;
                        }
                        int toAdd = Math.min(remaining, maxStackSize);
                        this.itemStacks.set(i, (Object)itemType.copyWithCount(toAdd));
                        remaining -= toAdd;
                    }
                } else if (remaining < 0) {
                    remaining = Math.abs(remaining);
                    for (int i = this.itemStacks.size() - 1; i >= 0 && remaining > 0; --i) {
                        ItemStack stack = (ItemStack)this.itemStacks.get(i);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemType)) continue;
                        int toRemove = Math.min(stack.getCount(), remaining);
                        remaining -= toRemove;
                        stack.shrink(toRemove);
                    }
                }
            }
            super.setCount(count);
        }

        public ItemStack getSlot(int slot) {
            return (ItemStack)this.itemStacks.get(slot);
        }

        public ItemStack[] getSlottedStacks() {
            return (ItemStack[])this.itemStacks.stream().map(ItemStack::copy).toArray(ItemStack[]::new);
        }

        public boolean setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!stack.isEmpty() && !this.canAdd(stack)) {
                return false;
            }
            this.itemStacks.set(slot, (Object)stack);
            if (!stack.isEmpty()) {
                this.setItemType(stack);
            }
            this.updateItemType();
            return true;
        }

        public ItemStack insertIntoSlot(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemStack refStack = stack.copy();
            if (!this.canAdd(stack)) {
                return refStack;
            }
            ItemStack currentItemType = this.getItemType();
            ItemStack itemType = currentItemType.isEmpty() ? refStack.copyWithCount(1) : currentItemType;
            ItemStack slotStack = this.getSlot(slot);
            int freeSpace = itemType.getMaxStackSize() - slotStack.getCount();
            int toAdd = Math.min(refStack.getCount(), freeSpace);
            if (toAdd <= 0) {
                return refStack;
            }
            if (!simulate) {
                this.setItemType(itemType);
                this.grow(toAdd);
            }
            refStack.shrink(toAdd);
            return refStack;
        }

        @NotNull
        public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
            ItemStack slotStack = this.getSlot(slot);
            if (slotStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int finalAmt = Math.min(slotStack.getCount(), amount);
            ItemStack returnStack = slotStack.copyWithCount(finalAmt);
            if (!simulate) {
                if (finalAmt == slotStack.getCount()) {
                    this.itemStacks.set(slot, (Object)ItemStack.EMPTY);
                } else {
                    slotStack.shrink(finalAmt);
                }
                this.updateItemType();
            }
            return returnStack;
        }

        @NotNull
        public ItemStack removeFromSlot(int slot) {
            ItemStack slotStack = this.getSlot(slot);
            if (slotStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.setStackInSlot(slot, ItemStack.EMPTY);
            this.updateItemType();
            return slotStack;
        }
    }
}

