/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.reg;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.AccentBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2465;
import net.minecraft.class_2544;
import net.minecraft.class_265;
import net.minecraft.class_4970;

public class ModBlockSetVariants {
    public static final ArrayList<WoodVariant> WOOD_VARIANTS = new ArrayList();
    public static final WoodVariant WOOD_WALLS = new WoodVariant("wall", "fence", properties -> new class_2544(properties.method_51369()), "log").setRequiresSolid("stripped_log");
    public static final WoodVariant WOOD_ACCENTS = new WoodVariant("accent", "fence", AccentBlock::new).setRequiresSolid("stripped_log");
    public static final WoodVariant POLISHED_WOOD = new WoodVariant("polished_wood", "stripped_wood", class_2465::new, "stripped_log", "wood").setIdGetter(wood -> {
        class_2248 block = wood.getBlockOfThis("stripped_wood");
        return block == null ? wood.getVariantId("polished_%s_wood") : (String)(wood.isVanilla() ? "" : wood.getNamespace() + "/") + Utils.getID((class_2248)block).method_12832().replace("stripped", "polished");
    }).setRequiresSolid();
    public static final WoodVariant POLISHED_LOGS = new WoodVariant("polished_log", "stripped_log", class_2465::new, "stripped_wood").setIdGetter(wood -> {
        class_2248 block = wood.getBlockOfThis("stripped_log");
        return block == null ? wood.getVariantId("polished_%s_log") : (String)(wood.isVanilla() ? "" : wood.getNamespace() + "/") + Utils.getID((class_2248)block).method_12832().replace("stripped", "polished");
    }).setRequiresSolid();

    private static void markFlammable(class_2248 block) {
        RegHelper.registerBlockFlammability((class_2248)block, (int)5, (int)5);
    }

    public static void init() {
        BlockSetAPI.addDynamicBlockRegistration(ModBlockSetVariants::registerWoodBlocks, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(ModBlockSetVariants::registerWoodItems, WoodType.class);
    }

    private static void registerWoodBlocks(Registrator<class_2248> event, Collection<WoodType> woodTypes) {
        for (WoodVariant woodVariant : WOOD_VARIANTS) {
            for (WoodType wood : woodTypes) {
                class_2248 parent;
                if (Arrays.stream(woodVariant.typeRequirements).anyMatch(req -> wood.getBlockOfThis(req) == null) || (parent = wood.getBlockOfThis(woodVariant.parent)) == null || woodVariant.requiresSolid.stream().anyMatch(variant -> {
                    class_2248 solid = wood.getBlockOfThis(variant);
                    if (solid == null) {
                        return true;
                    }
                    try {
                        if (!class_2248.method_9614((class_265)solid.method_9564().method_26218(null, null))) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        return true;
                    }
                    return false;
                })) continue;
                class_2248 block = woodVariant.blockFactory.apply(class_4970.class_2251.method_9630((class_4970)parent));
                String name = woodVariant.idGetter.get(wood);
                wood.addChild("condiments:" + woodVariant.name, (Object)block);
                event.register(Condiments.loc(name), (Object)block);
                if (!wood.canBurn()) continue;
                ModBlockSetVariants.markFlammable(block);
            }
        }
    }

    private static void registerWoodItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodVariant woodVariant : WOOD_VARIANTS) {
            for (WoodType wood : woodTypes) {
                Object object = wood.getChild("condiments:" + woodVariant.name);
                if (!(object instanceof class_2248)) continue;
                class_2248 block = (class_2248)object;
                String name = woodVariant.idGetter.get(wood);
                WoodBasedBlockItem item = new WoodBasedBlockItem(block, new class_1792.class_1793(), wood);
                event.register(Condiments.loc(name), (Object)item);
                woodVariant.items.put(wood, item);
            }
        }
    }

    public static class WoodVariant {
        public final HashMap<WoodType, WoodBasedBlockItem> items = new HashMap();
        public final String name;
        public final String parent;
        public final Function<class_4970.class_2251, ? extends class_2248> blockFactory;
        public final String[] typeRequirements;
        public IdGetter idGetter;
        public final Set<String> requiresSolid = new HashSet<String>();

        WoodVariant(String name, String parent, Function<class_4970.class_2251, ? extends class_2248> blockFactory, String ... typeRequirements) {
            this.name = name;
            this.parent = parent;
            this.blockFactory = blockFactory;
            this.typeRequirements = typeRequirements;
            this.idGetter = wood -> wood.getVariantId("%s_" + this.name);
            WOOD_VARIANTS.add(this);
        }

        WoodVariant(String name, String parent, Function<class_4970.class_2251, ? extends class_2248> blockFactory) {
            this(name, parent, blockFactory, new String[0]);
        }

        public WoodVariant setIdGetter(IdGetter idGetter) {
            this.idGetter = idGetter;
            return this;
        }

        public WoodVariant setRequiresSolid(String ... variants) {
            this.requiresSolid.addAll(List.of(variants));
            return this;
        }

        public WoodVariant setRequiresSolid() {
            return this.setRequiresSolid(this.parent);
        }

        public static interface IdGetter {
            public String get(WoodType var1);
        }
    }
}

