/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.block.entity.fabric.CrateBlockEntityImpl;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.reg.ModBlockEntities;
import dev.chililisoup.condiments.reg.ModComponents;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5000;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntity
extends class_2586
implements class_1263,
class_1275 {
    private final CrateContents.SlottedMutable contents = new CrateContents().toSlottedMutable();
    @Nullable
    private class_2561 name;

    public int method_5439() {
        return CrateContents.maxStacks();
    }

    protected CrateBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.CRATE_BE_TYPE.get(), pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CrateBlockEntity of(class_2338 pos, class_2680 blockState) {
        void var1_1;
        return CrateBlockEntityImpl.of(pos, (class_2680)var1_1);
    }

    public CrateContents getContents() {
        return this.contents.toImmutable();
    }

    public class_1799 getItemType() {
        return this.contents.getItemType();
    }

    public int getCount() {
        return this.contents.getCount();
    }

    public boolean isLocked() {
        return this.contents.isLocked();
    }

    private class_2487 prepareUpdateTag(class_2487 tag, class_7225.class_7874 registries) {
        class_2487 storageTag = (class_2487)this.getItemType().method_57375(registries);
        storageTag.method_10575("count", (short)this.getCount());
        tag.method_10566("CrateItems", (class_2520)storageTag);
        tag.method_10556("CrateLocked", this.isLocked());
        return tag;
    }

    private void updateClient() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.prepareUpdateTag(tag, registries);
        if (this.name != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.name, (class_7225.class_7874)registries));
        }
    }

    private void loadStorage(class_2487 tag, class_7225.class_7874 registries) {
        this.contents.setLocked(tag.method_10577("CrateLocked"));
        short count = tag.method_10562("CrateItems").method_10568("count");
        class_2487 storageTag = tag.method_10562("CrateItems");
        if (storageTag.method_10545("id")) {
            storageTag.method_10569("count", 1);
        } else {
            storageTag.method_10551("count");
        }
        this.contents.setItemType(class_1799.method_57359((class_7225.class_7874)registries, (class_2487)storageTag));
        this.contents.setCount(count);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.loadStorage(tag, registries);
        if (tag.method_10573("CustomName", 8)) {
            this.name = CrateBlockEntity.method_59894((String)tag.method_10558("CustomName"), (class_7225.class_7874)registries);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.contents.canAdd(stack);
    }

    public int method_18861(class_1792 item) {
        return this.getItemType().method_7909().equals(item) ? this.getCount() : 0;
    }

    public boolean method_43256(Predicate<class_1799> predicate) {
        return predicate.test(this.getItemType());
    }

    public boolean method_5442() {
        return this.contents.isEmptyNoLock();
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return this.contents.getSlot(slot);
    }

    public int method_5444() {
        return this.contents.getMaxStackSize();
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 item = this.contents.extractFromSlot(slot, amount, false);
        if (item.method_7960()) {
            return item;
        }
        this.method_5431();
        return item;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return this.contents.removeFromSlot(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (!this.contents.setStackInSlot(slot, stack)) {
            return;
        }
        this.method_5431();
    }

    private void addAllInventory(class_1657 player) {
        if (!this.contents.addAllInventory(player)) {
            return;
        }
        this.method_5431();
        this.playSound(this.method_11010(), class_3417.field_14667);
    }

    public class_1799 tryAddStack(class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return stack;
        }
        class_1799 item = this.contents.tryAddStack(stack, simulate);
        if (class_1799.method_31577((class_1799)item, (class_1799)stack) && item.method_7947() == stack.method_7947()) {
            return item;
        }
        this.method_5431();
        this.playSound(this.method_11010(), class_3417.field_14667);
        return item;
    }

    public class_1799 tryAddStack(class_1799 stack) {
        return this.tryAddStack(stack, false);
    }

    public class_1799 tryAddStack(class_1799 stack, class_1657 player) {
        if (stack.method_7960()) {
            this.addAllInventory(player);
            return class_1799.field_8037;
        }
        return this.tryAddStack(stack);
    }

    public class_1799 insertIntoSlot(int slot, @NotNull class_1799 stack, boolean simulate) {
        class_1799 result = this.contents.insertIntoSlot(slot, stack, simulate);
        this.method_5431();
        return result;
    }

    public class_1799 extractFromSlot(int slot, int amount, boolean simulate) {
        class_1799 result = this.contents.extractFromSlot(slot, amount, simulate);
        this.method_5431();
        return result;
    }

    private class_1799 finishRequest(class_1799 stack) {
        this.method_5431();
        this.playSound(this.method_11010(), class_3417.field_14770);
        return stack;
    }

    public class_1799 request(int amount) {
        return this.finishRequest(this.contents.request(amount));
    }

    public class_1799 requestOne() {
        return this.finishRequest(this.contents.requestOne());
    }

    public class_1799 requestOneStack() {
        return this.finishRequest(this.contents.requestOneStack());
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.contents.clear();
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        this.updateClient();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.prepareUpdateTag(new class_2487(), registries);
    }

    void playSound(class_2680 state, class_3414 sound) {
        if (this.field_11863 == null) {
            return;
        }
        class_2382 vec3i = ((class_5000)state.method_11654((class_2769)class_2741.field_23333)).method_26426().method_10163();
        double d = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double e = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double f = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d, e, f, sound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    protected class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.condiments.crate");
    }

    @NotNull
    public class_2561 method_5477() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @NotNull
    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.name;
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        this.name = (class_2561)componentInput.method_58694(class_9334.field_49631);
        CrateContents crateContents = (CrateContents)componentInput.method_58695(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        this.loadCrateContents(crateContents);
    }

    public void loadCrateContents(CrateContents crateContents) {
        this.contents.setValues(crateContents);
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(class_9334.field_49631, (Object)this.name);
        components.method_57840(ModComponents.CRATE_CONTENTS.get(), (Object)this.contents.toImmutable());
        components.method_57840(class_9334.field_50071, (Object)(this.getCount() > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
    }
}

