/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.reg.ModComponents;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CrateContents(Optional<ItemRecord> itemRecord, int count, Optional<Boolean> locked) {
    public static final CrateContents EMPTY = new CrateContents();
    public static final Codec<CrateContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRecord.ITEM_CODEC.optionalFieldOf("item").forGetter(CrateContents::itemRecord), (App)Codec.INT.fieldOf("count").forGetter(CrateContents::count), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(CrateContents::locked)).apply((Applicative)instance, CrateContents::new));
    public static final class_9139<class_9129, CrateContents> STREAM_CODEC = class_9139.method_56436((class_9139)ItemRecord.ITEM_STREAM_CODEC.method_56433(class_9135::method_56382), CrateContents::itemRecord, (class_9139)class_9135.field_49675, CrateContents::count, (class_9139)class_9135.field_48547.method_56433(class_9135::method_56382), CrateContents::locked, CrateContents::new);

    public CrateContents(Optional<ItemRecord> itemRecord, int count) {
        this(itemRecord, count, Optional.empty());
    }

    public CrateContents() {
        this(Optional.empty(), 0);
    }

    public Optional<class_1799> item() {
        return this.itemRecord.flatMap(itemRecord -> Optional.of(itemRecord.asItemStack()));
    }

    public boolean isLocked() {
        return this.locked.orElse(false);
    }

    public static int maxStacks() {
        return CommonConfig.CRATE_MAX_CONTAINED_STACKS.get();
    }

    public int capacity() {
        int stackCount = CrateContents.maxStacks();
        return this.item().map(stack -> stack.method_7914() * stackCount).orElse(0);
    }

    public float fillPercent() {
        if (this.count <= 0 && !this.isLocked()) {
            return -1.0f;
        }
        if (this.item().isEmpty()) {
            return -1.0f;
        }
        return (float)this.count / (float)this.capacity();
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public SlottedMutable toSlottedMutable() {
        return new SlottedMutable(this);
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("%s x %d, %s", this.item(), this.count, this.isLocked() ? "LOCKED" : "UNLOCKED");
    }

    public static boolean isItemUnsafe(class_1799 stack) {
        class_9288 containerContents;
        if (stack.method_7960()) {
            return true;
        }
        if (stack.method_57826(class_9334.field_49622) && (containerContents = (class_9288)stack.method_57825(class_9334.field_49622, (Object)class_9288.field_49334)).method_59712().findAny().isPresent()) {
            return true;
        }
        if (stack.method_57826(ModComponents.CRATE_CONTENTS.get())) {
            if (!CommonConfig.CRATES_CONTAIN_EMPTY_CRATES.get().booleanValue()) {
                return true;
            }
            CrateContents crateContents = (CrateContents)stack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)EMPTY);
            return crateContents.count > 0;
        }
        return false;
    }

    public static class Mutable {
        private class_1799 item = class_1799.field_8037;
        private int count;
        private boolean locked;

        private Mutable() {
        }

        public Mutable(CrateContents contents) {
            this.setValues(contents);
        }

        public Mutable setValues(CrateContents contents) {
            this.setItemType(contents.item().orElse(null));
            this.setCount(contents.count);
            this.setLocked(contents.locked.orElse(false));
            return this;
        }

        public class_1799 getItemType(int count) {
            return this.item.method_46651(count);
        }

        public class_1799 getItemType() {
            return this.getItemType(1);
        }

        public void setItemType(@Nullable class_1799 stack) {
            this.item = stack != null ? stack.method_46651(1) : class_1799.field_8037;
        }

        public boolean isEmptyNoLock() {
            return this.getCount() <= 0 && !this.isLocked();
        }

        protected void updateItemType() {
            if (this.isEmptyNoLock()) {
                this.setItemType(null);
            }
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
            this.updateItemType();
        }

        public void grow(int increment) {
            this.setCount(this.getCount() + increment);
        }

        public void shrink(int decrement) {
            this.setCount(this.getCount() - decrement);
        }

        public void clear() {
            this.setCount(0);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
            this.updateItemType();
        }

        public int getMaxStackSize() {
            return this.getItemType().method_7914();
        }

        protected int getMaxAmountToAdd(class_1799 stack) {
            int stackCount = CrateContents.maxStacks();
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() ? stack.method_7914() * stackCount : Math.max(itemType.method_7914() * stackCount - this.getCount(), 0);
        }

        protected int getMaxAmountToAdd() {
            return this.getMaxAmountToAdd(this.getItemType());
        }

        public boolean canAdd(class_1799 stack) {
            if (CrateContents.isItemUnsafe(stack)) {
                return false;
            }
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() || class_1799.method_31577((class_1799)itemType, (class_1799)stack);
        }

        public int getToAdd(class_1799 stack) {
            if (!this.canAdd(stack)) {
                return 0;
            }
            return Math.min(this.getMaxAmountToAdd(stack), stack.method_7947());
        }

        public void addFromStack(class_1799 stack, int maxToAdd, boolean simulate) {
            if (!this.canAdd(stack)) {
                return;
            }
            this.setItemType(stack);
            int amt = Math.min(maxToAdd, stack.method_7947());
            stack.method_7934(amt);
            if (!simulate) {
                this.grow(amt);
            }
        }

        public void addFromStack(class_1799 stack, int maxToAdd) {
            this.addFromStack(stack, maxToAdd, false);
        }

        public void addFromStack(class_1799 stack, boolean simulate) {
            this.addFromStack(stack, stack.method_7947(), simulate);
        }

        public void addFromStack(class_1799 stack) {
            this.addFromStack(stack, stack.method_7947());
        }

        public class_1799 tryAddStack(class_1799 stack, boolean simulate) {
            class_1799 refStack = stack.method_7972();
            if (!this.canAdd(refStack)) {
                return refStack;
            }
            if (refStack.method_7960()) {
                return class_1799.field_8037;
            }
            this.addFromStack(refStack, simulate);
            return refStack;
        }

        public boolean addAllInventory(class_1657 player) {
            if (this.isEmptyNoLock()) {
                return false;
            }
            int addCount = player.method_31548().method_29280(this::canAdd, this.getMaxAmountToAdd(), (class_1263)player.method_31548());
            if (addCount <= 0) {
                return false;
            }
            this.grow(addCount);
            return true;
        }

        public class_1799 request(int amount) {
            class_1799 itemType = this.getItemType();
            if (itemType.method_7960() || this.getCount() <= 0) {
                return class_1799.field_8037;
            }
            int amt = Math.min(amount, this.getCount());
            this.shrink(amt);
            this.updateItemType();
            return itemType.method_46651(amt);
        }

        public class_1799 requestOne() {
            return this.request(1);
        }

        public class_1799 requestOneStack() {
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() ? class_1799.field_8037 : this.request(itemType.method_7914());
        }

        public CrateContents toImmutable() {
            this.updateItemType();
            class_1799 itemType = this.getItemType();
            return new CrateContents(itemType.method_7960() ? Optional.empty() : Optional.of(ItemRecord.of(itemType)), this.getCount(), this.isLocked() ? Optional.of(true) : Optional.empty());
        }

        public String toString() {
            return this.toImmutable().toString();
        }
    }

    public static class SlottedMutable
    extends Mutable {
        private final class_2371<class_1799> itemStacks = class_2371.method_10213((int)CrateContents.maxStacks(), (Object)class_1799.field_8037);

        public SlottedMutable(CrateContents contents) {
            this.setValues(contents);
        }

        @Override
        public Mutable setValues(CrateContents contents) {
            this.itemStacks.clear();
            return super.setValues(contents);
        }

        @Override
        public int getCount() {
            AtomicInteger count = new AtomicInteger();
            this.itemStacks.forEach(stack -> count.addAndGet(stack.method_7947()));
            return count.get();
        }

        @Override
        public void setCount(int count) {
            class_1799 itemType = this.getItemType();
            if (count == 0 || itemType.method_7960()) {
                this.itemStacks.clear();
            } else {
                int maxStackSize = itemType.method_7914();
                int remaining = count - this.getCount();
                if (remaining > 0) {
                    for (int i = 0; i < this.itemStacks.size() && remaining > 0; ++i) {
                        class_1799 stack = (class_1799)this.itemStacks.get(i);
                        if (class_1799.method_31577((class_1799)stack, (class_1799)itemType)) {
                            int free = maxStackSize - stack.method_7947();
                            if (free <= 0) continue;
                            int toAdd = Math.min(remaining, free);
                            remaining -= toAdd;
                            stack.method_7933(toAdd);
                            continue;
                        }
                        int toAdd = Math.min(remaining, maxStackSize);
                        this.itemStacks.set(i, (Object)itemType.method_46651(toAdd));
                        remaining -= toAdd;
                    }
                } else if (remaining < 0) {
                    remaining = Math.abs(remaining);
                    for (int i = this.itemStacks.size() - 1; i >= 0 && remaining > 0; --i) {
                        class_1799 stack = (class_1799)this.itemStacks.get(i);
                        if (!class_1799.method_31577((class_1799)stack, (class_1799)itemType)) continue;
                        int toRemove = Math.min(stack.method_7947(), remaining);
                        remaining -= toRemove;
                        stack.method_7934(toRemove);
                    }
                }
            }
            super.setCount(count);
        }

        public class_1799 getSlot(int slot) {
            return (class_1799)this.itemStacks.get(slot);
        }

        public boolean setStackInSlot(int slot, @NotNull class_1799 stack) {
            if (!stack.method_7960() && !this.canAdd(stack)) {
                return false;
            }
            this.itemStacks.set(slot, (Object)stack);
            if (!stack.method_7960()) {
                this.setItemType(stack);
            }
            this.updateItemType();
            return true;
        }

        public class_1799 insertIntoSlot(int slot, @NotNull class_1799 stack, boolean simulate) {
            class_1799 refStack = stack.method_7972();
            if (!this.canAdd(stack)) {
                return refStack;
            }
            class_1799 currentItemType = this.getItemType();
            class_1799 itemType = currentItemType.method_7960() ? refStack.method_46651(1) : currentItemType;
            class_1799 slotStack = this.getSlot(slot);
            int freeSpace = itemType.method_7914() - slotStack.method_7947();
            int toAdd = Math.min(refStack.method_7947(), freeSpace);
            if (toAdd <= 0) {
                return refStack;
            }
            if (!simulate) {
                this.setItemType(itemType);
                this.grow(toAdd);
            }
            refStack.method_7934(toAdd);
            return refStack;
        }

        @NotNull
        public class_1799 extractFromSlot(int slot, int amount, boolean simulate) {
            class_1799 slotStack = this.getSlot(slot);
            if (slotStack.method_7960()) {
                return class_1799.field_8037;
            }
            int finalAmt = Math.min(slotStack.method_7947(), amount);
            class_1799 returnStack = slotStack.method_46651(finalAmt);
            if (!simulate) {
                if (finalAmt == slotStack.method_7947()) {
                    this.itemStacks.set(slot, (Object)class_1799.field_8037);
                } else {
                    slotStack.method_7934(finalAmt);
                }
                this.updateItemType();
            }
            return returnStack;
        }

        @NotNull
        public class_1799 removeFromSlot(int slot) {
            class_1799 slotStack = this.getSlot(slot);
            if (slotStack.method_7960()) {
                return class_1799.field_8037;
            }
            this.setStackInSlot(slot, class_1799.field_8037);
            this.updateItemType();
            return slotStack;
        }
    }

    public record ItemRecord(class_6880<class_1792> item, class_9326 components) {
        public static final Codec<ItemRecord> ITEM_CODEC = class_1799.field_24671.xmap(ItemRecord::of, ItemRecord::asItemStack);
        public static final class_9139<class_9129, ItemRecord> ITEM_STREAM_CODEC = class_1799.field_48349.method_56432(ItemRecord::of, ItemRecord::asItemStack);

        public class_1799 asItemStack() {
            return new class_1799(this.item, 1, this.components);
        }

        public static ItemRecord of(class_1799 item) {
            return new ItemRecord((class_6880<class_1792>)item.method_41409(), ((class_9335)item.method_57353()).method_57940());
        }
    }
}

