/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.dynamicpack;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.reg.ModBlockSetVariants;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientDynamicResourcesGenerator
extends DynamicClientResourceProvider {
    private static ClientDynamicResourcesGenerator INSTANCE;

    public static ClientDynamicResourcesGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientDynamicResourcesGenerator();
        }
        return INSTANCE;
    }

    public ClientDynamicResourcesGenerator() {
        super(Condiments.loc("dynamic_resources"), PackGenerationStrategy.CACHED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft");
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept(this::buildAssets);
    }

    private void buildAssets(class_3300 manager, ResourceSink sink) {
        this.addWoodWallAssets(manager, sink);
        this.addWoodAccentAssets(manager, sink);
        this.addPolishedWoodAssets(manager, sink);
    }

    private void addWoodWallAssets(class_3300 manager, ResourceSink sink) {
        StaticResource itemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Condiments.loc("oak_wall")));
        StaticResource blockState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Condiments.loc("oak_wall")));
        StaticResource post = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_post")));
        StaticResource sideTallX = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_tall_x")));
        StaticResource sideTallZ = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_tall_z")));
        StaticResource sideX = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_x")));
        StaticResource sideZ = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_z")));
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> {
            try {
                String id = Utils.getID((class_1792)wall).method_12832();
                class_2960 log = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("log"), t -> !t.contains("top"));
                class_2960 strippedLog = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("stripped_log"), t -> !t.contains("top"));
                Function<String, String> textTransform = s -> s.replace("oak_wall", id).replace("minecraft:block/oak_log", log.toString()).replace("minecraft:block/stripped_oak_log", strippedLog.toString());
                sink.addSimilarJsonResource(manager, itemModel, textTransform);
                sink.addSimilarJsonResource(manager, blockState, "oak_wall", id);
                sink.addSimilarJsonResource(manager, post, textTransform);
                sink.addSimilarJsonResource(manager, sideTallX, textTransform);
                sink.addSimilarJsonResource(manager, sideTallZ, textTransform);
                sink.addSimilarJsonResource(manager, sideX, textTransform);
                sink.addSimilarJsonResource(manager, sideZ, textTransform);
            }
            catch (Exception e) {
                Condiments.LOGGER.error("Failed to create log model for {}", wall, (Object)e);
            }
        });
    }

    private void addWoodAccentAssets(class_3300 manager, ResourceSink sink) {
        StaticResource itemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Condiments.loc("oak_accent")));
        StaticResource blockState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Condiments.loc("oak_accent")));
        StaticResource base = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent")));
        StaticResource inner = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent_inner")));
        StaticResource outer = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent_outer")));
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> {
            String id = Utils.getID((class_1792)accent).method_12832();
            Function<String, String> textTransform = s -> s.replace("oak_accent", id);
            try (TextureImage top = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("stripped_log"), t -> t.contains("top")));
                 TextureImage side = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("stripped_log"), t -> !t.contains("top")));){
                sink.addSimilarJsonResource(manager, itemModel, textTransform);
                sink.addSimilarJsonResource(manager, blockState, textTransform);
                sink.addSimilarJsonResource(manager, base, textTransform);
                sink.addSimilarJsonResource(manager, inner, textTransform);
                sink.addSimilarJsonResource(manager, outer, textTransform);
                class_2960 textureLoc = Condiments.loc("block/" + wood.getTexturePath() + "_accent");
                if (!sink.alreadyHasTextureAtLocation(manager, textureLoc)) {
                    sink.addTexture(textureLoc, TextureImage.of((class_1011)ClientDynamicResourcesGenerator.buildAccentTexture(top.getImage(), side.getImage())));
                }
            }
            catch (Exception e) {
                Condiments.LOGGER.error("Failed to generate wood accent assets for {} : {}", accent, (Object)e);
            }
        });
    }

    private void addPolishedWoodAssets(class_3300 manager, ResourceSink sink) {
        StaticResource logModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Condiments.loc("polished_oak_log")));
        StaticResource woodModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Condiments.loc("polished_oak_wood")));
        StaticResource logState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Condiments.loc("polished_oak_log")));
        StaticResource woodState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Condiments.loc("polished_oak_wood")));
        StaticResource logX = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_x")));
        StaticResource logY = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_y")));
        StaticResource logZ = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_z")));
        StaticResource woodX = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_x")));
        StaticResource woodY = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_y")));
        StaticResource woodZ = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_z")));
        try (TextureImage baseTop = TextureImage.open((class_3300)manager, (class_2960)Condiments.loc("block/polished_oak_log_top"));
             TextureImage baseSide = TextureImage.open((class_3300)manager, (class_2960)Condiments.loc("block/polished_oak_log"));){
            Respriter topRespriter = Respriter.of((TextureImage)baseTop);
            Respriter sideRespriter = Respriter.of((TextureImage)baseSide);
            ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
                block27: {
                    WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
                    String logId = Utils.getID((class_1792)logItem).method_12832();
                    String woodId = Utils.getID((class_1792)woodItem).method_12832();
                    Function<String, String> textTransform = s -> s.replace("polished_oak_log", logId).replace("polished_oak_wood", woodId);
                    try (TextureImage top = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("stripped_log"), t -> t.contains("top")));
                         TextureImage side = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.getBlockOfThis("stripped_log"), t -> !t.contains("top")));){
                        sink.addSimilarJsonResource(manager, logModel, textTransform);
                        sink.addSimilarJsonResource(manager, woodModel, textTransform);
                        sink.addSimilarJsonResource(manager, logState, textTransform);
                        sink.addSimilarJsonResource(manager, woodState, textTransform);
                        sink.addSimilarJsonResource(manager, logX, textTransform);
                        sink.addSimilarJsonResource(manager, logY, textTransform);
                        sink.addSimilarJsonResource(manager, logZ, textTransform);
                        sink.addSimilarJsonResource(manager, woodX, textTransform);
                        sink.addSimilarJsonResource(manager, woodY, textTransform);
                        sink.addSimilarJsonResource(manager, woodZ, textTransform);
                        Palette palette = Palette.merge((Palette[])new Palette[]{Palette.fromImage((TextureImage)top), Palette.fromImage((TextureImage)side)});
                        PaletteColor lightest = palette.getLightest();
                        PaletteColor darkest = palette.getDarkest();
                        while (palette.size() > 6) {
                            palette.reduce();
                        }
                        palette.add(lightest);
                        palette.add(darkest);
                        class_2960 textureLoc = Condiments.loc("block/" + logId);
                        if (sink.alreadyHasTextureAtLocation(manager, textureLoc)) break block27;
                        try (TextureImage newImage = topRespriter.recolor(palette);){
                            sink.addTexture(textureLoc.method_48331("_top"), newImage);
                        }
                        newImage = sideRespriter.recolor(palette);
                        try {
                            sink.addTexture(textureLoc, newImage);
                        }
                        finally {
                            if (newImage != null) {
                                newImage.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        Condiments.LOGGER.error("Failed to generate polished wood assets for {} : {}", logItem, (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Condiments.LOGGER.error("Failed to get base polished wood textures", (Throwable)e);
        }
    }

    @NotNull
    private static class_1011 buildAccentTexture(class_1011 top, class_1011 side) {
        if (side.method_4307() < 16) {
            return side;
        }
        int scale = side.method_4307() / 16;
        class_1011 image = new class_1011(16 * scale, 16 * scale, false);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, side, image, 4, 0, 0, 0, 8, 16, false, false);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, side, image, 4, 0, 8, 0, 8, 16, false, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 5, 5, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 8, 5, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 5, 8, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 8, 8, 3, 3, true, true);
        return image;
    }

    private static void copyScaledRect(int scale, class_1011 from, class_1011 to, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX, boolean mirrorY) {
        from.method_47594(to, xFrom, yFrom * scale, xTo * scale, yTo * scale, width * scale, height * scale, mirrorX, mirrorY);
    }

    protected void addDynamicTranslations(AfterLanguageLoadEvent event) {
        LangBuilder langBuilder = new LangBuilder();
        this.addWoodWallLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        this.addWoodAccentLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        this.addPolishedWoodLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        event.addEntries(langBuilder);
    }

    private void addWoodWallLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.wood_wall");
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> langBuilder.addEntry(wall.method_7711(), String.format(template, entryProvider.apply(wood.getTranslationKey()))));
    }

    private void addWoodAccentLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.wood_accent");
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> langBuilder.addEntry(accent.method_7711(), String.format(template, entryProvider.apply(wood.getTranslationKey()))));
    }

    private void addPolishedWoodLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.polished_wood");
        ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
            WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
            langBuilder.addEntry(logItem.method_7711(), String.format(template, entryProvider.apply(Utils.getID((class_2248)wood.log).method_42093("block"))));
            Optional.ofNullable(wood.getBlockOfThis("wood")).ifPresent(block -> langBuilder.addEntry(woodItem.method_7711(), String.format(template, entryProvider.apply(Utils.getID((class_2248)block).method_42093("block")))));
        });
    }
}

