/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import dev.chililisoup.condiments.reg.ModComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class CrateItem
extends class_1747 {
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public CrateItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties.method_7889(CommonConfig.EMPTY_CRATE_STACK_SIZE.get().intValue()));
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        CrateContents crateContents = (CrateContents)stack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        return crateContents.fillPercent() >= 0.0f;
    }

    public int method_31569(class_1799 stack) {
        CrateContents crateContents = (CrateContents)stack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        float fillPercent = crateContents.fillPercent();
        return Math.min((fillPercent > 0.0f ? 1 : 0) + (int)Math.floor(fillPercent * 12.0f), 13);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        CrateContents crateContents = (CrateContents)stack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        if (crateContents.isLocked()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(crateContents.item().isEmpty() ? "Locked - Unset" : "Locked")).method_27692(class_124.field_1080));
        }
        if (crateContents.item().isEmpty()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1080));
            return;
        }
        if (crateContents.count() <= 0 && !crateContents.isLocked()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1080));
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43470((String)String.format("%d/%d", crateContents.count(), crateContents.capacity())).method_27692(class_124.field_1080));
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 stack) {
        CrateContents crateContents = (CrateContents)stack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        return crateContents.item().flatMap(item -> Optional.of(new CrateTooltip((class_1799)item)));
    }

    public boolean method_31565(class_1799 crateStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (crateStack.method_7947() > 1) {
            return false;
        }
        if (action != class_5536.field_27014) {
            return false;
        }
        CrateContents crateContents = (CrateContents)crateStack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        CrateContents.Mutable mutable = crateContents.toMutable();
        class_1799 insertedStack = slot.method_7677();
        if (insertedStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            slot.method_32756(mutable.requestOneStack());
        } else {
            int amt = mutable.getToAdd(insertedStack);
            if (amt > 0) {
                this.playInsertSound((class_1297)player);
                mutable.addFromStack(insertedStack, amt);
            }
        }
        crateStack.method_57379(ModComponents.CRATE_CONTENTS.get(), (Object)mutable.toImmutable());
        crateStack.method_57379(class_9334.field_50071, (Object)(mutable.getCount() > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
        slot.method_7668();
        player.field_7512.method_7609(slot.field_7871);
        player.field_7498.method_7609(slot.field_7871);
        return true;
    }

    public boolean method_31566(class_1799 crateStack, class_1799 insertedStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (crateStack.method_7947() > 1) {
            return false;
        }
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        CrateContents crateContents = (CrateContents)crateStack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        CrateContents.Mutable mutable = crateContents.toMutable();
        if (insertedStack.method_7960()) {
            class_1799 itemStack = mutable.requestOneStack();
            if (!itemStack.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                access.method_32332(itemStack);
            }
        } else {
            int amt = mutable.getToAdd(insertedStack);
            if (amt > 0) {
                this.playInsertSound((class_1297)player);
                mutable.addFromStack(insertedStack, amt);
            }
        }
        crateStack.method_57379(ModComponents.CRATE_CONTENTS.get(), (Object)mutable.toImmutable());
        crateStack.method_57379(class_9334.field_50071, (Object)(mutable.getCount() > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
        slot.method_7668();
        player.field_7512.method_7609(slot.field_7871);
        player.field_7498.method_7609(slot.field_7871);
        return true;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_14770, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_14667, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private class_1269 placeContents(class_1750 context, class_1747 blockItem, class_1799 itemStack) {
        if (!blockItem.method_7711().method_45382(context.method_8045().method_45162()) || !context.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 blockPlaceContext = blockItem.method_16356(context);
        if (blockPlaceContext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = blockItem.method_7707(blockPlaceContext);
        if (blockState == null || !this.method_7708(blockPlaceContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        class_1657 player = blockPlaceContext.method_8036();
        class_2680 clickedState = level.method_8320(blockPos);
        if (clickedState.method_27852(blockState.method_26204())) {
            clickedState = blockItem.method_18084(blockPos, level, itemStack, clickedState);
            blockItem.method_7710(blockPos, level, player, itemStack, clickedState);
            CrateItem.method_57339((class_1937)level, (class_2338)blockPos, (class_1799)itemStack);
            clickedState.method_26204().method_9567(level, blockPos, clickedState, (class_1309)player, itemStack);
            if (player instanceof class_3222) {
                class_174.field_1191.method_23889((class_3222)player, blockPos, itemStack);
            }
        }
        class_2498 soundType = clickedState.method_26231();
        level.method_8396(player, blockPos, blockItem.method_19260(clickedState), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        level.method_43276((class_6880)class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)clickedState));
        itemStack.method_57008(1, (class_1309)player);
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @NotNull
    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        class_1799 crateStack = context.method_8041();
        if (player == null || player.method_5715() || !(crateStack.method_7909() instanceof CrateItem)) {
            return super.method_7712(context);
        }
        CrateContents crateContents = (CrateContents)crateStack.method_57825(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        if (crateContents.count() <= 0) {
            return super.method_7712(context);
        }
        Optional<CrateContents.ItemRecord> itemRecord = crateContents.itemRecord();
        if (itemRecord.isEmpty()) {
            return super.method_7712(context);
        }
        class_1799 contentsStack = itemRecord.get().asItemStack();
        class_1792 class_17922 = contentsStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_1269 result = this.placeContents(context, blockItem, contentsStack);
            if (!player.method_31549().field_7477 && result.method_36360()) {
                CrateContents.Mutable mutable = crateContents.toMutable();
                mutable.requestOne();
                crateStack.method_57379(ModComponents.CRATE_CONTENTS.get(), (Object)mutable.toImmutable());
                crateStack.method_57379(class_9334.field_50071, (Object)(mutable.getCount() > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
            }
            return result;
        }
        return super.method_7712(context);
    }
}

