/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrazierBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape HIT_SHAPE = Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)9.0, (double)11.5);
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)7.0, (double)11.5);
    private final int fireDamage;

    public BrazierBlock(int fireDamage, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.fireDamage = fireDamage;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof LivingEntity && entity.m_20191_().m_82381_(HIT_SHAPE.m_83215_().m_82338_(pos))) {
            entity.m_6469_(level.m_269111_().m_269387_(), (float)this.fireDamage);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean toLight;
        ItemStack stack = player.m_21120_(hand);
        boolean fireCharge = false;
        if (stack.m_41720_() instanceof FlintAndSteelItem) {
            toLight = true;
        } else if (stack.m_41720_() instanceof FireChargeItem) {
            toLight = true;
            fireCharge = true;
        } else if (stack.m_41720_() instanceof ShovelItem) {
            toLight = false;
        } else {
            return InteractionResult.PASS;
        }
        if ((Boolean)state.m_61143_((Property)LIT) == toLight || toLight && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (toLight) {
            level.m_5594_(player, pos, fireCharge ? SoundEvents.f_11874_ : SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        } else if (!level.f_46443_) {
            level.m_5898_(null, 1009, pos, 0);
        } else {
            BrazierBlock.makeDowseParticles((LevelAccessor)level, pos);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(toLight)), 11);
        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        if (fireCharge) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        } else {
            stack.m_41622_(1, (LivingEntity)player, eventPlayer -> eventPlayer.m_21190_(hand));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || fluidState.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                BrazierBlock.makeDowseParticles(level, pos);
            }
        }
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        level.m_142346_(null, GameEvent.f_157792_, pos);
        level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
        return true;
    }

    public static void makeDowseParticles(LevelAccessor level, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            BrazierBlock.makeParticles(level, pos, level.m_213780_());
        }
    }

    public static void makeParticles(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + randomSource.m_188500_() / 6.0 * (double)(randomSource.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + randomSource.m_188500_() / 6.0 * (double)(randomSource.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        if (random.m_188503_(24) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
        }
        BrazierBlock.makeParticles((LevelAccessor)level, pos, random);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return HIT_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelAccessor = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIT});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }
}

