/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.item.CrateItemHandler;
import dev.chililisoup.condiments.reg.ModBlockEntities;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CrateBlockEntity
extends BlockEntity
implements Container,
Nameable {
    public static final String COUNT_KEY = "Count";
    private final CrateContents.SlottedMutable contents = new CrateContents().toSlottedMutable();
    @Nullable
    private Component name;
    LazyOptional<CrateItemHandler> handler = LazyOptional.of(() -> new CrateItemHandler(this));

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public int m_6643_() {
        return CrateContents.maxStacks();
    }

    public CrateBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.CRATE_BE_TYPE.get(), pos, blockState);
    }

    public CrateContents getContents() {
        return this.contents.toImmutable();
    }

    public void loadCrateContents(CrateContents crateContents) {
        this.contents.setValues(crateContents);
    }

    public ItemStack getItemType() {
        return this.contents.getItemType();
    }

    public int getCount() {
        return this.contents.getCount();
    }

    public boolean isLocked() {
        return this.contents.isLocked();
    }

    private CompoundTag prepareUpdateTag(CompoundTag tag) {
        CompoundTag storageTag = new CompoundTag();
        ItemStack itemType = this.getItemType();
        if (!itemType.m_41619_()) {
            itemType.m_41739_(storageTag);
        }
        storageTag.m_128376_(COUNT_KEY, (short)this.getCount());
        tag.m_128365_("CrateItems", (Tag)storageTag);
        tag.m_128379_("CrateLocked", this.isLocked());
        tag.m_128379_("CrateAutoPickup", this.contents.isAutoPickup());
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.prepareUpdateTag(tag);
    }

    private void loadStorage(CompoundTag tag) {
        this.contents.setLocked(tag.m_128471_("CrateLocked"));
        this.contents.setAutoPickup(tag.m_128471_("CrateAutoPickup"));
        short count = tag.m_128469_("CrateItems").m_128448_(COUNT_KEY);
        CompoundTag storageTag = tag.m_128469_("CrateItems");
        if (storageTag.m_128441_("id")) {
            storageTag.m_128405_(COUNT_KEY, 1);
        } else {
            storageTag.m_128473_(COUNT_KEY);
        }
        this.contents.setItemType(storageTag.m_128456_() ? null : ItemStack.m_41712_((CompoundTag)storageTag));
        this.contents.setCount(count);
        this.name = tag.m_128425_("CustomName", 8) ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : null;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadStorage(tag);
    }

    private void updateClient() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return this.canAddItem(stack);
    }

    public boolean canAddItem(ItemStack stack) {
        return this.contents.canAdd(stack);
    }

    public int m_18947_(Item item) {
        return this.getItemType().m_41720_().equals(item) ? this.getCount() : 0;
    }

    public boolean m_216874_(Predicate<ItemStack> predicate) {
        return predicate.test(this.getItemType());
    }

    public boolean m_7983_() {
        return this.contents.isEmptyNoLock();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.contents.getSlot(slot);
    }

    public int m_6893_() {
        return this.contents.getMaxStackSize();
    }

    public ItemStack[] getSlottedStacks() {
        return this.contents.getSlottedStacks();
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack item = this.contents.extractFromSlot(slot, amount, false);
        if (item.m_41619_()) {
            return item;
        }
        this.m_6596_();
        return item;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.contents.removeFromSlot(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (!this.contents.setStackInSlot(slot, stack)) {
            return;
        }
        this.m_6596_();
    }

    private void addAllInventory(Player player) {
        if (!this.contents.addAllInventory(player)) {
            return;
        }
        this.m_6596_();
        this.playSound(this.m_58900_(), SoundEvents.f_12013_);
    }

    public ItemStack tryAddStack(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        ItemStack item = this.contents.tryAddStack(stack, simulate);
        if (ItemStack.m_150942_((ItemStack)item, (ItemStack)stack) && item.m_41613_() == stack.m_41613_()) {
            return item;
        }
        this.m_6596_();
        this.playSound(this.m_58900_(), SoundEvents.f_12013_);
        return item;
    }

    public ItemStack tryAddStack(ItemStack stack) {
        return this.tryAddStack(stack, false);
    }

    public ItemStack tryAddStack(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            this.addAllInventory(player);
            return ItemStack.f_41583_;
        }
        return this.tryAddStack(stack);
    }

    public ItemStack insertIntoSlot(int slot, ItemStack stack, boolean simulate) {
        ItemStack result = this.contents.insertIntoSlot(slot, stack, simulate);
        this.m_6596_();
        return result;
    }

    public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
        ItemStack result = this.contents.extractFromSlot(slot, amount, simulate);
        this.m_6596_();
        return result;
    }

    private ItemStack finishRequest(ItemStack stack) {
        this.m_6596_();
        this.playSound(this.m_58900_(), SoundEvents.f_12016_);
        return stack;
    }

    public ItemStack request(int amount) {
        return this.finishRequest(this.contents.request(amount));
    }

    public ItemStack requestOne() {
        return this.finishRequest(this.contents.requestOne());
    }

    public ItemStack requestOneStack() {
        return this.finishRequest(this.contents.requestOneStack());
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.contents.clear();
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        this.updateClient();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.prepareUpdateTag(new CompoundTag());
    }

    void playSound(BlockState state, SoundEvent sound) {
        if (this.f_58857_ == null) {
            return;
        }
        Vec3i front = ((FrontAndTop)state.m_61143_((Property)BlockStateProperties.f_61375_)).m_122625_().m_122436_();
        Vec3 pos = this.f_58858_.m_252807_().m_82520_((double)front.m_123341_() / 2.0, (double)front.m_123342_() / 2.0, (double)front.m_123343_() / 2.0);
        this.f_58857_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.condiments.crate");
    }

    @NotNull
    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }
}

