/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.config.CommonConfig;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class CrateRenderer
implements BlockEntityRenderer<CrateBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final Font font;

    public CrateRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
        this.font = context.m_173586_();
    }

    public int m_142163_() {
        return 32;
    }

    public void render(CrateBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        Entity player = Minecraft.m_91087_().m_91288_();
        if (player == null) {
            return;
        }
        ItemStack item = blockEntity.getItemType();
        if (item.m_41619_() && !blockEntity.m_8077_()) {
            return;
        }
        FrontAndTop fat = (FrontAndTop)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61375_);
        Vec3i norm = fat.m_122625_().m_122436_();
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockEntity.m_58899_().m_5484_(fat.m_122625_(), 1));
        this.renderText(item, blockEntity, poseStack, buffer, fat, norm, light);
        if (!item.m_41619_()) {
            CrateRenderer.renderItem(level, item, poseStack, buffer, light, packedOverlay, fat, norm, this.itemRenderer);
        }
    }

    private void renderText(ItemStack item, CrateBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, FrontAndTop fat, Vec3i norm, int light) {
        Component customName;
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        if (hitResult2.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (!hitResult2.m_82425_().equals((Object)blockEntity.m_58899_())) {
            return;
        }
        if (hitResult2.m_82434_() != fat.m_122625_()) {
            return;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult2, fat.m_122625_());
        if (hitPos.isEmpty()) {
            return;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return;
        }
        String text = String.format("%d / %d", blockEntity.getCount(), item.m_41741_() * CommonConfig.CRATE_MAX_CONTAINED_STACKS.get());
        poseStack.m_85836_();
        poseStack.m_85837_((double)norm.m_123341_() / 2.0 + 0.5, (double)norm.m_123342_() / 2.0 + 0.5, (double)norm.m_123343_() / 2.0 + 0.5);
        poseStack.m_252781_(fat.m_122625_().m_253075_());
        poseStack.m_252781_(Direction.NORTH.m_253075_());
        if (fat.m_122625_().m_122434_() == Direction.Axis.Y) {
            int dir = fat.m_122625_().m_122421_().m_122540_();
            int rot = (dir + 1) * 90;
            poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, (float)dir, fat.m_122629_().m_122435_() + (float)rot));
        }
        poseStack.m_85841_(-0.01f, -0.01f, -0.01f);
        if (!item.m_41619_()) {
            this.font.m_271703_(text, (float)(-this.font.m_92895_(text) / 2), -48.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        }
        if ((customName = blockEntity.m_7770_()) != null) {
            List list = this.font.m_92923_((FormattedText)customName, 100);
            FormattedCharSequence clampedWidthName = list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
            this.font.m_272191_(clampedWidthName, (float)(-this.font.m_92724_(clampedWidthName) / 2), 40.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        }
        poseStack.m_85849_();
    }

    public static void renderItem(@Nullable Level level, ItemStack item, PoseStack poseStack, MultiBufferSource buffer, int light, int packedOverlay, FrontAndTop fat, Vec3i norm, ItemRenderer itemRenderer) {
        boolean is3d = itemRenderer.m_174264_(item, level, null, 0).m_7539_();
        double offset = is3d ? 2.3 : 2.6;
        poseStack.m_85836_();
        poseStack.m_85837_((double)norm.m_123341_() / offset + 0.5, (double)norm.m_123342_() / offset + 0.5, (double)norm.m_123343_() / offset + 0.5);
        poseStack.m_252781_(fat.m_122625_().m_122424_().m_253075_());
        poseStack.m_252781_(Direction.NORTH.m_253075_());
        if (fat.m_122625_().m_122434_() == Direction.Axis.Y) {
            int dir = fat.m_122625_().m_122421_().m_122540_();
            int rot = (dir + 1) * 90;
            poseStack.m_272245_(new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), 0.0f, 0.0f, 0.0f);
            poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, (float)(-dir), fat.m_122629_().m_122435_() + (float)rot));
        }
        if (is3d) {
            poseStack.m_85850_().m_252922_().scale(0.7f, 0.7f, 0.005f);
        } else {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        }
        itemRenderer.m_269128_(item, ItemDisplayContext.GUI, light, packedOverlay, poseStack, buffer, level, 0);
        poseStack.m_85849_();
    }
}

