/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.config;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;

public class CommonConfig {
    public static final Supplier<Integer> CRATE_MAX_CONTAINED_STACKS;
    public static final Supplier<Integer> EMPTY_CRATE_STACK_SIZE;
    public static final Supplier<Boolean> CRATES_CONTAIN_EMPTY_CRATES;
    public static final Supplier<Boolean> TINTED_GLASS_TERMINATES_BEACONS;
    public static final Supplier<Double> ANALOG_RAIL_MAX_SPEED;
    public static final Supplier<Boolean> COPPER_FIRE;
    public static final ConfigSpec CONFIG_SPEC;

    public static void init() {
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((String)"condiments", (ConfigType)ConfigType.COMMON);
        builder.push("crates");
        CRATE_MAX_CONTAINED_STACKS = builder.comment("How many full stacks of an item each crate can hold").define("crate_max_contained_stacks", 64, 1, 256);
        EMPTY_CRATE_STACK_SIZE = builder.comment("Stack size of empty crates").gameRestart().define("empty_crate_stack_size", 64, 1, 64);
        CRATES_CONTAIN_EMPTY_CRATES = builder.comment("If crates are allowed to contain empty crates").define("crates_contain_empty_crates", true);
        builder.pop();
        builder.push("misc");
        TINTED_GLASS_TERMINATES_BEACONS = builder.comment("If beacon beams stop at tinted glass (and exist up to that point)").define("tinted_glass_terminates_beacons", true);
        ANALOG_RAIL_MAX_SPEED = builder.comment("Analog rail max speed (blocks per tick, before natural slowdown)").define("analog_rail_max_speed", 0.6, 0.1, 16.0);
        COPPER_FIRE = builder.comment("If fire on copper blocks should turn into a green copper fire").define("copper_fire", true);
        builder.pop();
        builder.setSynced();
        CONFIG_SPEC = builder.buildAndRegister();
        CONFIG_SPEC.loadFromFile();
    }
}

