/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.client.renderer.CrateItemRenderer;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import dev.chililisoup.condiments.mixin.BlockItemAccess;
import dev.chililisoup.condiments.mixin.UseOnContextAccess;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CrateItem
extends BlockItem
implements ICustomItemRendererProvider {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public CrateItem(Block block, Item.Properties properties) {
        super(block, properties.m_41487_(CommonConfig.EMPTY_CRATE_STACK_SIZE.get().intValue()));
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.fillPercent() >= 0.0f;
    }

    public int m_142158_(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        float fillPercent = crateContents.fillPercent();
        return Math.min((fillPercent > 0.0f ? 1 : 0) + (int)Math.floor(fillPercent * 12.0f), 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        if (crateContents.isLocked()) {
            tooltipComponents.add((Component)Component.m_237115_((String)(crateContents.item().isEmpty() ? "item.condiments.crate.tooltip.locked_unset" : "item.condiments.crate.tooltip.locked")).m_130940_(ChatFormatting.GRAY));
        }
        if (crateContents.autoPickup().booleanValue()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.condiments.crate.tooltip.auto_pickup").m_130940_(ChatFormatting.GRAY));
        }
        if (crateContents.item().isEmpty() || crateContents.count() <= 0 && !crateContents.isLocked()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.condiments.crate.tooltip.empty").m_130940_(ChatFormatting.GRAY));
            return;
        }
        tooltipComponents.add((Component)Component.m_237113_((String)String.format("%d/%d", crateContents.count(), crateContents.capacity())).m_130940_(ChatFormatting.GRAY));
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.item().flatMap(item -> Optional.of(new CrateTooltip((ItemStack)item)));
    }

    private static void updateInventories(ItemStack slotStack, Slot slot, Player player) {
        MultiPlayerGameMode gameMode;
        slot.m_6654_();
        player.f_36096_.m_6199_(slot.f_40218_);
        player.f_36095_.m_6199_(slot.f_40218_);
        if (PlatHelper.getPhysicalSide().isClient() && Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen && (gameMode = Minecraft.m_91087_().f_91072_) != null) {
            gameMode.m_105241_(slotStack, slot.f_40219_);
        }
    }

    public boolean m_142207_(ItemStack crateStack, Slot slot, ClickAction action, Player player) {
        if (crateStack.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        ItemStack insertedStack = slot.m_7993_();
        if (insertedStack.m_41619_()) {
            ItemStack itemType = mutable.getItemType();
            if (itemType.m_41619_() || !slot.m_5857_(itemType)) {
                return false;
            }
            this.playRemoveOneSound((Entity)player);
            slot.m_150659_(mutable.requestOneStack());
        } else if (mutable.addFromSlot(slot, player) > 0) {
            this.playInsertSound((Entity)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(insertedStack, slot, player);
        return true;
    }

    public boolean m_142305_(ItemStack crateStack, ItemStack insertedStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (crateStack.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        if (insertedStack.m_41619_()) {
            ItemStack itemStack = mutable.requestOneStack();
            if (!itemStack.m_41619_()) {
                this.playRemoveOneSound((Entity)player);
                access.m_142104_(itemStack);
            }
        } else if (mutable.addFromStack(insertedStack) > 0) {
            this.playInsertSound((Entity)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(crateStack, slot, player);
        return true;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12016_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12013_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private InteractionResult placeContents(BlockPlaceContext context, BlockItem blockItem, ItemStack itemStack) {
        if (!blockItem.m_40614_().m_245993_(context.m_43725_().m_246046_()) || !context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = blockItem.m_7732_(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = ((BlockItemAccess)blockItem).condiments$getPlacementState(blockPlaceContext);
        if (blockState == null || !this.m_7429_(blockPlaceContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Player player = blockPlaceContext.m_43723_();
        BlockState clickedState = level.m_8055_(blockPos);
        if (clickedState.m_60713_(blockState.m_60734_())) {
            clickedState = ((BlockItemAccess)blockItem).condiments$updateBlockStateFromTag(blockPos, level, itemStack, clickedState);
            ((BlockItemAccess)blockItem).condiments$updateCustomBlockEntityTag(blockPos, level, player, itemStack, clickedState);
            clickedState.m_60734_().m_6402_(level, blockPos, clickedState, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_285767_(serverPlayer, blockPos, itemStack);
            }
        }
        SoundType soundType = clickedState.m_60827_();
        level.m_5594_(player, blockPos, ((BlockItemAccess)blockItem).condiments$getPlaceSound(clickedState), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)clickedState));
        if (player == null || !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @NotNull
    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        ItemStack crateStack = context.m_43722_();
        if (player == null || player.m_6144_() || !(crateStack.m_41720_() instanceof CrateItem)) {
            return super.m_40576_(context);
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        if (crateContents.count() <= 0) {
            return super.m_40576_(context);
        }
        CrateContents.ItemRecord itemRecord = crateContents.itemRecord();
        if (itemRecord == null) {
            return super.m_40576_(context);
        }
        ItemStack contentsStack = itemRecord.asItemStack();
        Item item = contentsStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockPlaceContext contentsContext = new BlockPlaceContext(player, context.m_43724_(), contentsStack, ((UseOnContextAccess)context).condiments$getHitResult());
            InteractionResult result = this.placeContents(contentsContext, blockItem, contentsStack);
            if (!player.m_150110_().f_35937_ && result.m_146666_()) {
                CrateContents.Mutable mutable = crateContents.toMutable();
                mutable.requestOne();
                mutable.toImmutable().updateCrateItem(crateStack);
            }
            return result;
        }
        return super.m_40576_(context);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return CrateItemRenderer::new;
    }
}

