/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.chililisoup.condiments.config.CommonConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CrateContents(@Nullable ItemRecord itemRecord, int count, Boolean locked, Boolean autoPickup) {
    public static final CrateContents EMPTY = new CrateContents();
    public static final Codec<CrateContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRecord.ITEM_CODEC.optionalFieldOf("item").forGetter(CrateContents::itemRecordOptional), (App)Codec.INT.fieldOf("Count").forGetter(CrateContents::count), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(CrateContents::lockedOptional), (App)Codec.BOOL.optionalFieldOf("autoPickup").forGetter(CrateContents::autoPickupOptional)).apply((Applicative)instance, CrateContents::new));

    public CrateContents(@Nullable ItemRecord itemRecord, int count) {
        this(itemRecord, count, false, false);
    }

    public CrateContents() {
        this(null, 0);
    }

    private CrateContents(Optional<ItemRecord> itemRecord, int count, Optional<Boolean> locked, Optional<Boolean> autoPickup) {
        this(itemRecord.orElse(null), count, locked.orElse(false), autoPickup.orElse(false));
    }

    private Optional<ItemRecord> itemRecordOptional() {
        return Optional.ofNullable(this.itemRecord);
    }

    private Optional<Boolean> lockedOptional() {
        return this.locked != false ? Optional.of(true) : Optional.empty();
    }

    private Optional<Boolean> autoPickupOptional() {
        return this.autoPickup != false ? Optional.of(true) : Optional.empty();
    }

    public static CrateContents fromCrateItem(class_1799 crateItem) {
        class_2487 compoundTag = crateItem.method_7941("BlockEntityTag");
        if (compoundTag == null) {
            return EMPTY;
        }
        boolean locked = compoundTag.method_10577("CrateLocked");
        boolean autoPickup = compoundTag.method_10577("CrateAutoPickup");
        short count = 0;
        ItemRecord record = null;
        class_2487 storageTag = compoundTag.method_10562("CrateItems").method_10553();
        if (!storageTag.method_33133()) {
            count = storageTag.method_10568("Count");
            storageTag.method_10575("Count", (short)1);
            class_1799 item = class_1799.method_7915((class_2487)storageTag);
            if (!item.method_7960()) {
                record = ItemRecord.of(item);
            }
        }
        return new CrateContents(record, (int)count, locked, autoPickup);
    }

    public void updateCrateItem(class_1799 crateItem) {
        class_2487 compoundTag = crateItem.method_7911("BlockEntityTag");
        if (this.autoPickup.booleanValue()) {
            compoundTag.method_10556("CrateAutoPickup", true);
        } else {
            compoundTag.method_10551("CrateAutoPickup");
        }
        Optional<class_1799> itemType = this.item();
        if (itemType.isEmpty() && !this.isLocked()) {
            compoundTag.method_10551("CrateItems");
            compoundTag.method_10551("CrateLocked");
            if (compoundTag.method_33133()) {
                crateItem.method_7983("BlockEntityTag");
            }
            return;
        }
        compoundTag.method_10556("CrateLocked", this.isLocked());
        if (itemType.isPresent()) {
            class_2487 storageTag = itemType.get().method_7953(new class_2487());
            storageTag.method_10575("Count", (short)this.count);
            compoundTag.method_10566("CrateItems", (class_2520)storageTag);
        }
    }

    public Optional<class_1799> item() {
        return this.itemRecordOptional().flatMap(itemRecord -> Optional.of(itemRecord.asItemStack()));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static int maxStacks() {
        return CommonConfig.CRATE_MAX_CONTAINED_STACKS.get();
    }

    public int capacity() {
        int stackCount = CrateContents.maxStacks();
        return this.item().map(stack -> stack.method_7914() * stackCount).orElse(0);
    }

    public float fillPercent() {
        if (this.count <= 0 && !this.isLocked()) {
            return -1.0f;
        }
        if (this.item().isEmpty()) {
            return -1.0f;
        }
        return (float)this.count / (float)this.capacity();
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public SlottedMutable toSlottedMutable() {
        return new SlottedMutable(this);
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("%s x %d, %s", this.item(), this.count, this.isLocked() ? "LOCKED" : "UNLOCKED");
    }

    public static boolean isItemUnsafe(class_1799 stack) {
        class_2499 containerContents;
        if (stack.method_7960()) {
            return true;
        }
        class_2487 compoundTag = stack.method_7941("BlockEntityTag");
        if (compoundTag == null) {
            return false;
        }
        if (compoundTag.method_10573("Items", 9) && !(containerContents = compoundTag.method_10554("Items", 10)).isEmpty()) {
            return true;
        }
        if (compoundTag.method_10545("CrateItems")) {
            if (!CommonConfig.CRATES_CONTAIN_EMPTY_CRATES.get().booleanValue()) {
                return true;
            }
            return compoundTag.method_10562("CrateItems").method_10568("Count") > 0;
        }
        return false;
    }

    public record ItemRecord(class_6880<class_1792> item, Optional<class_2487> components) {
        public static final Codec<ItemRecord> ITEM_CODEC = class_1799.field_24671.xmap(ItemRecord::of, ItemRecord::asItemStack);

        public class_1799 asItemStack() {
            class_1799 stack = new class_1799(this.item, 1);
            this.components.ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
            return stack;
        }

        public static ItemRecord of(class_1799 item) {
            return new ItemRecord((class_6880<class_1792>)item.method_41409(), Optional.ofNullable(item.method_7969()));
        }
    }

    public static class Mutable {
        private class_1799 item = class_1799.field_8037;
        private int count;
        private boolean locked;
        private boolean autoPickup;

        private Mutable() {
        }

        public Mutable(CrateContents contents) {
            this.setValues(contents);
        }

        public Mutable setValues(CrateContents contents) {
            this.setLocked(contents.locked);
            this.setItemType(contents.item().orElse(null));
            this.setCount(contents.count);
            this.setAutoPickup(contents.autoPickup);
            return this;
        }

        public class_1799 getItemType(int count) {
            return this.item.method_46651(count);
        }

        public class_1799 getItemType() {
            return this.getItemType(1);
        }

        public void setItemType(@Nullable class_1799 stack) {
            this.item = stack != null ? stack.method_46651(1) : class_1799.field_8037;
        }

        public boolean isEmptyNoLock() {
            return this.getCount() <= 0 && !this.isLocked();
        }

        protected void updateItemType() {
            if (this.isEmptyNoLock()) {
                this.setItemType(null);
            }
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
            this.updateItemType();
        }

        public void grow(int increment) {
            this.setCount(this.getCount() + increment);
        }

        public void shrink(int decrement) {
            this.setCount(this.getCount() - decrement);
        }

        public void clear() {
            this.setCount(0);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
            this.updateItemType();
        }

        public boolean isAutoPickup() {
            return this.autoPickup;
        }

        public void setAutoPickup(boolean autoPickup) {
            this.autoPickup = autoPickup;
        }

        public int getMaxStackSize() {
            return this.getItemType().method_7914();
        }

        protected int getMaxAmountToAdd(class_1799 stack) {
            int stackCount = CrateContents.maxStacks();
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() ? stack.method_7914() * stackCount : Math.max(itemType.method_7914() * stackCount - this.getCount(), 0);
        }

        protected int getMaxAmountToAdd() {
            return this.getMaxAmountToAdd(this.getItemType());
        }

        public boolean canAdd(class_1799 stack) {
            if (CrateContents.isItemUnsafe(stack)) {
                return false;
            }
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() || class_1799.method_31577((class_1799)itemType, (class_1799)stack);
        }

        public int getToAdd(class_1799 stack) {
            if (!this.canAdd(stack)) {
                return 0;
            }
            return Math.min(this.getMaxAmountToAdd(stack), stack.method_7947());
        }

        public void addFromStack(class_1799 stack, int maxToAdd, boolean simulate) {
            if (!this.canAdd(stack)) {
                return;
            }
            this.setItemType(stack);
            int amt = Math.min(maxToAdd, stack.method_7947());
            stack.method_7934(amt);
            if (!simulate) {
                this.grow(amt);
            }
        }

        public void addFromStack(class_1799 stack, int maxToAdd) {
            this.addFromStack(stack, maxToAdd, false);
        }

        public void addFromStack(class_1799 stack, boolean simulate) {
            this.addFromStack(stack, stack.method_7947(), simulate);
        }

        public void addFromStack(class_1799 stack) {
            this.addFromStack(stack, stack.method_7947());
        }

        public class_1799 tryAddStack(class_1799 stack, boolean simulate) {
            class_1799 refStack = stack.method_7972();
            if (!this.canAdd(refStack)) {
                return refStack;
            }
            if (refStack.method_7960()) {
                return class_1799.field_8037;
            }
            this.addFromStack(refStack, simulate);
            return refStack;
        }

        public boolean addAllInventory(class_1657 player) {
            if (this.isEmptyNoLock()) {
                return false;
            }
            int addCount = player.method_31548().method_29280(this::canAdd, this.getMaxAmountToAdd(), (class_1263)player.method_31548());
            if (addCount <= 0) {
                return false;
            }
            this.grow(addCount);
            return true;
        }

        public class_1799 request(int amount) {
            class_1799 itemType = this.getItemType();
            if (itemType.method_7960() || this.getCount() <= 0) {
                return class_1799.field_8037;
            }
            int amt = Math.min(amount, this.getCount());
            this.shrink(amt);
            this.updateItemType();
            return itemType.method_46651(amt);
        }

        public class_1799 requestOne() {
            return this.request(1);
        }

        public class_1799 requestOneStack() {
            class_1799 itemType = this.getItemType();
            return itemType.method_7960() ? class_1799.field_8037 : this.request(itemType.method_7914());
        }

        public CrateContents toImmutable() {
            this.updateItemType();
            class_1799 itemType = this.getItemType();
            return new CrateContents(itemType.method_7960() ? null : ItemRecord.of(itemType), this.getCount(), this.isLocked(), this.isAutoPickup());
        }

        public String toString() {
            return this.toImmutable().toString();
        }
    }

    public static class SlottedMutable
    extends Mutable {
        private final class_2371<class_1799> itemStacks = class_2371.method_10213((int)CrateContents.maxStacks(), (Object)class_1799.field_8037);

        public SlottedMutable(CrateContents contents) {
            this.setValues(contents);
        }

        @Override
        public Mutable setValues(CrateContents contents) {
            this.itemStacks.clear();
            return super.setValues(contents);
        }

        @Override
        public int getCount() {
            AtomicInteger count = new AtomicInteger();
            this.itemStacks.forEach(stack -> count.addAndGet(stack.method_7947()));
            return count.get();
        }

        @Override
        public void setCount(int count) {
            class_1799 itemType = this.getItemType();
            if (count == 0 || itemType.method_7960()) {
                this.itemStacks.clear();
            } else {
                int maxStackSize = itemType.method_7914();
                int remaining = count - this.getCount();
                if (remaining > 0) {
                    for (int i = 0; i < this.itemStacks.size() && remaining > 0; ++i) {
                        class_1799 stack = (class_1799)this.itemStacks.get(i);
                        if (class_1799.method_31577((class_1799)stack, (class_1799)itemType)) {
                            int free = maxStackSize - stack.method_7947();
                            if (free <= 0) continue;
                            int toAdd = Math.min(remaining, free);
                            remaining -= toAdd;
                            stack.method_7933(toAdd);
                            continue;
                        }
                        int toAdd = Math.min(remaining, maxStackSize);
                        this.itemStacks.set(i, (Object)itemType.method_46651(toAdd));
                        remaining -= toAdd;
                    }
                } else if (remaining < 0) {
                    remaining = Math.abs(remaining);
                    for (int i = this.itemStacks.size() - 1; i >= 0 && remaining > 0; --i) {
                        class_1799 stack = (class_1799)this.itemStacks.get(i);
                        if (!class_1799.method_31577((class_1799)stack, (class_1799)itemType)) continue;
                        int toRemove = Math.min(stack.method_7947(), remaining);
                        remaining -= toRemove;
                        stack.method_7934(toRemove);
                    }
                }
            }
            super.setCount(count);
        }

        public class_1799 getSlot(int slot) {
            return (class_1799)this.itemStacks.get(slot);
        }

        public class_1799[] getSlottedStacks() {
            return (class_1799[])this.itemStacks.stream().map(class_1799::method_7972).toArray(class_1799[]::new);
        }

        public boolean setStackInSlot(int slot, @NotNull class_1799 stack) {
            if (!stack.method_7960() && !this.canAdd(stack)) {
                return false;
            }
            this.itemStacks.set(slot, (Object)stack);
            if (!stack.method_7960()) {
                this.setItemType(stack);
            }
            this.updateItemType();
            return true;
        }

        public class_1799 insertIntoSlot(int slot, @NotNull class_1799 stack, boolean simulate) {
            class_1799 refStack = stack.method_7972();
            if (!this.canAdd(stack)) {
                return refStack;
            }
            class_1799 currentItemType = this.getItemType();
            class_1799 itemType = currentItemType.method_7960() ? refStack.method_46651(1) : currentItemType;
            class_1799 slotStack = this.getSlot(slot);
            int freeSpace = itemType.method_7914() - slotStack.method_7947();
            int toAdd = Math.min(refStack.method_7947(), freeSpace);
            if (toAdd <= 0) {
                return refStack;
            }
            if (!simulate) {
                this.setItemType(itemType);
                this.grow(toAdd);
            }
            refStack.method_7934(toAdd);
            return refStack;
        }

        @NotNull
        public class_1799 extractFromSlot(int slot, int amount, boolean simulate) {
            class_1799 slotStack = this.getSlot(slot);
            if (slotStack.method_7960()) {
                return class_1799.field_8037;
            }
            int finalAmt = Math.min(slotStack.method_7947(), amount);
            class_1799 returnStack = slotStack.method_46651(finalAmt);
            if (!simulate) {
                if (finalAmt == slotStack.method_7947()) {
                    this.itemStacks.set(slot, (Object)class_1799.field_8037);
                } else {
                    slotStack.method_7934(finalAmt);
                }
                this.updateItemType();
            }
            return returnStack;
        }

        @NotNull
        public class_1799 removeFromSlot(int slot) {
            class_1799 slotStack = this.getSlot(slot);
            if (slotStack.method_7960()) {
                return class_1799.field_8037;
            }
            this.setStackInSlot(slot, class_1799.field_8037);
            this.updateItemType();
            return slotStack;
        }
    }
}

