/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block.entity;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.item.CrateItemHandler;
import dev.chililisoup.condiments.reg.ModBlockEntities;
import dev.chililisoup.condiments.reg.ModComponents;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CrateBlockEntity
extends BlockEntity
implements Container,
Nameable {
    public static final String COUNT_KEY = "count";
    private final CrateContents.SlottedMutable contents = new CrateContents().toSlottedMutable();
    @Nullable
    private Component name;
    public final CrateItemHandler handler = new CrateItemHandler(this);

    public int getContainerSize() {
        return CrateContents.maxStacks();
    }

    public CrateBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.CRATE_BE_TYPE.get(), pos, blockState);
    }

    public CrateContents getContents() {
        return this.contents.toImmutable();
    }

    public void loadCrateContents(CrateContents crateContents) {
        this.contents.setValues(crateContents);
    }

    public ItemStack getItemType() {
        return this.contents.getItemType();
    }

    public int getCount() {
        return this.contents.getCount();
    }

    public boolean isLocked() {
        return this.contents.isLocked();
    }

    private CompoundTag prepareUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag storageTag = (CompoundTag)this.getItemType().saveOptional(registries);
        storageTag.putShort(COUNT_KEY, (short)this.getCount());
        tag.put("CrateItems", (Tag)storageTag);
        tag.putBoolean("CrateLocked", this.isLocked());
        tag.putBoolean("CrateAutoPickup", this.contents.isAutoPickup());
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
        return tag;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.prepareUpdateTag(tag, registries);
    }

    private void loadStorage(CompoundTag tag, HolderLookup.Provider registries) {
        this.contents.setLocked(tag.getBoolean("CrateLocked"));
        this.contents.setAutoPickup(tag.getBoolean("CrateAutoPickup"));
        short count = tag.getCompound("CrateItems").getShort(COUNT_KEY);
        CompoundTag storageTag = tag.getCompound("CrateItems");
        if (storageTag.contains("id")) {
            storageTag.putInt(COUNT_KEY, 1);
        } else {
            storageTag.remove(COUNT_KEY);
        }
        this.contents.setItemType(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)storageTag));
        this.contents.setCount(count);
        this.name = tag.contains("CustomName", 8) ? CrateBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries) : null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadStorage(tag, registries);
    }

    private void updateClient() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.canAddItem(stack);
    }

    public boolean canAddItem(ItemStack stack) {
        return this.contents.canAdd(stack);
    }

    public int countItem(Item item) {
        return this.getItemType().getItem().equals(item) ? this.getCount() : 0;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return predicate.test(this.getItemType());
    }

    public boolean isEmpty() {
        return this.contents.isEmptyNoLock();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.contents.getSlot(slot);
    }

    public int getMaxStackSize() {
        return this.contents.getMaxStackSize();
    }

    public ItemStack[] getSlottedStacks() {
        return this.contents.getSlottedStacks();
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack item = this.contents.extractFromSlot(slot, amount, false);
        if (item.isEmpty()) {
            return item;
        }
        this.setChanged();
        return item;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return this.contents.removeFromSlot(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.contents.setStackInSlot(slot, stack)) {
            return;
        }
        this.setChanged();
    }

    private void addAllInventory(Player player) {
        if (!this.contents.addAllInventory(player)) {
            return;
        }
        this.setChanged();
        this.playSound(this.getBlockState(), SoundEvents.ITEM_FRAME_ADD_ITEM);
    }

    public ItemStack tryAddStack(ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        ItemStack item = this.contents.tryAddStack(stack, simulate);
        if (ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) && item.getCount() == stack.getCount()) {
            return item;
        }
        this.setChanged();
        this.playSound(this.getBlockState(), SoundEvents.ITEM_FRAME_ADD_ITEM);
        return item;
    }

    public ItemStack tryAddStack(ItemStack stack) {
        return this.tryAddStack(stack, false);
    }

    public ItemStack tryAddStack(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            this.addAllInventory(player);
            return ItemStack.EMPTY;
        }
        return this.tryAddStack(stack);
    }

    public ItemStack insertIntoSlot(int slot, ItemStack stack, boolean simulate) {
        ItemStack result = this.contents.insertIntoSlot(slot, stack, simulate);
        this.setChanged();
        return result;
    }

    public ItemStack extractFromSlot(int slot, int amount, boolean simulate) {
        ItemStack result = this.contents.extractFromSlot(slot, amount, simulate);
        this.setChanged();
        return result;
    }

    private ItemStack finishRequest(ItemStack stack) {
        this.setChanged();
        this.playSound(this.getBlockState(), SoundEvents.ITEM_FRAME_REMOVE_ITEM);
        return stack;
    }

    public ItemStack request(int amount) {
        return this.finishRequest(this.contents.request(amount));
    }

    public ItemStack requestOne() {
        return this.finishRequest(this.contents.requestOne());
    }

    public ItemStack requestOneStack() {
        return this.finishRequest(this.contents.requestOneStack());
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.contents.clear();
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        this.updateClient();
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.prepareUpdateTag(new CompoundTag(), registries);
    }

    void playSound(BlockState state, SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        Vec3i front = ((FrontAndTop)state.getValue((Property)BlockStateProperties.ORIENTATION)).front().getNormal();
        Vec3 pos = this.worldPosition.getCenter().add((double)front.getX() / 2.0, (double)front.getY() / 2.0, (double)front.getZ() / 2.0);
        this.level.playSound(null, pos.x, pos.y, pos.z, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.condiments.crate");
    }

    @NotNull
    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        CrateContents crateContents = (CrateContents)componentInput.getOrDefault(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        this.loadCrateContents(crateContents);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        components.set(ModComponents.CRATE_CONTENTS.get(), (Object)this.contents.toImmutable());
        components.set(DataComponents.MAX_STACK_SIZE, (Object)(this.getCount() > 0 ? 1 : CommonConfig.EMPTY_CRATE_STACK_SIZE.get()));
    }
}

