/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.compat.create;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.Contraption;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.compat.create.CreateCompat;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateMountedStorage
extends MountedItemStorage
implements SyncedMountedStorage {
    public static final MapCodec<CrateMountedStorage> CODEC = CrateMountedStorage.codec(CrateMountedStorage::new);
    private final CrateContents.SlottedMutable contents;
    private boolean dirty;

    public CrateMountedStorage(MountedItemStorageType<?> type, CrateContents contents) {
        super(type);
        this.contents = contents.toSlottedMutable();
    }

    public CrateMountedStorage(CrateContents contents) {
        this((MountedItemStorageType)CreateCompat.CRATE_MOUNTED_STORAGE.get(), contents);
    }

    protected CrateContents getContents() {
        return this.contents.toImmutable();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        Object v = contraption.presentBlockEntities.get(localPos);
        if (v instanceof CrateBlockEntity) {
            CrateBlockEntity crateBlockEntity = (CrateBlockEntity)((Object)v);
            crateBlockEntity.loadCrateContents(this.getContents());
        }
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity blockEntity) {
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity crateBlockEntity = (CrateBlockEntity)blockEntity;
            crateBlockEntity.loadCrateContents(this.getContents());
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.markDirty();
        this.contents.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return CrateContents.maxStacks();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.contents.getSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        this.markDirty();
        return this.contents.insertIntoSlot(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.markDirty();
        return this.contents.extractFromSlot(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.contents.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.contents.canAdd(stack);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    public static <T extends CrateMountedStorage> MapCodec<T> codec(Function<CrateContents, T> factory) {
        return CrateContents.CODEC.xmap(factory, CrateMountedStorage::getContents).fieldOf("value");
    }
}

