/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.dynamicpack;

import com.mojang.blaze3d.platform.NativeImage;
import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.reg.ModBlockSetVariants;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientDynamicResourcesGenerator
extends DynamicClientResourceProvider {
    public ClientDynamicResourcesGenerator() {
        super(Condiments.loc("dynamic_resources"), PackGenerationStrategy.CACHED_ZIPPED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft");
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept(this::buildAssets);
    }

    private void buildAssets(ResourceManager manager, ResourceSink sink) {
        this.addWoodWallAssets(manager, sink);
        this.addWoodAccentAssets(manager, sink);
        this.addPolishedWoodAssets(manager, sink);
    }

    private void addWoodWallAssets(ResourceManager manager, ResourceSink sink) {
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Condiments.loc("oak_wall")));
        StaticResource blockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Condiments.loc("oak_wall")));
        StaticResource post = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_post")));
        StaticResource sideTallX = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_tall_x")));
        StaticResource sideTallZ = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_tall_z")));
        StaticResource sideX = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_x")));
        StaticResource sideZ = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("wood_walls/oak_wall_side_z")));
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> {
            try {
                String id = Utils.getID((Item)wall).getPath();
                ResourceLocation log = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, t -> !t.contains("top"));
                ResourceLocation strippedLog = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log"), t -> !t.contains("top"));
                Function<String, String> textTransform = s -> s.replace("oak_wall", id).replace("minecraft:block/oak_log", log.toString()).replace("minecraft:block/stripped_oak_log", strippedLog.toString());
                sink.addSimilarJsonResource(manager, itemModel, textTransform);
                sink.addSimilarJsonResource(manager, blockState, "oak_wall", id);
                sink.addSimilarJsonResource(manager, post, textTransform);
                sink.addSimilarJsonResource(manager, sideTallX, textTransform);
                sink.addSimilarJsonResource(manager, sideTallZ, textTransform);
                sink.addSimilarJsonResource(manager, sideX, textTransform);
                sink.addSimilarJsonResource(manager, sideZ, textTransform);
            }
            catch (Exception e) {
                Condiments.LOGGER.error("Failed to create log model for {}", wall, (Object)e);
            }
        });
    }

    private void addWoodAccentAssets(ResourceManager manager, ResourceSink sink) {
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Condiments.loc("oak_accent")));
        StaticResource blockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Condiments.loc("oak_accent")));
        StaticResource base = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent")));
        StaticResource inner = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent_inner")));
        StaticResource outer = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("accents/oak_accent_outer")));
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> {
            String id = Utils.getID((Item)accent).getPath();
            Function<String, String> textTransform = s -> s.replace("oak_accent", id);
            try (TextureImage top = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log"), t -> t.contains("top")));
                 TextureImage side = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log"), t -> !t.contains("top")));){
                sink.addSimilarJsonResource(manager, itemModel, textTransform);
                sink.addSimilarJsonResource(manager, blockState, textTransform);
                sink.addSimilarJsonResource(manager, base, textTransform);
                sink.addSimilarJsonResource(manager, inner, textTransform);
                sink.addSimilarJsonResource(manager, outer, textTransform);
                ResourceLocation textureLoc = Condiments.loc("block/" + wood.getTexturePath() + "_accent");
                if (!sink.alreadyHasTextureAtLocation(manager, textureLoc)) {
                    sink.addTexture(textureLoc, TextureImage.of((NativeImage)ClientDynamicResourcesGenerator.buildAccentTexture(top.getImage(), side.getImage())));
                }
            }
            catch (Exception e) {
                Condiments.LOGGER.error("Failed to generate wood accent assets for {} : {}", accent, (Object)e);
            }
        });
    }

    private void addPolishedWoodAssets(ResourceManager manager, ResourceSink sink) {
        StaticResource logModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Condiments.loc("polished_oak_log")));
        StaticResource woodModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Condiments.loc("polished_oak_wood")));
        StaticResource logState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Condiments.loc("polished_oak_log")));
        StaticResource woodState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Condiments.loc("polished_oak_wood")));
        StaticResource logX = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_x")));
        StaticResource logY = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_y")));
        StaticResource logZ = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_log_z")));
        StaticResource woodX = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_x")));
        StaticResource woodY = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_y")));
        StaticResource woodZ = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Condiments.loc("polished_logs/polished_oak_wood_z")));
        try (TextureImage baseTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)Condiments.loc("block/polished_oak_log_top"));
             TextureImage baseSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)Condiments.loc("block/polished_oak_log"));){
            Respriter topRespriter = Respriter.of((TextureImage)baseTop);
            Respriter sideRespriter = Respriter.of((TextureImage)baseSide);
            ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
                block27: {
                    WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
                    String logId = Utils.getID((Item)logItem).getPath();
                    String woodId = Utils.getID((Item)woodItem).getPath();
                    Function<String, String> textTransform = s -> s.replace("polished_oak_log", logId).replace("polished_oak_wood", woodId);
                    try (TextureImage top = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log"), t -> t.contains("top")));
                         TextureImage side = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log"), t -> !t.contains("top")));){
                        sink.addSimilarJsonResource(manager, logModel, textTransform);
                        sink.addSimilarJsonResource(manager, woodModel, textTransform);
                        sink.addSimilarJsonResource(manager, logState, textTransform);
                        sink.addSimilarJsonResource(manager, woodState, textTransform);
                        sink.addSimilarJsonResource(manager, logX, textTransform);
                        sink.addSimilarJsonResource(manager, logY, textTransform);
                        sink.addSimilarJsonResource(manager, logZ, textTransform);
                        sink.addSimilarJsonResource(manager, woodX, textTransform);
                        sink.addSimilarJsonResource(manager, woodY, textTransform);
                        sink.addSimilarJsonResource(manager, woodZ, textTransform);
                        Palette palette = Palette.merge((Palette[])new Palette[]{Palette.fromImage((TextureImage)top), Palette.fromImage((TextureImage)side)});
                        PaletteColor lightest = palette.getLightest();
                        PaletteColor darkest = palette.getDarkest();
                        while (palette.size() > 6) {
                            palette.reduce();
                        }
                        palette.add(lightest);
                        palette.add(darkest);
                        ResourceLocation textureLoc = Condiments.loc("block/" + logId);
                        if (sink.alreadyHasTextureAtLocation(manager, textureLoc)) break block27;
                        try (TextureImage newImage = topRespriter.recolor(palette);){
                            sink.addTexture(textureLoc.withSuffix("_top"), newImage);
                        }
                        newImage = sideRespriter.recolor(palette);
                        try {
                            sink.addTexture(textureLoc, newImage);
                        }
                        finally {
                            if (newImage != null) {
                                newImage.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        Condiments.LOGGER.error("Failed to generate polished wood assets for {} : {}", logItem, (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Condiments.LOGGER.error("Failed to get base polished wood textures", (Throwable)e);
        }
    }

    @NotNull
    private static NativeImage buildAccentTexture(NativeImage top, NativeImage side) {
        if (side.getWidth() < 16) {
            return side;
        }
        int scale = side.getWidth() / 16;
        NativeImage image = new NativeImage(16 * scale, 16 * scale, false);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, side, image, 4, 0, 0, 0, 8, 16, false, false);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, side, image, 4, 0, 8, 0, 8, 16, false, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 5, 5, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 8, 5, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 5, 8, 3, 3, true, true);
        ClientDynamicResourcesGenerator.copyScaledRect(scale, top, image, 7, 7, 8, 8, 3, 3, true, true);
        return image;
    }

    private static void copyScaledRect(int scale, NativeImage from, NativeImage to, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX, boolean mirrorY) {
        from.copyRect(to, xFrom, yFrom * scale, xTo * scale, yTo * scale, width * scale, height * scale, mirrorX, mirrorY);
    }

    protected void addDynamicTranslations(AfterLanguageLoadEvent event) {
        LangBuilder langBuilder = new LangBuilder();
        this.addWoodWallLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        this.addWoodAccentLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        this.addPolishedWoodLang(langBuilder, arg_0 -> ((AfterLanguageLoadEvent)event).getEntry(arg_0));
        event.addEntries(langBuilder);
    }

    private void addWoodWallLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.wood_wall");
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> langBuilder.addEntry(wall.getBlock(), String.format(template, entryProvider.apply(wood.getTranslationKey()))));
    }

    private void addWoodAccentLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.wood_accent");
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> langBuilder.addEntry(accent.getBlock(), String.format(template, entryProvider.apply(wood.getTranslationKey()))));
    }

    private void addPolishedWoodLang(LangBuilder langBuilder, Function<String, String> entryProvider) {
        String template = entryProvider.apply("condiments.translation_template.polished_wood");
        ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
            WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
            langBuilder.addEntry(logItem.getBlock(), String.format(template, entryProvider.apply(Utils.getID((Block)wood.log).toLanguageKey("block"))));
            Optional.ofNullable(ModBlockSetVariants.getWoodBlock(wood, "wood")).ifPresent(block -> langBuilder.addEntry(woodItem.getBlock(), String.format(template, entryProvider.apply(Utils.getID((Block)block).toLanguageKey("block")))));
        });
    }
}

