/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.dynamicpack;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.reg.ModBlockSetVariants;
import dev.chililisoup.condiments.reg.ModBlockTags;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ServerDynamicResourcesGenerator
extends DynamicServerResourceProvider {
    public ServerDynamicResourcesGenerator() {
        super(Condiments.loc("dynamic_resources"), PackGenerationStrategy.CACHED_ZIPPED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return PlatHelper.getInstalledMods();
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            this.addWoodWallData(manager, sink);
            this.addWoodAccentData(manager, sink);
            this.addPolishedWoodData(manager, sink);
        });
    }

    private void addWoodWallData(ResourceManager manager, ResourceSink sink) {
        SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of(ModBlockTags.WOOD_WALLS);
        blockTagBuilder.addEntries((Collection)ModBlockSetVariants.WOOD_WALLS.items.values().stream().map(BlockItem::getBlock).collect(Collectors.toSet()));
        sink.addTag(blockTagBuilder, Registries.BLOCK);
        SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of(ModBlockTags.WOOD_WALLS);
        itemTagBuilder.addEntries(ModBlockSetVariants.WOOD_WALLS.items.values());
        sink.addTag(itemTagBuilder, Registries.ITEM);
        StaticResource lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/oak_wall")));
        StaticResource recipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Condiments.loc("wood_walls/oak_wall")));
        StaticResource advancement = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/wood_walls/oak_wall")));
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> {
            String log = Utils.getID((Block)wood.log).toString();
            String id = Utils.getID((Item)wall).getPath();
            Function<String, String> textTransform = s -> s.replace("minecraft:oak_log", log).replace("oak_wall", id);
            sink.addSimilarJsonResource(manager, lootTable, textTransform);
            sink.addSimilarJsonResource(manager, recipe, textTransform);
            sink.addSimilarJsonResource(manager, advancement, textTransform);
        });
    }

    private void addWoodAccentData(ResourceManager manager, ResourceSink sink) {
        SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of((ResourceLocation)Condiments.loc("wood_accents"));
        blockTagBuilder.addEntries((Collection)ModBlockSetVariants.WOOD_ACCENTS.items.values().stream().map(BlockItem::getBlock).collect(Collectors.toSet()));
        sink.addTag(blockTagBuilder, Registries.BLOCK);
        SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of((ResourceLocation)Condiments.loc("wood_accents"));
        itemTagBuilder.addEntries(ModBlockSetVariants.WOOD_ACCENTS.items.values());
        sink.addTag(itemTagBuilder, Registries.ITEM);
        StaticResource lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/oak_accent")));
        StaticResource recipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Condiments.loc("accents/oak_accent")));
        StaticResource advancement = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/accents/oak_accent")));
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> {
            String log = Utils.getID((Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log")).toString();
            String id = Utils.getID((Item)accent).getPath();
            Function<String, String> textTransform = s -> s.replace("minecraft:stripped_oak_log", log).replace("oak_accent", id);
            sink.addSimilarJsonResource(manager, lootTable, textTransform);
            sink.addSimilarJsonResource(manager, recipe, textTransform);
            sink.addSimilarJsonResource(manager, advancement, textTransform);
        });
    }

    private void addPolishedWoodData(ResourceManager manager, ResourceSink sink) {
        SimpleTagBuilder polishedBlockTagBuilder = SimpleTagBuilder.of((ResourceLocation)Condiments.loc("polished_logs"));
        SimpleTagBuilder polishedItemTagBuilder = SimpleTagBuilder.of((ResourceLocation)Condiments.loc("polished_logs"));
        StaticResource logLootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/polished_oak_log")));
        StaticResource woodLootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/polished_oak_wood")));
        StaticResource logRecipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_log")));
        StaticResource logsToWoodRecipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_logs_to_wood")));
        StaticResource woodRecipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_wood")));
        StaticResource logAdvancement = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/polished_wood/polished_oak_log")));
        StaticResource woodAdvancement = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/polished_wood/polished_oak_wood")));
        ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
            WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
            polishedBlockTagBuilder.addEntry((Object)logItem.getBlock());
            polishedBlockTagBuilder.addEntry((Object)woodItem.getBlock());
            polishedItemTagBuilder.addEntry(logItem);
            polishedItemTagBuilder.addEntry((Object)woodItem);
            ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)wood.getNamespace(), (String)(Utils.getID((Block)wood.log).getPath() + "s"));
            SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of((ResourceLocation)loc);
            blockTagBuilder.addEntry((Object)logItem.getBlock());
            blockTagBuilder.addEntry((Object)woodItem.getBlock());
            sink.addTag(blockTagBuilder, Registries.BLOCK);
            SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of((ResourceLocation)loc);
            itemTagBuilder.addEntry(logItem);
            itemTagBuilder.addEntry((Object)woodItem);
            sink.addTag(itemTagBuilder, Registries.ITEM);
            String strippedLog = Utils.getID((Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_log")).toString();
            String strippedWood = Utils.getID((Block)ModBlockSetVariants.getWoodBlock(wood, "stripped_wood")).toString();
            String logId = Utils.getID((Item)logItem).getPath();
            String woodId = Utils.getID((Item)woodItem).getPath();
            Function<String, String> textTransform = s -> s.replace("minecraft:stripped_oak_log", strippedLog).replace("minecraft:stripped_oak_wood", strippedWood).replace("polished_oak_log", logId).replace("polished_oak_wood", woodId);
            sink.addSimilarJsonResource(manager, logLootTable, textTransform);
            sink.addSimilarJsonResource(manager, woodLootTable, textTransform);
            sink.addSimilarJsonResource(manager, logRecipe, textTransform);
            sink.addSimilarJsonResource(manager, logsToWoodRecipe, textTransform);
            sink.addSimilarJsonResource(manager, woodRecipe, textTransform);
            sink.addSimilarJsonResource(manager, logAdvancement, textTransform);
            sink.addSimilarJsonResource(manager, woodAdvancement, textTransform);
        });
        sink.addTag(polishedBlockTagBuilder, Registries.BLOCK);
        sink.addTag(polishedItemTagBuilder, Registries.ITEM);
    }
}

