/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import dev.chililisoup.condiments.mixin.BlockItemAccess;
import dev.chililisoup.condiments.mixin.UseOnContextAccess;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CrateItem
extends BlockItem {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public CrateItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(CommonConfig.EMPTY_CRATE_STACK_SIZE.get().intValue()));
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.fillPercent() >= 0.0f;
    }

    public int getBarWidth(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        float fillPercent = crateContents.fillPercent();
        return Math.min((fillPercent > 0.0f ? 1 : 0) + (int)Math.floor(fillPercent * 12.0f), 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        if (crateContents.isLocked()) {
            tooltipComponents.add((Component)Component.translatable((String)(crateContents.item().isEmpty() ? "item.condiments.crate.tooltip.locked_unset" : "item.condiments.crate.tooltip.locked")).withStyle(ChatFormatting.GRAY));
        }
        if (crateContents.autoPickup().booleanValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.condiments.crate.tooltip.auto_pickup").withStyle(ChatFormatting.GRAY));
        }
        if (crateContents.item().isEmpty() || crateContents.count() <= 0 && !crateContents.isLocked()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.condiments.crate.tooltip.empty").withStyle(ChatFormatting.GRAY));
            return;
        }
        tooltipComponents.add((Component)Component.literal((String)String.format("%d/%d", crateContents.count(), crateContents.capacity())).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.item().flatMap(item -> Optional.of(new CrateTooltip((ItemStack)item)));
    }

    private static void updateInventories(ItemStack slotStack, Slot slot, Player player) {
        MultiPlayerGameMode gameMode;
        slot.setChanged();
        player.containerMenu.slotsChanged(slot.container);
        player.inventoryMenu.slotsChanged(slot.container);
        if (PlatHelper.getPhysicalSide().isClient() && Minecraft.getInstance().screen instanceof CreativeModeInventoryScreen && (gameMode = Minecraft.getInstance().gameMode) != null) {
            gameMode.handleCreativeModeItemAdd(slotStack, slot.index);
        }
    }

    public boolean overrideStackedOnOther(ItemStack crateStack, Slot slot, ClickAction action, Player player) {
        if (crateStack.getCount() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        ItemStack insertedStack = slot.getItem();
        if (insertedStack.isEmpty()) {
            ItemStack itemType = mutable.getItemType();
            if (itemType.isEmpty() || !slot.mayPlace(itemType)) {
                return false;
            }
            this.playRemoveOneSound((Entity)player);
            slot.safeInsert(mutable.requestOneStack());
        } else if (mutable.addFromSlot(slot, player) > 0) {
            this.playInsertSound((Entity)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(insertedStack, slot, player);
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack crateStack, ItemStack insertedStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (crateStack.getCount() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        if (insertedStack.isEmpty()) {
            ItemStack itemStack = mutable.requestOneStack();
            if (!itemStack.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                access.set(itemStack);
            }
        } else if (mutable.addFromStack(insertedStack) > 0) {
            this.playInsertSound((Entity)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(crateStack, slot, player);
        return true;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.ITEM_FRAME_ADD_ITEM, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private InteractionResult placeContents(BlockPlaceContext context, BlockItem blockItem, ItemStack itemStack) {
        if (!blockItem.getBlock().isEnabled(context.getLevel().enabledFeatures()) || !context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = blockItem.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = ((BlockItemAccess)blockItem).condiments$getPlacementState(blockPlaceContext);
        if (blockState == null || !this.placeBlock(blockPlaceContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        Level level = blockPlaceContext.getLevel();
        Player player = blockPlaceContext.getPlayer();
        BlockState clickedState = level.getBlockState(blockPos);
        if (clickedState.is(blockState.getBlock())) {
            clickedState = ((BlockItemAccess)blockItem).condiments$updateBlockStateFromTag(blockPos, level, itemStack, clickedState);
            ((BlockItemAccess)blockItem).condiments$updateCustomBlockEntityTag(blockPos, level, player, itemStack, clickedState);
            BlockItemAccess.condiments$updateBlockEntityComponents(level, blockPos, itemStack);
            clickedState.getBlock().setPlacedBy(level, blockPos, clickedState, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, blockPos, itemStack);
            }
        }
        SoundType soundType = clickedState.getSoundType();
        level.playSound(player, blockPos, ((BlockItemAccess)blockItem).condiments$getPlaceSound(clickedState), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)clickedState));
        itemStack.consume(1, (LivingEntity)player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        ItemStack crateStack = context.getItemInHand();
        if (player == null || player.isShiftKeyDown() || !(crateStack.getItem() instanceof CrateItem)) {
            return super.place(context);
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        if (crateContents.count() <= 0) {
            return super.place(context);
        }
        CrateContents.ItemRecord itemRecord = crateContents.itemRecord();
        if (itemRecord == null) {
            return super.place(context);
        }
        ItemStack contentsStack = itemRecord.asItemStack();
        Item item = contentsStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockPlaceContext contentsContext = new BlockPlaceContext(player, context.getHand(), contentsStack, ((UseOnContextAccess)context).condiments$getHitResult());
            InteractionResult result = this.placeContents(contentsContext, blockItem, contentsStack);
            if (!player.hasInfiniteMaterials() && result.indicateItemUse()) {
                CrateContents.Mutable mutable = crateContents.toMutable();
                mutable.requestOne();
                mutable.toImmutable().updateCrateItem(crateStack);
            }
            return result;
        }
        return super.place(context);
    }
}

