/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import dev.chililisoup.condiments.block.IDestroyPreventable;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.reg.ModBlocks;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5000;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends class_2237
implements IDestroyPreventable {
    private static final class_2754<class_5000> ORIENTATION = class_2741.field_23333;
    @Nullable
    private final class_1767 color;

    public CrateBlock(@Nullable class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.color = color;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(ORIENTATION, (Comparable)class_5000.field_23391));
    }

    public static class_3965 getHitResult(class_1937 level, class_2338 pos, class_1297 player) {
        class_243 eyePos = player.method_5836(1.0f);
        return level.method_17742(new class_3959(eyePos, eyePos.method_1019(player.method_5828(1.0f).method_1021(eyePos.method_1022(class_243.method_24953((class_2382)pos)) + 1.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, player));
    }

    public static Optional<class_241> getHitPosition(class_3965 hitResult, class_2350 face) {
        class_2350 direction = hitResult.method_17780();
        if (face != direction) {
            return Optional.empty();
        }
        class_2338 blockPos = hitResult.method_17777().method_10093(direction);
        class_243 vec3 = hitResult.method_17784().method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        double x = vec3.method_10216();
        double y = vec3.method_10214();
        double z = vec3.method_10215();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043, class_2350.field_11035 -> Optional.of(new class_241((float)x, (float)y));
            case class_2350.field_11039, class_2350.field_11034 -> Optional.of(new class_241((float)z, (float)y));
            case class_2350.field_11036, class_2350.field_11033 -> Optional.of(new class_241((float)x, (float)z));
        };
    }

    public static boolean isNotInBounds(class_241 pos) {
        return (double)pos.field_1343 < 0.125 || (double)pos.field_1343 > 0.875 || (double)pos.field_1342 < 0.125 || (double)pos.field_1342 > 0.875;
    }

    private static Optional<CrateBlockEntity> checkUseAndGet(class_2680 state, class_1937 level, class_2338 pos, class_3965 hitResult) {
        CrateBlockEntity crateBlockEntity;
        block5: {
            block4: {
                boolean hitFace = hitResult.method_17780() == ((class_5000)state.method_11654(ORIENTATION)).method_26426();
                class_2586 class_25862 = level.method_8321(pos);
                if (!(class_25862 instanceof CrateBlockEntity)) break block4;
                crateBlockEntity = (CrateBlockEntity)class_25862;
                if (hitFace) break block5;
            }
            return Optional.empty();
        }
        Optional<class_241> hitPos = CrateBlock.getHitPosition(hitResult, ((class_5000)state.method_11654(ORIENTATION)).method_26426());
        if (hitPos.isEmpty() || CrateBlock.isNotInBounds(hitPos.get())) {
            return Optional.empty();
        }
        return Optional.of(crateBlockEntity);
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        Optional<CrateBlockEntity> crateBlockEntity = CrateBlock.checkUseAndGet(state, level, pos, hitResult);
        if (crateBlockEntity.isEmpty()) {
            return class_1269.field_5811;
        }
        if (!level.field_9236) {
            class_1799 stack = player.method_5998(hand);
            if (crateBlockEntity.get().canAddItem(stack)) {
                player.method_6122(hand, crateBlockEntity.get().tryAddStack(player.method_5998(hand), player));
            } else if (player.field_6279 > 0) {
                crateBlockEntity.get().tryAddStack(class_1799.field_8037, player);
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_1542 itemEntity;
        if (level.field_9236) {
            return;
        }
        Optional<CrateBlockEntity> crateBlockEntity = CrateBlock.checkUseAndGet(state, level, pos, CrateBlock.getHitResult(level, pos, (class_1297)player));
        if (crateBlockEntity.isEmpty()) {
            return;
        }
        class_1799 itemStack = player.method_5715() ? crateBlockEntity.get().requestOneStack() : crateBlockEntity.get().requestOne();
        player.method_7270(itemStack);
        if (itemStack.method_7947() > 0 && (itemEntity = player.method_7328(itemStack, false)) != null) {
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
    }

    private boolean playerDidHit(class_2350 front, class_3965 hitResult) {
        return CrateBlock.getHitPosition(hitResult, front).filter(hitPos -> !CrateBlock.isNotInBounds(hitPos)).isPresent();
    }

    @Nullable
    private CrateBlockEntity playerHit(class_2680 state, class_2338 pos, class_1657 player, class_2350 face, Supplier<class_3965> hitResultSupplier) {
        class_2350 front = ((class_5000)state.method_11654(ORIENTATION)).method_26426();
        if (face != front) {
            return null;
        }
        class_2586 class_25862 = player.method_37908().method_8321(pos);
        if (!(class_25862 instanceof CrateBlockEntity)) {
            return null;
        }
        CrateBlockEntity crateBlockEntity = (CrateBlockEntity)class_25862;
        return this.playerDidHit(front, hitResultSupplier.get()) ? crateBlockEntity : null;
    }

    @Nullable
    private CrateBlockEntity playerHit(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_2350 face) {
        return this.playerHit(state, pos, player, face, () -> CrateBlock.getHitResult(level, pos, (class_1297)player));
    }

    private boolean shouldPreventDamage(class_2680 state, class_1657 player, class_2338 pos) {
        class_3965 hitResult = CrateBlock.getHitResult(player.method_37908(), pos, (class_1297)player);
        class_2350 front = ((class_5000)state.method_11654(ORIENTATION)).method_26426();
        if (hitResult.method_17780() != front) {
            return false;
        }
        if (!(player.method_37908().method_8321(pos) instanceof CrateBlockEntity)) {
            return false;
        }
        return this.playerDidHit(front, hitResult);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        return this.shouldPreventDamage(state, player, pos) ? 0.0f : super.method_9594(state, player, level, pos);
    }

    @Override
    public boolean shouldCancelDestroy(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_2350 face) {
        class_1542 itemEntity;
        if (!player.method_7337()) {
            return false;
        }
        CrateBlockEntity crateBlockEntity = this.playerHit(state, level, pos, player, face);
        if (crateBlockEntity == null) {
            return false;
        }
        if (level.field_9236) {
            return true;
        }
        class_1799 itemStack = player.method_5715() ? crateBlockEntity.requestOneStack() : crateBlockEntity.requestOne();
        player.method_7270(itemStack);
        if (itemStack.method_7947() > 0 && (itemEntity = player.method_7328(itemStack, false)) != null) {
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
        return true;
    }

    @Override
    public boolean shouldPreventAttackRetrigger(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_2350 face, class_3965 hitResult) {
        return this.playerHit(state, pos, player, face, () -> hitResult) != null;
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(level, pos, state, player);
        if (!level.field_9236 && player.method_7337() && !((CrateBlockEntity)Objects.requireNonNull(level.method_8321(pos))).method_5442()) {
            class_2248.method_9562((class_2680)state, (class_3218)((class_3218)level), (class_2338)pos, (class_2586)level.method_8321(pos)).forEach(drop -> {
                class_1542 ent = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, drop);
                ent.method_6988();
                ent.method_18800(0.0, 0.0, 0.0);
                level.method_8649((class_1297)ent);
            });
        }
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof CrateBlockEntity) {
                level.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, level, pos, newState, movedByPiston);
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (!stack.method_7938()) {
            return;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity = (CrateBlockEntity)class_25862;
            blockEntity.setCustomName(stack.method_7964());
        }
    }

    @Nullable
    public static class_1767 getColorFromItem(class_1792 item) {
        return CrateBlock.getColorFromBlock(class_2248.method_9503((class_1792)item));
    }

    @Nullable
    public static class_1767 getColorFromBlock(class_2248 block) {
        return block instanceof CrateBlock ? ((CrateBlock)block).getColor() : null;
    }

    public static class_2248 getBlockByColor(@Nullable class_1767 color) {
        if (color == null) {
            return ModBlocks.CRATE.get();
        }
        return switch (color) {
            case class_1767.field_7952 -> ModBlocks.WHITE_CRATE.get();
            case class_1767.field_7967 -> ModBlocks.LIGHT_GRAY_CRATE.get();
            case class_1767.field_7944 -> ModBlocks.GRAY_CRATE.get();
            case class_1767.field_7963 -> ModBlocks.BLACK_CRATE.get();
            case class_1767.field_7957 -> ModBlocks.BROWN_CRATE.get();
            case class_1767.field_7964 -> ModBlocks.RED_CRATE.get();
            case class_1767.field_7946 -> ModBlocks.ORANGE_CRATE.get();
            case class_1767.field_7947 -> ModBlocks.YELLOW_CRATE.get();
            case class_1767.field_7961 -> ModBlocks.LIME_CRATE.get();
            case class_1767.field_7942 -> ModBlocks.GREEN_CRATE.get();
            case class_1767.field_7955 -> ModBlocks.CYAN_CRATE.get();
            case class_1767.field_7951 -> ModBlocks.LIGHT_BLUE_CRATE.get();
            case class_1767.field_7966 -> ModBlocks.BLUE_CRATE.get();
            case class_1767.field_7945 -> ModBlocks.PURPLE_CRATE.get();
            case class_1767.field_7958 -> ModBlocks.MAGENTA_CRATE.get();
            default -> ModBlocks.PINK_CRATE.get();
        };
    }

    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    public static class_1799 getColoredItemStack(@Nullable class_1767 color) {
        return new class_1799((class_1935)CrateBlock.getBlockByColor(color));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CrateBlockEntity(pos, state);
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return class_1703.method_7608((class_2586)level.method_8321(pos));
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 front = context.method_7715().method_10153();
        class_2350 top = switch (front) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> context.method_8042().method_10153();
            case class_2350.field_11036 -> context.method_8042();
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> class_2350.field_11036;
        };
        return (class_2680)this.method_9564().method_11657(ORIENTATION, (Comparable)class_5000.method_26425((class_2350)front, (class_2350)top));
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)rotation.method_26383().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)mirror.method_26380().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ORIENTATION});
    }
}

