/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.client.renderer.CrateItemRenderer;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import dev.chililisoup.condiments.mixin.BlockItemAccess;
import dev.chililisoup.condiments.mixin.UseOnContextAccess;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_636;
import org.jetbrains.annotations.NotNull;

public class CrateItem
extends class_1747
implements ICustomItemRendererProvider {
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public CrateItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties.method_7889(CommonConfig.EMPTY_CRATE_STACK_SIZE.get().intValue()));
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.fillPercent() >= 0.0f;
    }

    public int method_31569(class_1799 stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        float fillPercent = crateContents.fillPercent();
        return Math.min((fillPercent > 0.0f ? 1 : 0) + (int)Math.floor(fillPercent * 12.0f), 13);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, level, tooltipComponents, tooltipFlag);
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        if (crateContents.isLocked()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)(crateContents.item().isEmpty() ? "item.condiments.crate.tooltip.locked_unset" : "item.condiments.crate.tooltip.locked")).method_27692(class_124.field_1080));
        }
        if (crateContents.autoPickup().booleanValue()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.condiments.crate.tooltip.auto_pickup").method_27692(class_124.field_1080));
        }
        if (crateContents.item().isEmpty() || crateContents.count() <= 0 && !crateContents.isLocked()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.condiments.crate.tooltip.empty").method_27692(class_124.field_1080));
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43470((String)String.format("%d/%d", crateContents.count(), crateContents.capacity())).method_27692(class_124.field_1080));
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 stack) {
        CrateContents crateContents = CrateContents.fromCrateItem(stack);
        return crateContents.item().flatMap(item -> Optional.of(new CrateTooltip((class_1799)item)));
    }

    private static void updateInventories(class_1799 slotStack, class_1735 slot, class_1657 player) {
        class_636 gameMode;
        slot.method_7668();
        player.field_7512.method_7609(slot.field_7871);
        player.field_7498.method_7609(slot.field_7871);
        if (PlatHelper.getPhysicalSide().isClient() && class_310.method_1551().field_1755 instanceof class_481 && (gameMode = class_310.method_1551().field_1761) != null) {
            gameMode.method_2909(slotStack, slot.field_7874);
        }
    }

    public boolean method_31565(class_1799 crateStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (crateStack.method_7947() > 1) {
            return false;
        }
        if (action != class_5536.field_27014) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        class_1799 insertedStack = slot.method_7677();
        if (insertedStack.method_7960()) {
            class_1799 itemType = mutable.getItemType();
            if (itemType.method_7960() || !slot.method_7680(itemType)) {
                return false;
            }
            this.playRemoveOneSound((class_1297)player);
            slot.method_32756(mutable.requestOneStack());
        } else if (mutable.addFromSlot(slot, player) > 0) {
            this.playInsertSound((class_1297)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(insertedStack, slot, player);
        return true;
    }

    public boolean method_31566(class_1799 crateStack, class_1799 insertedStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (crateStack.method_7947() > 1) {
            return false;
        }
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        CrateContents.Mutable mutable = crateContents.toMutable();
        if (insertedStack.method_7960()) {
            class_1799 itemStack = mutable.requestOneStack();
            if (!itemStack.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                access.method_32332(itemStack);
            }
        } else if (mutable.addFromStack(insertedStack) > 0) {
            this.playInsertSound((class_1297)player);
        } else {
            return false;
        }
        mutable.toImmutable().updateCrateItem(crateStack);
        CrateItem.updateInventories(crateStack, slot, player);
        return true;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_14770, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_14667, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private class_1269 placeContents(class_1750 context, class_1747 blockItem, class_1799 itemStack) {
        if (!blockItem.method_7711().method_45382(context.method_8045().method_45162()) || !context.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 blockPlaceContext = blockItem.method_16356(context);
        if (blockPlaceContext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = ((BlockItemAccess)blockItem).condiments$getPlacementState(blockPlaceContext);
        if (blockState == null || !this.method_7708(blockPlaceContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        class_1657 player = blockPlaceContext.method_8036();
        class_2680 clickedState = level.method_8320(blockPos);
        if (clickedState.method_27852(blockState.method_26204())) {
            clickedState = ((BlockItemAccess)blockItem).condiments$updateBlockStateFromTag(blockPos, level, itemStack, clickedState);
            ((BlockItemAccess)blockItem).condiments$updateCustomBlockEntityTag(blockPos, level, player, itemStack, clickedState);
            clickedState.method_26204().method_9567(level, blockPos, clickedState, (class_1309)player, itemStack);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_1191.method_23889(serverPlayer, blockPos, itemStack);
            }
        }
        class_2498 soundType = clickedState.method_26231();
        level.method_8396(player, blockPos, ((BlockItemAccess)blockItem).condiments$getPlaceSound(clickedState), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        level.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)clickedState));
        if (player == null || !player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @NotNull
    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        class_1799 crateStack = context.method_8041();
        if (player == null || player.method_5715() || !(crateStack.method_7909() instanceof CrateItem)) {
            return super.method_7712(context);
        }
        CrateContents crateContents = CrateContents.fromCrateItem(crateStack);
        if (crateContents.count() <= 0) {
            return super.method_7712(context);
        }
        CrateContents.ItemRecord itemRecord = crateContents.itemRecord();
        if (itemRecord == null) {
            return super.method_7712(context);
        }
        class_1799 contentsStack = itemRecord.asItemStack();
        class_1792 class_17922 = contentsStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_1750 contentsContext = new class_1750(player, context.method_20287(), contentsStack, ((UseOnContextAccess)context).condiments$getHitResult());
            class_1269 result = this.placeContents(contentsContext, blockItem, contentsStack);
            if (!player.method_31549().field_7477 && result.method_36360()) {
                CrateContents.Mutable mutable = crateContents.toMutable();
                mutable.requestOne();
                mutable.toImmutable().updateCrateItem(crateStack);
            }
            return result;
        }
        return super.method_7712(context);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return CrateItemRenderer::new;
    }
}

