/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.mojang.serialization.MapCodec;
import dev.chililisoup.condiments.block.CondimentsRail;
import dev.chililisoup.condiments.config.CommonConfig;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class AnalogRailBlock
extends class_2241
implements CondimentsRail {
    public static final class_2754<class_2768> SHAPE = class_2741.field_12542;
    public static final class_2758 POWER = class_2741.field_12511;
    public static final MapCodec<AnalogRailBlock> CODEC = AnalogRailBlock.method_54094(AnalogRailBlock::new);

    @NotNull
    protected MapCodec<AnalogRailBlock> method_53969() {
        return CODEC;
    }

    public AnalogRailBlock(class_4970.class_2251 properties) {
        super(true, properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(SHAPE, (Comparable)class_2768.field_12665)).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)field_27096, (Comparable)Boolean.valueOf(false)));
    }

    protected int findAnalogRailSignal(class_1937 level, class_2338 pos, class_2680 state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8) {
            return 0;
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        boolean ascending = true;
        class_2768 railShape = (class_2768)state.method_11654(SHAPE);
        switch (railShape) {
            case field_12665: {
                z = searchForward ? ++z : --z;
                ascending = false;
                break;
            }
            case field_12674: {
                x = searchForward ? --x : ++x;
                ascending = false;
                break;
            }
            case field_12667: {
                if (searchForward) {
                    --x;
                } else {
                    ++x;
                    ++y;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case field_12666: {
                if (searchForward) {
                    --x;
                    ++y;
                } else {
                    ++x;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case field_12670: {
                if (searchForward) {
                    ++z;
                } else {
                    --z;
                    ++y;
                }
                railShape = class_2768.field_12665;
                break;
            }
            case field_12668: {
                if (searchForward) {
                    ++z;
                    ++y;
                } else {
                    --z;
                }
                railShape = class_2768.field_12665;
            }
        }
        int flatSignal = this.getConnectedPower(level, new class_2338(x, y, z), searchForward, recursionCount, railShape);
        if (flatSignal > 0) {
            return flatSignal;
        }
        if (ascending) {
            return 0;
        }
        return this.getConnectedPower(level, new class_2338(x, y - 1, z), searchForward, recursionCount, railShape);
    }

    protected int getConnectedPower(class_1937 level, class_2338 pos, boolean searchForward, int recursionCount, class_2768 shape) {
        class_2680 blockState = level.method_8320(pos);
        if (!blockState.method_27852((class_2248)this)) {
            return 0;
        }
        class_2768 railShape = (class_2768)blockState.method_11654(SHAPE);
        if (shape == class_2768.field_12674 && (railShape == class_2768.field_12665 || railShape == class_2768.field_12670 || railShape == class_2768.field_12668)) {
            return 0;
        }
        if (shape == class_2768.field_12665 && (railShape == class_2768.field_12674 || railShape == class_2768.field_12667 || railShape == class_2768.field_12666)) {
            return 0;
        }
        int power = (Integer)blockState.method_11654((class_2769)POWER);
        if (power > 0) {
            int signal = level.method_49804(pos);
            if (signal > 14) {
                return signal;
            }
            return Math.max(this.findAnalogRailSignal(level, pos, blockState, searchForward, recursionCount + 1), signal);
        }
        return 0;
    }

    protected void method_9477(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock) {
        int power = (Integer)state.method_11654((class_2769)POWER);
        int signal = level.method_49804(pos);
        if (signal < 15) {
            int backward;
            int forward = this.findAnalogRailSignal(level, pos, state, true, 0);
            if (forward > signal) {
                signal = forward;
            }
            if (signal < 15 && (backward = this.findAnalogRailSignal(level, pos, state, false, 0)) > signal) {
                signal = backward;
            }
        }
        if (signal == power) {
            return;
        }
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(signal)), 3);
        level.method_8452(pos.method_10074(), (class_2248)this);
        if (((class_2768)state.method_11654(SHAPE)).method_11897()) {
            level.method_8452(pos.method_10084(), (class_2248)this);
        }
    }

    @NotNull
    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)POWER);
    }

    public class_2769<Integer> getPowerProperty() {
        return POWER;
    }

    @Override
    public double getMaxSpeed(class_1688 cart) {
        return (cart.method_5799() ? 0.5 : 1.0) * CommonConfig.ANALOG_RAIL_MAX_SPEED.get();
    }

    @Override
    public void moveAlongTrack(class_2338 pos, class_2680 state, class_2768 railShape, class_1688 cart) {
        class_243 movement = cart.method_18798();
        double x = movement.field_1352;
        double z = movement.field_1350;
        double horizontalDistance = movement.method_37267();
        int power = (Integer)state.method_11654(((AnalogRailBlock)state.method_26204()).getPowerProperty());
        if (power == 0) {
            if (horizontalDistance < 0.03) {
                cart.method_18799(class_243.field_1353);
            } else {
                cart.method_18799(movement.method_18805(0.5, 0.0, 0.5));
            }
            return;
        }
        if (horizontalDistance > 0.01) {
            double speed = (double)power * this.getMaxSpeed(cart) / 15.0;
            if (x > 0.01) {
                x = speed;
            } else if (x < -0.01) {
                x = -speed;
            }
            if (z > 0.01) {
                z = speed;
            } else if (z < -0.01) {
                z = -speed;
            }
            cart.method_18800(x, 0.0, z);
            return;
        }
        if (railShape == class_2768.field_12674) {
            if (this.isRedstoneConductor(pos.method_10067(), cart)) {
                x = 0.02;
            } else if (this.isRedstoneConductor(pos.method_10078(), cart)) {
                x = -0.02;
            }
        } else {
            if (railShape != class_2768.field_12665) {
                return;
            }
            if (this.isRedstoneConductor(pos.method_10095(), cart)) {
                z = 0.02;
            } else if (this.isRedstoneConductor(pos.method_10072(), cart)) {
                z = -0.02;
            }
        }
        cart.method_18800(x, movement.field_1351, z);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE, POWER, field_27096});
    }
}

