/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.dynamicpack;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.reg.ModBlockSetVariants;
import dev.chililisoup.condiments.reg.ModBlockTags;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7924;

public class ServerDynamicResourcesGenerator
extends DynamicServerResourceProvider {
    private static ServerDynamicResourcesGenerator INSTANCE;

    public static ServerDynamicResourcesGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerDynamicResourcesGenerator();
        }
        return INSTANCE;
    }

    public ServerDynamicResourcesGenerator() {
        super(Condiments.loc("dynamic_resources"), PackGenerationStrategy.CACHED_ZIPPED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return PlatHelper.getInstalledMods();
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            this.addWoodWallData(manager, sink);
            this.addWoodAccentData(manager, sink);
            this.addPolishedWoodData(manager, sink);
        });
    }

    private void addWoodWallData(class_3300 manager, ResourceSink sink) {
        SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of(ModBlockTags.WOOD_WALLS);
        blockTagBuilder.addEntries((Collection)ModBlockSetVariants.WOOD_WALLS.items.values().stream().map(class_1747::method_7711).collect(Collectors.toSet()));
        sink.addTag(blockTagBuilder, class_7924.field_41254);
        SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of(ModBlockTags.WOOD_WALLS);
        itemTagBuilder.addEntries(ModBlockSetVariants.WOOD_WALLS.items.values());
        sink.addTag(itemTagBuilder, class_7924.field_41197);
        StaticResource lootTable = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/oak_wall")));
        StaticResource recipe = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.RECIPES.getPath(Condiments.loc("wood_walls/oak_wall")));
        StaticResource advancement = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/wood_walls/oak_wall")));
        ModBlockSetVariants.WOOD_WALLS.items.forEach((wood, wall) -> {
            String log = Utils.getID((class_2248)wood.log).toString();
            String id = Utils.getID((class_1792)wall).method_12832();
            Function<String, String> textTransform = s -> s.replace("minecraft:oak_log", log).replace("oak_wall", id);
            sink.addSimilarJsonResource(manager, lootTable, textTransform);
            sink.addSimilarJsonResource(manager, recipe, textTransform);
            sink.addSimilarJsonResource(manager, advancement, textTransform);
        });
    }

    private void addWoodAccentData(class_3300 manager, ResourceSink sink) {
        SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of((class_2960)Condiments.loc("wood_accents"));
        blockTagBuilder.addEntries((Collection)ModBlockSetVariants.WOOD_ACCENTS.items.values().stream().map(class_1747::method_7711).collect(Collectors.toSet()));
        sink.addTag(blockTagBuilder, class_7924.field_41254);
        SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of((class_2960)Condiments.loc("wood_accents"));
        itemTagBuilder.addEntries(ModBlockSetVariants.WOOD_ACCENTS.items.values());
        sink.addTag(itemTagBuilder, class_7924.field_41197);
        StaticResource lootTable = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/oak_accent")));
        StaticResource recipe = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.RECIPES.getPath(Condiments.loc("accents/oak_accent")));
        StaticResource advancement = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/accents/oak_accent")));
        ModBlockSetVariants.WOOD_ACCENTS.items.forEach((wood, accent) -> {
            String log = Utils.getID((class_2248)wood.getBlockOfThis("stripped_log")).toString();
            String id = Utils.getID((class_1792)accent).method_12832();
            Function<String, String> textTransform = s -> s.replace("minecraft:stripped_oak_log", log).replace("oak_accent", id);
            sink.addSimilarJsonResource(manager, lootTable, textTransform);
            sink.addSimilarJsonResource(manager, recipe, textTransform);
            sink.addSimilarJsonResource(manager, advancement, textTransform);
        });
    }

    private void addPolishedWoodData(class_3300 manager, ResourceSink sink) {
        SimpleTagBuilder polishedBlockTagBuilder = SimpleTagBuilder.of((class_2960)Condiments.loc("polished_logs"));
        SimpleTagBuilder polishedItemTagBuilder = SimpleTagBuilder.of((class_2960)Condiments.loc("polished_logs"));
        StaticResource logLootTable = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/polished_oak_log")));
        StaticResource woodLootTable = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.LOOT_TABLES.getPath(Condiments.loc("blocks/polished_oak_wood")));
        StaticResource logRecipe = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_log")));
        StaticResource logsToWoodRecipe = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_logs_to_wood")));
        StaticResource woodRecipe = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.RECIPES.getPath(Condiments.loc("polished_wood/polished_oak_wood")));
        StaticResource logAdvancement = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/polished_wood/polished_oak_log")));
        StaticResource woodAdvancement = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ADVANCEMENTS.getPath(Condiments.loc("recipes/polished_wood/polished_oak_wood")));
        ModBlockSetVariants.POLISHED_LOGS.items.forEach((wood, logItem) -> {
            WoodBasedBlockItem woodItem = ModBlockSetVariants.POLISHED_WOOD.items.get(wood);
            polishedBlockTagBuilder.addEntry((Object)logItem.method_7711());
            polishedBlockTagBuilder.addEntry((Object)woodItem.method_7711());
            polishedItemTagBuilder.addEntry(logItem);
            polishedItemTagBuilder.addEntry((Object)woodItem);
            class_2960 loc = class_2960.method_60655((String)wood.getNamespace(), (String)(Utils.getID((class_2248)wood.log).method_12832() + "s"));
            SimpleTagBuilder blockTagBuilder = SimpleTagBuilder.of((class_2960)loc);
            blockTagBuilder.addEntry((Object)logItem.method_7711());
            blockTagBuilder.addEntry((Object)woodItem.method_7711());
            sink.addTag(blockTagBuilder, class_7924.field_41254);
            SimpleTagBuilder itemTagBuilder = SimpleTagBuilder.of((class_2960)loc);
            itemTagBuilder.addEntry(logItem);
            itemTagBuilder.addEntry((Object)woodItem);
            sink.addTag(itemTagBuilder, class_7924.field_41197);
            String strippedLog = Utils.getID((class_2248)wood.getBlockOfThis("stripped_log")).toString();
            String strippedWood = Utils.getID((class_2248)wood.getBlockOfThis("stripped_wood")).toString();
            String logId = Utils.getID((class_1792)logItem).method_12832();
            String woodId = Utils.getID((class_1792)woodItem).method_12832();
            Function<String, String> textTransform = s -> s.replace("minecraft:stripped_oak_log", strippedLog).replace("minecraft:stripped_oak_wood", strippedWood).replace("polished_oak_log", logId).replace("polished_oak_wood", woodId);
            sink.addSimilarJsonResource(manager, logLootTable, textTransform);
            sink.addSimilarJsonResource(manager, woodLootTable, textTransform);
            sink.addSimilarJsonResource(manager, logRecipe, textTransform);
            sink.addSimilarJsonResource(manager, logsToWoodRecipe, textTransform);
            sink.addSimilarJsonResource(manager, woodRecipe, textTransform);
            sink.addSimilarJsonResource(manager, logAdvancement, textTransform);
            sink.addSimilarJsonResource(manager, woodAdvancement, textTransform);
        });
        sink.addTag(polishedBlockTagBuilder, class_7924.field_41254);
        sink.addTag(polishedItemTagBuilder, class_7924.field_41197);
    }
}

