/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AccentBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<AccentBlock> CODEC = AccentBlock.simpleCodec(AccentBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape[] TOP_SHAPES;
    protected static final VoxelShape[] BOTTOM_SHAPES;
    private static final int[] SHAPE_BY_STATE;

    @NotNull
    protected MapCodec<AccentBlock> codec() {
        return CODEC;
    }

    public AccentBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (state.getValue(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue(SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)blockPos.getY() > 0.5) ? Half.BOTTOM : Half.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)blockState.setValue(SHAPE, (Comparable)AccentBlock.getStairsShape(blockState, (BlockGetter)context.getLevel(), blockPos));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)AccentBlock.getStairsShape(state, (BlockGetter)level, pos)) : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockState = level.getBlockState(pos.relative(direction));
        if (AccentBlock.isAccent(blockState) && state.getValue(HALF) == blockState.getValue(HALF) && (direction2 = (Direction)blockState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && AccentBlock.canTakeShape(state, level, pos, direction2.getOpposite())) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockState2 = level.getBlockState(pos.relative(direction.getOpposite()));
        if (AccentBlock.isAccent(blockState2) && state.getValue(HALF) == blockState2.getValue(HALF) && (direction3 = (Direction)blockState2.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && AccentBlock.canTakeShape(state, level, pos, direction3)) {
            if (direction3 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.getBlockState(pos.relative(face));
        return !AccentBlock.isAccent(blockState) || blockState.getValue((Property)FACING) != state.getValue((Property)FACING) || blockState.getValue(HALF) != state.getValue(HALF);
    }

    public static boolean isAccent(BlockState state) {
        return state.getBlock() instanceof AccentBlock;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsShape = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() == Direction.Axis.Z) {
                    return switch (stairsShape) {
                        case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                        case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                        case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                        case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                        default -> state.rotate(Rotation.CLOCKWISE_180);
                    };
                }
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (stairsShape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    static {
        VoxelShape SIDE_BN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape SIDE_BS = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_BW = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_BE = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape SIDE_TN = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        VoxelShape SIDE_TS = Block.box((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape SIDE_TW = Block.box((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        VoxelShape SIDE_TE = Block.box((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape COR_BNW = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
        VoxelShape COR_BNE = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape COR_BSW = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape COR_BSE = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape COR_TNW = Block.box((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
        VoxelShape COR_TNE = Block.box((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        VoxelShape COR_TSW = Block.box((double)0.0, (double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
        VoxelShape COR_TSE = Block.box((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        TOP_SHAPES = new VoxelShape[]{SIDE_TS, SIDE_TW, SIDE_TN, SIDE_TE, Shapes.or((VoxelShape)SIDE_TS, (VoxelShape)SIDE_TE), Shapes.or((VoxelShape)SIDE_TW, (VoxelShape)SIDE_TS), Shapes.or((VoxelShape)SIDE_TN, (VoxelShape)SIDE_TW), Shapes.or((VoxelShape)SIDE_TE, (VoxelShape)SIDE_TN), COR_TSE, COR_TSW, COR_TNW, COR_TNE};
        BOTTOM_SHAPES = new VoxelShape[]{SIDE_BS, SIDE_BW, SIDE_BN, SIDE_BE, Shapes.or((VoxelShape)SIDE_BS, (VoxelShape)SIDE_BE), Shapes.or((VoxelShape)SIDE_BW, (VoxelShape)SIDE_BS), Shapes.or((VoxelShape)SIDE_BN, (VoxelShape)SIDE_BW), Shapes.or((VoxelShape)SIDE_BE, (VoxelShape)SIDE_BN), COR_BSE, COR_BSW, COR_BNW, COR_BNE};
        SHAPE_BY_STATE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 5, 6, 7, 4, 8, 9, 10, 11, 9, 10, 11, 8};
    }
}

