/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.PlatformOnly;
import dev.chililisoup.condiments.block.CondimentsRail;
import dev.chililisoup.condiments.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AnalogRailBlock
extends BaseRailBlock
implements CondimentsRail {
    public static final MapCodec<AnalogRailBlock> CODEC = AnalogRailBlock.simpleCodec(AnalogRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    @NotNull
    protected MapCodec<AnalogRailBlock> codec() {
        return CODEC;
    }

    public AnalogRailBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected int findAnalogRailSignal(Level level, BlockPos pos, BlockState state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8) {
            return 0;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        boolean ascending = true;
        RailShape railShape = (RailShape)state.getValue(SHAPE);
        switch (railShape) {
            case NORTH_SOUTH: {
                z = searchForward ? ++z : --z;
                ascending = false;
                break;
            }
            case EAST_WEST: {
                x = searchForward ? --x : ++x;
                ascending = false;
                break;
            }
            case ASCENDING_EAST: {
                if (searchForward) {
                    --x;
                } else {
                    ++x;
                    ++y;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (searchForward) {
                    --x;
                    ++y;
                } else {
                    ++x;
                }
                railShape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (searchForward) {
                    ++z;
                } else {
                    --z;
                    ++y;
                }
                railShape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (searchForward) {
                    ++z;
                    ++y;
                } else {
                    --z;
                }
                railShape = RailShape.NORTH_SOUTH;
            }
        }
        int flatSignal = this.getConnectedPower(level, new BlockPos(x, y, z), searchForward, recursionCount, railShape);
        if (flatSignal > 0) {
            return flatSignal;
        }
        if (ascending) {
            return 0;
        }
        return this.getConnectedPower(level, new BlockPos(x, y - 1, z), searchForward, recursionCount, railShape);
    }

    protected int getConnectedPower(Level level, BlockPos pos, boolean searchForward, int recursionCount, RailShape shape) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.is((Block)this)) {
            return 0;
        }
        RailShape railShape = (RailShape)blockState.getValue(SHAPE);
        if (shape == RailShape.EAST_WEST && (railShape == RailShape.NORTH_SOUTH || railShape == RailShape.ASCENDING_NORTH || railShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (railShape == RailShape.EAST_WEST || railShape == RailShape.ASCENDING_EAST || railShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        int power = (Integer)blockState.getValue((Property)POWER);
        if (power > 0) {
            int signal = level.getBestNeighborSignal(pos);
            if (signal > 14) {
                return signal;
            }
            return Math.max(this.findAnalogRailSignal(level, pos, blockState, searchForward, recursionCount + 1), signal);
        }
        return 0;
    }

    protected void updateState(BlockState state, Level level, BlockPos pos, Block neighborBlock) {
        int power = (Integer)state.getValue((Property)POWER);
        int signal = level.getBestNeighborSignal(pos);
        if (signal < 15) {
            int backward;
            int forward = this.findAnalogRailSignal(level, pos, state, true, 0);
            if (forward > signal) {
                signal = forward;
            }
            if (signal < 15 && (backward = this.findAnalogRailSignal(level, pos, state, false, 0)) > signal) {
                signal = backward;
            }
        }
        if (signal == power) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(signal)), 3);
        level.updateNeighborsAt(pos.below(), (Block)this);
        if (((RailShape)state.getValue(SHAPE)).isAscending()) {
            level.updateNeighborsAt(pos.above(), (Block)this);
        }
    }

    @NotNull
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)POWER);
    }

    public Property<Integer> getPowerProperty() {
        return POWER;
    }

    @Override
    public double getMaxSpeed(AbstractMinecart cart) {
        return (cart.isInWater() ? 0.5 : 1.0) * CommonConfig.ANALOG_RAIL_MAX_SPEED.get();
    }

    @Override
    public void moveAlongTrack(BlockPos pos, BlockState state, RailShape railShape, AbstractMinecart cart) {
        Vec3 movement = cart.getDeltaMovement();
        double x = movement.x;
        double z = movement.z;
        double horizontalDistance = movement.horizontalDistance();
        int power = (Integer)state.getValue(((AnalogRailBlock)state.getBlock()).getPowerProperty());
        if (power == 0) {
            if (horizontalDistance < 0.03) {
                cart.setDeltaMovement(Vec3.ZERO);
            } else {
                cart.setDeltaMovement(movement.multiply(0.5, 0.0, 0.5));
            }
            return;
        }
        if (horizontalDistance > 0.01) {
            double speed = (double)power * this.getMaxSpeed(cart) / 15.0;
            if (x > 0.01) {
                x = speed;
            } else if (x < -0.01) {
                x = -speed;
            }
            if (z > 0.01) {
                z = speed;
            } else if (z < -0.01) {
                z = -speed;
            }
            cart.setDeltaMovement(x, 0.0, z);
            return;
        }
        if (railShape == RailShape.EAST_WEST) {
            if (this.isRedstoneConductor(pos.west(), cart)) {
                x = 0.02;
            } else if (this.isRedstoneConductor(pos.east(), cart)) {
                x = -0.02;
            }
        } else {
            if (railShape != RailShape.NORTH_SOUTH) {
                return;
            }
            if (this.isRedstoneConductor(pos.north(), cart)) {
                z = 0.02;
            } else if (this.isRedstoneConductor(pos.south(), cart)) {
                z = -0.02;
            }
        }
        cart.setDeltaMovement(x, movement.y, z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, POWER, WATERLOGGED});
    }

    @PlatformOnly(value={"neoforge"})
    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return (float)this.getMaxSpeed(cart);
    }
}

