/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.chililisoup.condiments.block.IDestroyPreventable;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.reg.ModBlocks;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock
implements IDestroyPreventable {
    public static final MapCodec<CrateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(crateBlock -> Optional.ofNullable(crateBlock.color)), (App)CrateBlock.propertiesCodec()).apply((Applicative)instance, (optional, properties) -> new CrateBlock(optional.orElse(null), (BlockBehaviour.Properties)properties)));
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    @Nullable
    private final DyeColor color;

    @NotNull
    protected MapCodec<CrateBlock> codec() {
        return CODEC;
    }

    public CrateBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
    }

    public static BlockHitResult getHitResult(Level level, BlockPos pos, Entity player) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        return level.clip(new ClipContext(eyePos, eyePos.add(player.getViewVector(1.0f).scale(eyePos.distanceTo(Vec3.atCenterOf((Vec3i)pos)) + 1.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, player));
    }

    public static Optional<Vec2> getHitPosition(BlockHitResult hitResult, Direction face) {
        Direction direction = hitResult.getDirection();
        if (face != direction) {
            return Optional.empty();
        }
        BlockPos blockPos = hitResult.getBlockPos().relative(direction);
        Vec3 vec3 = hitResult.getLocation().subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        double x = vec3.x();
        double y = vec3.y();
        double z = vec3.z();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> Optional.of(new Vec2((float)x, (float)y));
            case Direction.WEST, Direction.EAST -> Optional.of(new Vec2((float)z, (float)y));
            case Direction.UP, Direction.DOWN -> Optional.of(new Vec2((float)x, (float)z));
        };
    }

    public static boolean isNotInBounds(Vec2 pos) {
        return (double)pos.x < 0.125 || (double)pos.x > 0.875 || (double)pos.y < 0.125 || (double)pos.y > 0.875;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean hitFace = hitResult.getDirection() == ((FrontAndTop)state.getValue(ORIENTATION)).front();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrateBlockEntity) || !hitFace) {
            return InteractionResult.PASS;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult, ((FrontAndTop)state.getValue(ORIENTATION)).front());
        if (hitPos.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            ((CrateBlockEntity)blockEntity).tryAddStack(ItemStack.EMPTY, player);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean hitFace = hitResult.getDirection() == ((FrontAndTop)state.getValue(ORIENTATION)).front();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrateBlockEntity) || !hitFace) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult, ((FrontAndTop)state.getValue(ORIENTATION)).front());
        if (hitPos.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            player.setItemInHand(hand, ((CrateBlockEntity)blockEntity).tryAddStack(player.getItemInHand(hand), player));
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        ItemEntity itemEntity;
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrateBlockEntity)) {
            return;
        }
        CrateBlockEntity crateBlockEntity = (CrateBlockEntity)blockEntity;
        BlockHitResult hitResult = CrateBlock.getHitResult(level, pos, (Entity)player);
        if (hitResult.getDirection() != ((FrontAndTop)state.getValue(ORIENTATION)).front()) {
            return;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult, ((FrontAndTop)state.getValue(ORIENTATION)).front());
        if (hitPos.isEmpty()) {
            return;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return;
        }
        ItemStack itemStack = player.isShiftKeyDown() ? crateBlockEntity.requestOneStack() : crateBlockEntity.requestOne();
        player.addItem(itemStack);
        if (itemStack.getCount() > 0 && (itemEntity = player.drop(itemStack, false)) != null) {
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(player.getUUID());
        }
    }

    private boolean shouldPreventDamage(BlockState state, Player player, BlockPos pos) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (!(blockEntity instanceof CrateBlockEntity)) {
            return false;
        }
        BlockHitResult hitResult = CrateBlock.getHitResult(player.level(), pos, (Entity)player);
        if (hitResult.getDirection() != ((FrontAndTop)state.getValue(ORIENTATION)).front()) {
            return false;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult, ((FrontAndTop)state.getValue(ORIENTATION)).front());
        return hitPos.filter(vec2 -> !CrateBlock.isNotInBounds(vec2)).isPresent();
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return this.shouldPreventDamage(state, player, pos) ? 0.0f : super.getDestroyProgress(state, player, level, pos);
    }

    @Override
    public boolean shouldCancelDestroy(BlockState state, Level level, BlockPos pos, Player player, Direction direction) {
        ItemEntity itemEntity;
        if (!player.isCreative()) {
            return false;
        }
        if (direction != ((FrontAndTop)state.getValue(ORIENTATION)).front()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrateBlockEntity)) {
            return false;
        }
        CrateBlockEntity crateBlockEntity = (CrateBlockEntity)blockEntity;
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(CrateBlock.getHitResult(level, pos, (Entity)player), ((FrontAndTop)state.getValue(ORIENTATION)).front());
        if (hitPos.isEmpty()) {
            return false;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return false;
        }
        if (level.isClientSide) {
            return true;
        }
        ItemStack itemStack = player.isShiftKeyDown() ? crateBlockEntity.requestOneStack() : crateBlockEntity.requestOne();
        player.addItem(itemStack);
        if (itemStack.getCount() > 0 && (itemEntity = player.drop(itemStack, false)) != null) {
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(player.getUUID());
        }
        return true;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide && player.isCreative() && !((CrateBlockEntity)Objects.requireNonNull(level.getBlockEntity(pos))).isEmpty()) {
            Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos)).forEach(drop -> {
                ItemEntity ent = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                ent.setDefaultPickUpDelay();
                ent.setDeltaMovement(0.0, 0.0, 0.0);
                level.addFreshEntity((Entity)ent);
            });
        }
        return state;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CrateBlockEntity) {
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Nullable
    public static DyeColor getColorFromItem(Item item) {
        return CrateBlock.getColorFromBlock(Block.byItem((Item)item));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block block) {
        return block instanceof CrateBlock ? ((CrateBlock)block).getColor() : null;
    }

    public static Block getBlockByColor(@Nullable DyeColor color) {
        if (color == null) {
            return ModBlocks.CRATE.get();
        }
        return switch (color) {
            case DyeColor.WHITE -> ModBlocks.WHITE_CRATE.get();
            case DyeColor.LIGHT_GRAY -> ModBlocks.LIGHT_GRAY_CRATE.get();
            case DyeColor.GRAY -> ModBlocks.GRAY_CRATE.get();
            case DyeColor.BLACK -> ModBlocks.BLACK_CRATE.get();
            case DyeColor.BROWN -> ModBlocks.BROWN_CRATE.get();
            case DyeColor.RED -> ModBlocks.RED_CRATE.get();
            case DyeColor.ORANGE -> ModBlocks.ORANGE_CRATE.get();
            case DyeColor.YELLOW -> ModBlocks.YELLOW_CRATE.get();
            case DyeColor.LIME -> ModBlocks.LIME_CRATE.get();
            case DyeColor.GREEN -> ModBlocks.GREEN_CRATE.get();
            case DyeColor.CYAN -> ModBlocks.CYAN_CRATE.get();
            case DyeColor.LIGHT_BLUE -> ModBlocks.LIGHT_BLUE_CRATE.get();
            case DyeColor.BLUE -> ModBlocks.BLUE_CRATE.get();
            case DyeColor.PURPLE -> ModBlocks.PURPLE_CRATE.get();
            case DyeColor.MAGENTA -> ModBlocks.MAGENTA_CRATE.get();
            default -> ModBlocks.PINK_CRATE.get();
        };
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor color) {
        return new ItemStack((ItemLike)CrateBlock.getBlockByColor(color));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CrateBlockEntity.of(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction front = context.getNearestLookingDirection().getOpposite();
        Direction top = switch (front) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> context.getHorizontalDirection().getOpposite();
            case Direction.UP -> context.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)front, (Direction)top));
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)rotation.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)mirror.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIENTATION});
    }
}

