/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneLedBlock
extends Block {
    public static final MapCodec<RedstoneLedBlock> CODEC = RedstoneLedBlock.simpleCodec(RedstoneLedBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    private static final Vec3[] COLORS = new Vec3[]{new Vec3(0.125, 0.125, 0.125), new Vec3(0.0, 0.0, 0.6666666666666666), new Vec3(0.0, 0.6666666666666666, 0.0), new Vec3(0.0, 0.6666666666666666, 0.6666666666666666), new Vec3(0.6666666666666666, 0.0, 0.0), new Vec3(0.6666666666666666, 0.0, 0.6666666666666666), new Vec3(1.0, 0.6666666666666666, 0.0), new Vec3(0.6666666666666666, 0.6666666666666666, 0.6666666666666666), new Vec3(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Vec3(0.3333333333333333, 0.3333333333333333, 1.0), new Vec3(0.3333333333333333, 1.0, 0.3333333333333333), new Vec3(0.3333333333333333, 1.0, 1.0), new Vec3(1.0, 0.3333333333333333, 0.3333333333333333), new Vec3(1.0, 0.3333333333333333, 1.0), new Vec3(1.0, 1.0, 0.3333333333333333), new Vec3(1.0, 1.0, 1.0)};

    @NotNull
    protected MapCodec<RedstoneLedBlock> codec() {
        return CODEC;
    }

    public RedstoneLedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        int power = level.getBestNeighborSignal(pos);
        if (power == (Integer)state.getValue((Property)POWER)) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(context.getLevel().getBestNeighborSignal(context.getClickedPos())));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)POWER);
    }

    public Property<Integer> getPowerProperty() {
        return POWER;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER});
    }

    public static int getColorForPower(int power) {
        Vec3 vec3 = COLORS[power];
        return Mth.color((float)((float)vec3.x()), (float)((float)vec3.y()), (float)((float)vec3.z()));
    }
}

